/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements;

import java.util.Set;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.californium.elements.MapBasedEndpointContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndpointContextUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(EndpointContextUtil.class);

    public static boolean match(String name, Set<String> keys, EndpointContext context1, EndpointContext context2) {
        boolean warn = LOGGER.isWarnEnabled();
        boolean trace = LOGGER.isTraceEnabled();
        boolean matchAll = true;
        for (String key : keys) {
            String value2;
            boolean match;
            String value1 = context1.get(key);
            boolean bl = match = value1 == (value2 = context2.get(key)) || null != value1 && value1.equals(value2);
            if (!match && !warn) {
                return false;
            }
            if (!match) {
                LOGGER.warn("{}, {}: \"{}\" != \"{}\"", new Object[]{name, key, value1, value2});
            } else if (trace) {
                LOGGER.trace("{}, {}: \"{}\" == \"{}\"", new Object[]{name, key, value1, value2});
            }
            matchAll = matchAll && match;
        }
        return matchAll;
    }

    public static EndpointContext getFollowUpEndpointContext(EndpointContext messageContext, EndpointContext connectionContext) {
        String mode = messageContext.get("*DTLS_HANDSHAKE_MODE");
        EndpointContext followUpEndpointContext = mode != null && mode.equals("none") ? MapBasedEndpointContext.addEntries(connectionContext, "*DTLS_HANDSHAKE_MODE", "none") : connectionContext;
        return followUpEndpointContext;
    }
}

