/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.pdftk_java.com.lowagie.text.pdf;

import com.gitlab.pdftk_java.com.lowagie.text.pdf.SimpleXMLDocHandler;
import com.gitlab.pdftk_java.com.lowagie.text.pdf.SimpleXMLParser;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;

public class XfdfReader
implements SimpleXMLDocHandler {
    private boolean foundRoot = false;
    private Stack fieldNames = new Stack();
    private Stack fieldValues = new Stack();
    HashMap fields;
    protected HashMap listFields;
    HashMap fieldsRichText;
    HashMap<String, ArrayList<String>> fieldsMultiValue;
    String fileSpec;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XfdfReader(String filename) throws IOException {
        InputStream fin = null;
        try {
            fin = filename.equals("-") ? System.in : new FileInputStream(filename);
            SimpleXMLParser.parse((SimpleXMLDocHandler)this, fin);
        }
        finally {
            try {
                fin.close();
            }
            catch (Exception exception) {}
        }
    }

    public XfdfReader(InputStream fin) throws IOException {
        try {
            SimpleXMLParser.parse((SimpleXMLDocHandler)this, fin);
        }
        finally {
            try {
                fin.close();
            }
            catch (Exception exception) {}
        }
    }

    public XfdfReader(byte[] xfdfIn) throws IOException {
        SimpleXMLParser.parse((SimpleXMLDocHandler)this, new ByteArrayInputStream(xfdfIn));
    }

    public HashMap getFields() {
        return this.fields;
    }

    public String getField(String name) {
        return (String)this.fields.get(name);
    }

    public String getFieldValue(String name) {
        String field = (String)this.fields.get(name);
        if (field == null) {
            return null;
        }
        return field;
    }

    public List getListValues(String name) {
        return (List)this.listFields.get(name);
    }

    public String getFieldRichValue(String name) {
        String field = (String)this.fieldsRichText.get(name);
        if (field == null) {
            return null;
        }
        return field;
    }

    public String getFileSpec() {
        return this.fileSpec;
    }

    @Override
    public void startElement(String tag, HashMap h) {
        if (!this.foundRoot) {
            if (!tag.equals("xfdf")) {
                throw new RuntimeException("Root element is not Bookmark.");
            }
            this.foundRoot = true;
        }
        if (!tag.equals("xfdf")) {
            if (tag.equals("f")) {
                this.fileSpec = (String)h.get("href");
            } else if (tag.equals("fields")) {
                this.fields = new HashMap();
                this.listFields = new HashMap();
                this.fieldsRichText = new HashMap();
            } else if (tag.equals("field")) {
                String fName = (String)h.get("name");
                this.fieldNames.push(fName);
            } else if (tag.equals("value") || tag.equals("value-richtext")) {
                this.fieldValues.push("");
            }
        }
    }

    @Override
    public void endElement(String tag) {
        if (tag.equals("value") || tag.equals("value-richtext")) {
            String fName = "";
            for (int k = 0; k < this.fieldNames.size(); ++k) {
                fName = fName + "." + (String)this.fieldNames.elementAt(k);
            }
            if (fName.startsWith(".")) {
                fName = fName.substring(1);
            }
            String fVal = (String)this.fieldValues.pop();
            if (tag.equals("value")) {
                String old = this.fields.put(fName, fVal);
                if (old != null) {
                    ArrayList<String> l = (ArrayList<String>)this.listFields.get(fName);
                    if (l == null) {
                        l = new ArrayList<String>();
                        l.add(old);
                    }
                    l.add(fVal);
                    this.listFields.put(fName, l);
                }
            } else {
                this.fieldsRichText.put(fName, fVal);
            }
        } else if (tag.equals("field") && !this.fieldNames.isEmpty()) {
            this.fieldNames.pop();
        }
    }

    @Override
    public void startDocument() {
        this.fileSpec = new String("");
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void text(String str) {
        if (this.fieldNames.isEmpty() || this.fieldValues.isEmpty()) {
            return;
        }
        String val = (String)this.fieldValues.pop();
        val = val + str;
        this.fieldValues.push(val);
    }
}

