/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.client;

import com.thaiopensource.relaxng.exceptions.BadAttributeValueException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.json.Json;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonWriter;
import nu.validator.datatype.Html5DatatypeException;
import nu.validator.messages.MessageEmitterAdapter;
import nu.validator.validation.SimpleDocumentValidator;
import org.relaxng.datatype.DatatypeException;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class TestRunner
extends MessageEmitterAdapter {
    private boolean inError = false;
    private boolean emitMessages = false;
    private boolean exceptionIsWarning = false;
    private boolean expectingError = false;
    private Exception exception = null;
    private SimpleDocumentValidator validator;
    private PrintWriter err;
    private PrintWriter out;
    private String schema = "http://s.validator.nu/html5-all.rnc";
    private boolean failed = false;
    private static File messagesFile;
    private static String[] ignoreList;
    private static boolean writeMessages;
    private static boolean verbose;
    private File baseDir = null;
    private Map<String, JsonString> expectedMessages;
    private JsonObjectBuilder reportedMessages = Json.createObjectBuilder();

    public TestRunner() throws IOException {
        this.validator = new SimpleDocumentValidator(true, false, true);
        try {
            this.err = new PrintWriter(new OutputStreamWriter((OutputStream)System.err, "UTF-8"));
            this.out = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, "UTF-8"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private URL getFileURL(File file) throws MalformedURLException {
        return file.toURI().toURL();
    }

    private String getRelativePathname(File file, File baseDir) throws MalformedURLException {
        String filePath = this.getFileURL(file).getPath();
        String baseDirPath = this.getFileURL(baseDir).getPath();
        return filePath.substring(baseDirPath.length());
    }

    private void checkHtmlFile(File file) throws IOException, SAXException {
        if (!file.exists()) {
            if (verbose) {
                this.out.println(String.format("\"%s\": warning: File not found.", this.getFileURL(file)));
                this.out.flush();
            }
            return;
        }
        if (verbose) {
            this.out.println(file);
            this.out.flush();
        }
        if (this.isHtml(file)) {
            this.validator.checkHtmlFile(file, true);
        } else if (this.isXhtml(file)) {
            this.validator.checkXmlFile(file);
        } else if (verbose) {
            this.out.println(String.format("\"%s\": warning: File was not checked. Files must have a .html, .xhtml, .htm, or .xht extension.", this.getFileURL(file)));
            this.out.flush();
        }
    }

    private boolean isXhtml(File file) {
        String name = file.getName();
        return name.endsWith(".xhtml") || name.endsWith(".xht");
    }

    private boolean isHtml(File file) {
        String name = file.getName();
        return name.endsWith(".html") || name.endsWith(".htm");
    }

    private boolean isCheckableFile(File file) {
        return file.isFile() && (this.isHtml(file) || this.isXhtml(file));
    }

    private void recurseDirectory(File directory) throws SAXException, IOException {
        File[] files;
        for (File file : files = directory.listFiles()) {
            if (file.isDirectory()) {
                this.recurseDirectory(file);
                continue;
            }
            this.checkHtmlFile(file);
        }
    }

    private boolean isIgnorable(File file) throws IOException {
        String testPathname = this.getRelativePathname(file, this.baseDir);
        if (ignoreList != null) {
            for (String substring : ignoreList) {
                if (!testPathname.contains(substring)) continue;
                if (verbose) {
                    this.out.println(String.format("\"%s\": warning: File ignored.", this.getFileURL(file)));
                    this.out.flush();
                }
                return true;
            }
        }
        return false;
    }

    private void checkFiles(List<File> files) throws IOException {
        for (File file : files) {
            if (this.isIgnorable(file)) continue;
            this.reset();
            this.emitMessages = true;
            try {
                if (file.isDirectory()) {
                    this.recurseDirectory(file);
                } else {
                    this.checkHtmlFile(file);
                }
            }
            catch (IOException | SAXException exception) {
                // empty catch block
            }
            if (!this.inError) continue;
            this.failed = true;
        }
    }

    private boolean messageMatches(String testFilename) {
        String messageReported = this.exception.getMessage().replaceAll("\\p{C}", "?");
        String messageExpected = this.expectedMessages.get(testFilename).getString().replaceAll("\\p{C}", "?");
        Pattern p = Pattern.compile("(Bad datetime with timezone: .+) (Bad date: .+)");
        messageExpected = p.matcher(messageExpected).replaceAll("$2 $1");
        messageReported = p.matcher(messageReported).replaceAll("$2 $1");
        return messageReported.equals(messageExpected);
    }

    private void checkInvalidFiles(List<File> files) throws IOException {
        this.expectingError = true;
        for (File file : files) {
            if (this.isIgnorable(file)) continue;
            this.reset();
            try {
                if (file.isDirectory()) {
                    this.recurseDirectory(file);
                } else {
                    this.checkHtmlFile(file);
                }
            }
            catch (IOException | SAXException exception) {
                // empty catch block
            }
            if (this.exception != null) {
                String testFilename = this.getRelativePathname(file, this.baseDir);
                if (writeMessages) {
                    this.reportedMessages.add(testFilename, this.exception.getMessage());
                } else {
                    if (this.expectedMessages != null && this.expectedMessages.get(testFilename) == null) {
                        try {
                            this.err.println(String.format("\"%s\": warning: No expected message in messages file.", this.getFileURL(file)));
                            this.err.flush();
                        }
                        catch (MalformedURLException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    if (this.expectedMessages != null && !this.messageMatches(testFilename)) {
                        this.failed = true;
                        try {
                            this.err.println(String.format("\"%s\": error: Expected \"%s\" but instead encountered \"%s\".", this.getFileURL(file), this.expectedMessages.get(testFilename), this.exception.getMessage()));
                            this.err.flush();
                        }
                        catch (MalformedURLException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            }
            if (this.inError) continue;
            this.failed = true;
            try {
                this.err.println(String.format("\"%s\": error: Expected an error but did not encounter any.", this.getFileURL(file)));
                this.err.flush();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void checkHasWarningFiles(List<File> files) throws IOException {
        this.expectingError = false;
        for (File file : files) {
            if (this.isIgnorable(file)) continue;
            this.reset();
            try {
                if (file.isDirectory()) {
                    this.recurseDirectory(file);
                } else {
                    this.checkHtmlFile(file);
                }
            }
            catch (IOException | SAXException exception) {
                // empty catch block
            }
            if (this.exception != null) {
                String testFilename = this.getRelativePathname(file, this.baseDir);
                if (writeMessages) {
                    this.reportedMessages.add(testFilename, this.exception.getMessage());
                } else {
                    if (this.expectedMessages != null && this.expectedMessages.get(testFilename) == null) {
                        try {
                            this.err.println(String.format("\"%s\": warning: No expected message in messages file.", this.getFileURL(file)));
                            this.err.flush();
                        }
                        catch (MalformedURLException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    if (this.expectedMessages != null && !this.messageMatches(testFilename)) {
                        try {
                            this.err.println(String.format("\"%s\": error: Expected \"%s\" but instead encountered \"%s\".", this.getFileURL(file), this.expectedMessages.get(testFilename), this.exception.getMessage()));
                            this.err.flush();
                        }
                        catch (MalformedURLException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            }
            if (this.inError) {
                this.failed = true;
                try {
                    this.err.println(String.format("\"%s\": error: Expected a warning but encountered an error first.", this.getFileURL(file)));
                    this.err.flush();
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }
            if (!this.exceptionIsWarning) {
                try {
                    this.err.println(String.format("\"%s\": error: Expected a warning but did not encounter any.", this.getFileURL(file)));
                    this.err.flush();
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }
            if (!this.inError) continue;
            this.failed = true;
            try {
                this.err.println(String.format("\"%s\": error: Expected a warning only but encountered at least one error.", this.getFileURL(file)));
                this.err.flush();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void checkTestDirectoryAgainstSchema(File directory, String schemaUrl) throws SAXException, Exception {
        this.validator.setUpMainSchema(schemaUrl, this);
        this.checkTestFiles(directory, State.EXPECTING_ANYTHING);
    }

    private void checkTestFiles(File directory, State state) throws SAXException, IOException {
        File[] files = directory.listFiles();
        ArrayList<File> validFiles = new ArrayList<File>();
        ArrayList<File> invalidFiles = new ArrayList<File>();
        ArrayList<File> hasWarningFiles = new ArrayList<File>();
        if (files == null) {
            if (verbose) {
                try {
                    this.out.println(String.format("\"%s\": warning: No files found in directory.", this.getFileURL(directory)));
                    this.out.flush();
                }
                catch (MalformedURLException mue) {
                    throw new RuntimeException(mue);
                }
            }
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                if (state != State.EXPECTING_ANYTHING) {
                    this.checkTestFiles(file, state);
                    continue;
                }
                if ("invalid".equals(file.getName())) {
                    this.checkTestFiles(file, State.EXPECTING_INVALID_FILES);
                    continue;
                }
                if ("valid".equals(file.getName())) {
                    this.checkTestFiles(file, State.EXPECTING_VALID_FILES);
                    continue;
                }
                this.checkTestFiles(file, State.EXPECTING_ANYTHING);
                continue;
            }
            if (!this.isCheckableFile(file)) continue;
            if (state == State.EXPECTING_INVALID_FILES) {
                invalidFiles.add(file);
                continue;
            }
            if (state == State.EXPECTING_VALID_FILES) {
                validFiles.add(file);
                continue;
            }
            if (file.getPath().indexOf("novalid") > 0) {
                invalidFiles.add(file);
                continue;
            }
            if (file.getPath().indexOf("haswarn") > 0) {
                hasWarningFiles.add(file);
                continue;
            }
            validFiles.add(file);
        }
        if (validFiles.size() > 0) {
            this.validator.setUpValidatorAndParsers(this, false, false);
            this.checkFiles(validFiles);
        }
        if (invalidFiles.size() > 0) {
            this.validator.setUpValidatorAndParsers(this, false, false);
            this.checkInvalidFiles(invalidFiles);
        }
        if (hasWarningFiles.size() > 0) {
            this.validator.setUpValidatorAndParsers(this, false, false);
            this.checkHasWarningFiles(hasWarningFiles);
        }
    }

    public boolean runTestSuite() throws SAXException, Exception {
        if (messagesFile != null) {
            this.baseDir = messagesFile.getCanonicalFile().getParentFile();
            File[] fis = new FileInputStream(messagesFile);
            JsonReader reader = Json.createReader((InputStream)fis);
            this.expectedMessages = reader.readObject();
        } else {
            this.baseDir = new File(System.getProperty("user.dir"));
        }
        for (File directory : this.baseDir.listFiles()) {
            if (!directory.isDirectory()) continue;
            if (directory.getName().contains("rdfalite")) {
                this.checkTestDirectoryAgainstSchema(directory, "http://s.validator.nu/html5-rdfalite.rnc");
                continue;
            }
            if (directory.getName().contains("xhtml")) {
                this.checkTestDirectoryAgainstSchema(directory, "http://s.validator.nu/xhtml5-all.rnc");
                continue;
            }
            this.checkTestDirectoryAgainstSchema(directory, this.schema);
        }
        if (writeMessages) {
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(messagesFile), "utf-8");
            try (BufferedWriter bw = new BufferedWriter(out);){
                JsonWriter jsonWriter = Json.createWriter(bw);
                jsonWriter.writeObject(this.reportedMessages.build());
                jsonWriter.close();
            }
        }
        if (verbose) {
            if (this.failed) {
                this.out.println("Failure!");
                this.out.flush();
            } else {
                this.out.println("Success!");
                this.out.flush();
            }
        }
        return !this.failed;
    }

    private void emitMessage(SAXParseException e, String messageType) {
        String systemId = e.getSystemId();
        this.err.write(systemId == null ? "" : '\"' + systemId + '\"');
        this.err.write(":");
        this.err.write(Integer.toString(e.getLineNumber()));
        this.err.write(":");
        this.err.write(Integer.toString(e.getColumnNumber()));
        this.err.write(": ");
        this.err.write(messageType);
        this.err.write(": ");
        this.err.write(e.getMessage());
        this.err.write("\n");
        this.err.flush();
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        if (DEFAULT_FILTER_PATTERN.matcher(e.getMessage()).matches()) {
            return;
        }
        if (this.emitMessages) {
            this.emitMessage(e, "warning");
        } else if (this.exception == null && !this.expectingError) {
            this.exception = e;
            this.exceptionIsWarning = true;
        }
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        if (DEFAULT_FILTER_PATTERN.matcher(e.getMessage()).matches()) {
            return;
        }
        if (this.emitMessages) {
            this.emitMessage(e, "error");
        } else if (this.exception == null) {
            this.exception = e;
            if (e instanceof BadAttributeValueException) {
                BadAttributeValueException ex = (BadAttributeValueException)e;
                Map datatypeErrors = ex.getExceptions();
                for (Map.Entry entry : datatypeErrors.entrySet()) {
                    Html5DatatypeException ex5;
                    DatatypeException dex = (DatatypeException)entry.getValue();
                    if (!(dex instanceof Html5DatatypeException) || !(ex5 = (Html5DatatypeException)dex).isWarning()) continue;
                    this.exceptionIsWarning = true;
                    return;
                }
            }
        }
        this.inError = true;
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        this.inError = true;
        if (this.emitMessages) {
            this.emitMessage(e, "fatal error");
            return;
        }
        if (this.exception == null) {
            this.exception = e;
        }
    }

    public void reset() {
        this.exception = null;
        this.inError = false;
        this.emitMessages = false;
        this.exceptionIsWarning = false;
    }

    public static void main(String[] args) throws SAXException, Exception {
        if (args.length < 1) {
            TestRunner.usage();
            System.exit(0);
        }
        verbose = false;
        String messagesFilename = null;
        System.setProperty("nu.validator.datatype.warn", "true");
        for (String arg : args) {
            if ("--verbose".equals(arg)) {
                verbose = true;
                continue;
            }
            if ("--errors-only".equals(arg)) {
                System.setProperty("nu.validator.datatype.warn", "false");
                continue;
            }
            if ("--write-messages".equals(arg)) {
                writeMessages = true;
                continue;
            }
            if (arg.startsWith("--ignore=")) {
                ignoreList = arg.substring(9, arg.length()).split(",");
                continue;
            }
            if (arg.startsWith("--")) {
                System.out.println(String.format("\nError: There is no option \"%s\".", arg));
                TestRunner.usage();
                System.exit(1);
                continue;
            }
            if (arg.endsWith(".json")) {
                messagesFilename = arg;
                continue;
            }
            System.out.println("\nError: Expected the name of a messages file with a .json extension.");
            TestRunner.usage();
            System.exit(1);
        }
        if (messagesFilename != null) {
            messagesFile = new File(messagesFilename);
            if (!messagesFile.exists()) {
                System.out.println("\nError: \"" + messagesFilename + "\" file not found.");
                System.exit(1);
            } else if (!messagesFile.isFile()) {
                System.out.println("\nError: \"" + messagesFilename + "\" is not a file.");
                System.exit(1);
            }
        } else if (writeMessages) {
            System.out.println("\nError: Expected the name of a messages file with a .json extension.");
            TestRunner.usage();
            System.exit(1);
        }
        TestRunner tr = new TestRunner();
        if (tr.runTestSuite()) {
            System.exit(0);
        } else {
            System.exit(1);
        }
    }

    private static void usage() {
        System.out.println("\nUsage:");
        System.out.println("\n    java nu.validator.client.TestRunner [--errors-only] [--write-messages]");
        System.out.println("          [--verbose] [MESSAGES.json]");
        System.out.println("\n...where the MESSAGES.json file contains name/value pairs in which the name is");
        System.out.println("a pathname of a document to check and the value is the first error message or");
        System.out.println("warning message the validator is expected to report when checking that document.");
        System.out.println("Use the --write-messages option to create the file.");
    }

    static {
        ignoreList = null;
    }

    private static enum State {
        EXPECTING_INVALID_FILES,
        EXPECTING_VALID_FILES,
        EXPECTING_ANYTHING;

    }
}

