'''OpenGL extension EXT.fragment_shading_rate

This module customises the behaviour of the 
OpenGL.raw.GLES2.EXT.fragment_shading_rate to provide a more 
Python-friendly API

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/EXT/fragment_shading_rate.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES2 import _types, _glgets
from OpenGL.raw.GLES2.EXT.fragment_shading_rate import *
from OpenGL.raw.GLES2.EXT.fragment_shading_rate import _EXTENSION_NAME

def glInitFragmentShadingRateEXT():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

# INPUT glGetFragmentShadingRatesEXT.shadingRates size not checked against maxCount
glGetFragmentShadingRatesEXT=wrapper.wrapper(glGetFragmentShadingRatesEXT).setInputArraySize(
    'count', 1
).setInputArraySize(
    'shadingRates', None
)
### END AUTOGENERATED SECTION