#
# diffoscope: in-depth comparison of files, archives, and directories
#
# Copyright © 2021 Chris Lamb <lamby@debian.org>
#
# diffoscope is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# diffoscope is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with diffoscope.  If not, see <https://www.gnu.org/licenses/>.

from diffoscope.tools import tool_required
from diffoscope.difference import Difference

from .utils.file import File
from .utils.command import Command

XMLB_MAGIC = b"XMLb"


class XbTool(Command):
    @tool_required("xb-tool")
    def cmdline(self):
        return ["xb-tool", "dump", self.path]


class XMLBFile(File):
    DESCRIPTION = "XMLB files"
    FILE_EXTENSION_SUFFIX = {".xb"}

    @classmethod
    def recognizes(cls, file):
        if not super().recognizes(file):
            return False

        return file.file_header.startswith(XMLB_MAGIC)

    def compare_details(self, other, source=None):
        return [Difference.from_operation(XbTool, self.path, other.path)]
