/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;

public class FontRenderContext {
    private transient AffineTransform tx;
    private transient Object aaHintValue;
    private transient Object fmHintValue;
    private transient boolean defaulting;

    protected FontRenderContext() {
        this.aaHintValue = RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT;
        this.fmHintValue = RenderingHints.VALUE_FRACTIONALMETRICS_DEFAULT;
        this.defaulting = true;
    }

    public FontRenderContext(AffineTransform affineTransform, boolean bl, boolean bl2) {
        if (affineTransform != null && !affineTransform.isIdentity()) {
            this.tx = new AffineTransform(affineTransform);
        }
        this.aaHintValue = bl ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF;
        this.fmHintValue = bl2 ? RenderingHints.VALUE_FRACTIONALMETRICS_ON : RenderingHints.VALUE_FRACTIONALMETRICS_OFF;
    }

    public FontRenderContext(AffineTransform affineTransform, Object object, Object object2) {
        if (affineTransform != null && !affineTransform.isIdentity()) {
            this.tx = new AffineTransform(affineTransform);
        }
        try {
            if (!RenderingHints.KEY_TEXT_ANTIALIASING.isCompatibleValue(object)) {
                throw new IllegalArgumentException("AA hint:" + object);
            }
            this.aaHintValue = object;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("AA hint:" + object);
        }
        try {
            if (!RenderingHints.KEY_FRACTIONALMETRICS.isCompatibleValue(object2)) {
                throw new IllegalArgumentException("FM hint:" + object2);
            }
            this.fmHintValue = object2;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("FM hint:" + object2);
        }
    }

    public boolean isTransformed() {
        if (!this.defaulting) {
            return this.tx != null;
        }
        return !this.getTransform().isIdentity();
    }

    public int getTransformType() {
        if (!this.defaulting) {
            if (this.tx == null) {
                return 0;
            }
            return this.tx.getType();
        }
        return this.getTransform().getType();
    }

    public AffineTransform getTransform() {
        return this.tx == null ? new AffineTransform() : new AffineTransform(this.tx);
    }

    public boolean isAntiAliased() {
        return this.aaHintValue != RenderingHints.VALUE_TEXT_ANTIALIAS_OFF && this.aaHintValue != RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT;
    }

    public boolean usesFractionalMetrics() {
        return this.fmHintValue != RenderingHints.VALUE_FRACTIONALMETRICS_OFF && this.fmHintValue != RenderingHints.VALUE_FRACTIONALMETRICS_DEFAULT;
    }

    public Object getAntiAliasingHint() {
        if (this.defaulting) {
            if (this.isAntiAliased()) {
                return RenderingHints.VALUE_TEXT_ANTIALIAS_ON;
            }
            return RenderingHints.VALUE_TEXT_ANTIALIAS_OFF;
        }
        return this.aaHintValue;
    }

    public Object getFractionalMetricsHint() {
        if (this.defaulting) {
            if (this.usesFractionalMetrics()) {
                return RenderingHints.VALUE_FRACTIONALMETRICS_ON;
            }
            return RenderingHints.VALUE_FRACTIONALMETRICS_OFF;
        }
        return this.fmHintValue;
    }

    public boolean equals(Object object) {
        try {
            return this.equals((FontRenderContext)object);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public boolean equals(FontRenderContext fontRenderContext) {
        if (this == fontRenderContext) {
            return true;
        }
        if (fontRenderContext == null) {
            return false;
        }
        if (!fontRenderContext.defaulting && !this.defaulting) {
            if (fontRenderContext.aaHintValue == this.aaHintValue && fontRenderContext.fmHintValue == this.fmHintValue) {
                return this.tx == null ? fontRenderContext.tx == null : this.tx.equals(fontRenderContext.tx);
            }
            return false;
        }
        return fontRenderContext.getAntiAliasingHint() == this.getAntiAliasingHint() && fontRenderContext.getFractionalMetricsHint() == this.getFractionalMetricsHint() && fontRenderContext.getTransform().equals(this.getTransform());
    }

    public int hashCode() {
        int n;
        int n2 = n = this.tx == null ? 0 : this.tx.hashCode();
        if (this.defaulting) {
            n += this.getAntiAliasingHint().hashCode();
            n += this.getFractionalMetricsHint().hashCode();
        } else {
            n += this.aaHintValue.hashCode();
            n += this.fmHintValue.hashCode();
        }
        return n;
    }
}

