/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.ui.memory;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.table.TableCellRenderer;
import org.graalvm.visualvm.lib.jfluid.results.ExportDataDumper;
import org.graalvm.visualvm.lib.jfluid.results.memory.AllocMemoryResultsDiff;
import org.graalvm.visualvm.lib.jfluid.results.memory.AllocMemoryResultsSnapshot;
import org.graalvm.visualvm.lib.profiler.api.GoToSource;
import org.graalvm.visualvm.lib.ui.components.table.ClassNameTableCellRenderer;
import org.graalvm.visualvm.lib.ui.components.table.CustomBarCellRenderer;
import org.graalvm.visualvm.lib.ui.components.table.DiffBarCellRenderer;
import org.graalvm.visualvm.lib.ui.components.table.LabelTableCellRenderer;
import org.graalvm.visualvm.lib.ui.memory.MemoryResUserActionsHandler;
import org.graalvm.visualvm.lib.ui.memory.SnapshotAllocResultsPanel;

public class DiffAllocResultsPanel
extends SnapshotAllocResultsPanel {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.graalvm.visualvm.lib.ui.memory.Bundle");
    private static final String GO_SOURCE_POPUP_ITEM_NAME = messages.getString("AllocResultsPanel_GoSourcePopupItemName");
    private AllocMemoryResultsDiff diff;
    private JMenuItem popupShowSource;
    private JPopupMenu memoryResPopupMenu;

    public DiffAllocResultsPanel(AllocMemoryResultsSnapshot snapshot, MemoryResUserActionsHandler actionsHandler) {
        super(snapshot, actionsHandler);
        this.diff = (AllocMemoryResultsDiff)snapshot;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.popupShowSource && this.popupShowSource != null) {
            this.performDefaultAction(-1);
        }
    }

    @Override
    public void exportData(int typeOfFile, ExportDataDumper eDD, String viewName) {
        switch (typeOfFile) {
            case 1: {
                this.exportCSV(",", eDD);
                break;
            }
            case 2: {
                this.exportCSV(";", eDD);
                break;
            }
            case 3: {
                this.exportXML(eDD, viewName);
                break;
            }
            case 4: {
                this.exportHTML(eDD, viewName);
            }
        }
    }

    private void exportHTML(ExportDataDumper eDD, String viewName) {
        int i;
        StringBuffer result = new StringBuffer("<HTML><HEAD><meta http-equiv=\"Content-type\" content=\"text/html; charset=utf-8\" /><TITLE>" + viewName + "</TITLE></HEAD><BODY><TABLE border=\"1\"><tr>");
        for (i = 0; i < this.columnNames.length; ++i) {
            if (this.columnRenderers[i] == null) continue;
            result.append("<th>").append(this.columnNames[i]).append("</th>");
        }
        result.append("</tr>");
        eDD.dumpData((CharSequence)result);
        for (i = 0; i < this.nTrackedItems; ++i) {
            result = new StringBuffer("<tr><td>" + this.replaceHTMLCharacters(this.sortedClassNames[i]) + "</td>");
            result.append("<td align=\"right\">").append(this.totalAllocObjectsSize[i]).append("</td>");
            result.append("<td align=\"right\">").append(this.nTotalAllocObjects[i]).append("</td></tr>");
            eDD.dumpData((CharSequence)result);
        }
        eDD.dumpDataAndClose(new StringBuffer(" </TABLE></BODY></HTML>"));
    }

    private void exportXML(ExportDataDumper eDD, String viewName) {
        int i;
        String newline = System.getProperty("line.separator");
        StringBuffer result = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + newline);
        result.append("<ExportedView Name=\"").append(viewName).append("\">").append(newline);
        result.append(" <TableData NumRows=\"").append(this.nTrackedItems).append("\" NumColumns=\"3\">").append(newline);
        result.append("<TableHeader>");
        for (i = 0; i < this.columnNames.length; ++i) {
            if (this.columnRenderers[i] == null) continue;
            result.append("  <TableColumn><![CDATA[").append(this.columnNames[i]).append("]]></TableColumn>").append(newline);
        }
        result.append("</TableHeader>");
        eDD.dumpData((CharSequence)result);
        for (i = 0; i < this.nTrackedItems; ++i) {
            result = new StringBuffer("  <TableRow>" + newline + "   <TableColumn><![CDATA[" + this.sortedClassNames[i] + "]]></TableColumn>" + newline);
            result.append("   <TableColumn><![CDATA[").append(this.totalAllocObjectsSize[i]).append("]]></TableColumn>").append(newline);
            result.append("   <TableColumn><![CDATA[").append(this.nTotalAllocObjects[i]).append("]]></TableColumn>").append(newline).append("  </TableRow>").append(newline);
            eDD.dumpData((CharSequence)result);
        }
        eDD.dumpDataAndClose(new StringBuffer(" </TableData>" + newline + "</ExportedView>"));
    }

    private void exportCSV(String separator, ExportDataDumper eDD) {
        int i;
        StringBuffer result = new StringBuffer();
        String newLine = "\r\n";
        String quote = "\"";
        for (i = 0; i < this.columnNames.length; ++i) {
            if (this.columnRenderers[i] == null) continue;
            result.append(quote).append(this.columnNames[i]).append(quote).append(separator);
        }
        result.deleteCharAt(result.length() - 1);
        result.append(newLine);
        eDD.dumpData((CharSequence)result);
        for (i = 0; i < this.nTrackedItems; ++i) {
            result = new StringBuffer();
            result.append(quote).append(this.sortedClassNames[i]).append(quote).append(separator);
            result.append(quote).append(this.totalAllocObjectsSize[i]).append(quote).append(separator);
            result.append(quote).append(this.nTotalAllocObjects[i]).append(quote).append(newLine);
            eDD.dumpData((CharSequence)result);
        }
        eDD.close();
    }

    private String replaceHTMLCharacters(String s) {
        StringBuilder sb = new StringBuilder();
        int len = s.length();
        block6: for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block6;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    @Override
    protected CustomBarCellRenderer getBarCellRenderer() {
        return new DiffBarCellRenderer(this.diff.getMinObjectsSizePerClassDiff(), this.diff.getMaxObjectsSizePerClassDiff());
    }

    @Override
    protected JPopupMenu getPopupMenu() {
        if (this.memoryResPopupMenu == null) {
            this.memoryResPopupMenu = new JPopupMenu();
            if (GoToSource.isAvailable()) {
                Font boldfont = this.memoryResPopupMenu.getFont().deriveFont(1);
                this.popupShowSource = new JMenuItem();
                this.popupShowSource.setFont(boldfont);
                this.popupShowSource.setText(GO_SOURCE_POPUP_ITEM_NAME);
                this.memoryResPopupMenu.add(this.popupShowSource);
                this.popupShowSource.addActionListener(this);
            }
        }
        return this.memoryResPopupMenu;
    }

    @Override
    protected Object computeValueAt(int row, int col) {
        int index = (Integer)this.filteredToFullIndexes.get(row);
        switch (col) {
            case 0: {
                return this.sortedClassNames[index];
            }
            case 1: {
                return new Long(this.totalAllocObjectsSize[index]);
            }
            case 2: {
                return (this.totalAllocObjectsSize[index] > 0L ? "+" : "") + this.intFormat.format(this.totalAllocObjectsSize[index]) + " B";
            }
            case 3: {
                return (this.nTotalAllocObjects[index] > 0 ? "+" : "") + this.intFormat.format(this.nTotalAllocObjects[index]);
            }
        }
        return null;
    }

    @Override
    protected void initColumnsData() {
        super.initColumnsData();
        ClassNameTableCellRenderer classNameTableCellRenderer = new ClassNameTableCellRenderer();
        LabelTableCellRenderer labelTableCellRenderer = new LabelTableCellRenderer(11);
        this.columnRenderers = new TableCellRenderer[]{classNameTableCellRenderer, null, labelTableCellRenderer, labelTableCellRenderer};
    }

    @Override
    protected void initDataUponResultsFetch() {
        super.initDataUponResultsFetch();
        if (this.barRenderer != null) {
            this.barRenderer.setMinimum(this.diff.getMinObjectsSizePerClassDiff());
            this.barRenderer.setMaximum(this.diff.getMaxObjectsSizePerClassDiff());
        }
    }

    @Override
    protected boolean passesValueFilter(int i) {
        return true;
    }

    @Override
    protected void performDefaultAction(int classId) {
        String className = null;
        int selectedRow = this.resTable.getSelectedRow();
        if (selectedRow != -1) {
            className = this.resTable.getValueAt(selectedRow, 0).toString().replace("[]", "");
        }
        if (className != null) {
            this.actionsHandler.showSourceForMethod(className, null, null);
        }
    }

    @Override
    protected boolean truncateZeroItems() {
        return false;
    }
}

