/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.action;

import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.PlayPenComponent;
import ca.sqlpower.architect.swingui.action.AbstractArchitectAction;
import ca.sqlpower.architect.swingui.action.Messages;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class ZoomToFitAction
extends AbstractArchitectAction {
    private static final Logger logger = Logger.getLogger(ZoomToFitAction.class);
    private static final double OVER_ZOOM_COEFF = 0.9;
    private static final double MIN_ZOOM = 1.0;

    public ZoomToFitAction(ArchitectSwingSession session, PlayPen playpen) {
        super(session, playpen, Messages.getString("ZoomToFitAction.name"), Messages.getString("ZoomToFitAction.description"), "zoom_fit");
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(90, 0));
    }

    public ZoomToFitAction(ArchitectFrame frame) {
        super(frame, Messages.getString("ZoomToFitAction.name"), Messages.getString("ZoomToFitAction.description"), "zoom_fit");
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(90, 0));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.getPlaypen() == null) {
            logger.error((Object)"No playpen for this action!? Doing nothing...");
            return;
        }
        ZoomToFitAction.zoomToFitSelected(this.getPlaypen());
    }

    public static void zoomToFitSelected(PlayPen playpen) {
        Rectangle zoomBounds = ZoomToFitAction.calcBoundingRectangle(playpen);
        if (zoomBounds == null) {
            return;
        }
        double zoom = Math.min(playpen.getViewportSize().getHeight() / (double)zoomBounds.height, playpen.getViewportSize().getWidth() / (double)zoomBounds.width);
        zoom *= 0.9;
        zoom = Math.min(zoom, 1.0);
        playpen.setZoom(zoom);
        playpen.scrollRectToVisible(zoomBounds);
    }

    private static Rectangle calcBoundingRectangle(PlayPen playpen) {
        Rectangle rect = null;
        List<PlayPenComponent> fitThese = playpen.getSelectedItems();
        if (fitThese.isEmpty()) {
            fitThese = new ArrayList<PlayPenComponent>();
            for (PlayPenComponent playPenComponent : playpen.getContentPane().getChildren()) {
                fitThese.add(playPenComponent);
            }
        }
        for (PlayPenComponent playPenComponent : fitThese) {
            if (rect == null) {
                rect = new Rectangle(playPenComponent.getLocation(), playPenComponent.getSize());
                continue;
            }
            rect.add(playPenComponent.getBounds());
        }
        return rect;
    }
}

