/*
 * Decompiled with CFR 0.152.
 */
package tr.swing;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JButton;

public class JButtonGroup
extends ButtonGroup {
    private static final AbstractButton dummyButton = new JButton();
    private AbstractButton selectedButton;

    public JButtonGroup() {
        this.add(dummyButton);
    }

    public JButtonGroup(AbstractButton[] buttons) {
        this.add(buttons);
        this.add(dummyButton);
    }

    public void add(AbstractButton button) {
        if (button == null || this.buttons.contains(button)) {
            return;
        }
        super.add(button);
        if (this.getSelection() == button.getModel()) {
            this.selectedButton = button;
        }
    }

    public void add(AbstractButton[] newButtons) {
        if (newButtons == null) {
            return;
        }
        for (int i = 0; i < newButtons.length; ++i) {
            this.add(newButtons);
        }
    }

    public void remove(AbstractButton button) {
        if (button != null) {
            if (this.selectedButton == button) {
                this.selectedButton = null;
            }
            super.remove(button);
        }
    }

    public void remove(AbstractButton[] oldButtons) {
        if (oldButtons == null) {
            return;
        }
        for (int i = 0; i < oldButtons.length; ++i) {
            this.remove(oldButtons);
        }
    }

    public void setSelected(AbstractButton button, boolean selected) {
        if (button != null && this.buttons.contains(button)) {
            this.setSelected(button.getModel(), selected);
            if (this.getSelection() == button.getModel()) {
                this.selectedButton = button;
            }
        }
    }

    public void setSelected(ButtonModel model, boolean selected) {
        AbstractButton button = this.getButton(model);
        if (this.buttons.contains(button)) {
            super.setSelected(model, selected);
            if (model != dummyButton.getModel()) {
                this.selectedButton = button;
            }
        }
    }

    public AbstractButton getButton(ButtonModel model) {
        for (AbstractButton ab : this.buttons) {
            if (ab.getModel() != model) continue;
            return ab;
        }
        return null;
    }

    public AbstractButton getSelected() {
        if (this.selectedButton == dummyButton) {
            return null;
        }
        return this.selectedButton;
    }

    public ButtonModel getSelection() {
        if (this.selectedButton == dummyButton) {
            return null;
        }
        return super.getSelection();
    }

    public boolean isSelected(AbstractButton button) {
        if (button == dummyButton) {
            return false;
        }
        return button == this.selectedButton;
    }

    public List getButtons() {
        LinkedList allButtons = new LinkedList(this.buttons);
        allButtons.remove(dummyButton);
        return Collections.unmodifiableList(allButtons);
    }

    public boolean contains(AbstractButton button) {
        if (button == dummyButton) {
            return false;
        }
        return this.buttons.contains(button);
    }

    public void unselectAll() {
        this.setSelected(dummyButton, true);
    }
}

