/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.https;

import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.https.HttpsResponseMessage;
import de.rub.nds.tlsattacker.core.https.header.HttpsHeader;
import de.rub.nds.tlsattacker.core.https.header.serializer.HttpsHeaderSerializer;
import de.rub.nds.tlsattacker.core.protocol.serializer.ProtocolMessageSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpsResponseSerializer
extends ProtocolMessageSerializer<HttpsResponseMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final HttpsResponseMessage message;

    public HttpsResponseSerializer(HttpsResponseMessage message, ProtocolVersion version) {
        super(message, version);
        this.message = message;
    }

    @Override
    public byte[] serializeProtocolMessageContent() {
        StringBuilder builder = new StringBuilder();
        builder.append((String)this.message.getResponseProtocol().getValue()).append(" ").append((String)this.message.getResponseStatusCode().getValue()).append("\r\n");
        for (HttpsHeader header : this.message.getHeader()) {
            HttpsHeaderSerializer serializer = new HttpsHeaderSerializer(header);
            builder.append(new String(serializer.serialize()));
        }
        builder.append("\r\n");
        builder.append((String)this.message.getResponseContent().getValue());
        LOGGER.info(builder.toString());
        this.appendBytes(builder.toString().getBytes());
        return this.getAlreadySerialized();
    }
}

