/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.creditcardvalidator;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.pentaho.di.core.Const;
import org.pentaho.di.trans.steps.creditcardvalidator.Messages;
import org.pentaho.di.trans.steps.creditcardvalidator.ReturnIndicator;

public class CreditCardVerifier {
    public static final int INVALID = -1;
    public static final int VISA = 0;
    public static final int MASTERCARD = 1;
    public static final int AMERICAN_EXPRESS = 2;
    public static final int EN_ROUTE = 3;
    public static final int DINERS_CLUB = 4;
    private static final String[] cardNames = new String[]{"Visa", "Mastercard", "American Express", "En Route", "Diner's CLub/Carte Blanche"};
    private static final String[] NotValidCardNames = new String[]{Messages.getString("CreditCardValidator.Log.NotValidVisa"), Messages.getString("CreditCardValidator.Log.NotValidMastercard"), Messages.getString("CreditCardValidator.Log.NotValidAmericanExpress"), Messages.getString("CreditCardValidator.Log.NotValidEnRoute"), Messages.getString("CreditCardValidator.Log.NotValidDiners")};

    public static String getCardName(int id) {
        return id > -1 && id < cardNames.length ? cardNames[id] : null;
    }

    public static String getNotValidCardNames(int id) {
        return id > -1 && id < NotValidCardNames.length ? NotValidCardNames[id] : null;
    }

    public static ReturnIndicator CheckCC(String CardNumber) {
        ReturnIndicator ri = new ReturnIndicator();
        if (Const.isEmpty((String)CardNumber)) {
            ri.UnValidMsg = Messages.getString("CreditCardValidator.Log.EmptyNumber");
            return ri;
        }
        Matcher m = Pattern.compile("[^\\d\\s.-]").matcher(CardNumber);
        if (m.find()) {
            ri.UnValidMsg = "Credit card number can only contain numbers, spaces, \"-\", and \".\"";
            return ri;
        }
        int cardId = CreditCardVerifier.getCardID(CardNumber);
        if (cardId > -1) {
            if (CreditCardVerifier.luhnValidate(CardNumber)) {
                ri.CardValid = true;
                ri.CardType = CreditCardVerifier.getCardName(cardId);
            } else {
                ri.CardValid = false;
                ri.UnValidMsg = CreditCardVerifier.getNotValidCardNames(cardId);
            }
        } else if (CreditCardVerifier.luhnValidate(CardNumber)) {
            ri.CardValid = true;
        } else {
            ri.UnValidMsg = Messages.getString("CreditCardValidator.Log.CardNotValid");
        }
        return ri;
    }

    public static boolean luhnValidate(String numberString) {
        try {
            int j = numberString.length();
            String[] s1 = new String[j];
            for (int i = 0; i < j; ++i) {
                s1[i] = "" + numberString.charAt(i);
            }
            int checksum = 0;
            for (int i = s1.length - 1; i >= 0; i -= 2) {
                int k = 0;
                if (i > 0) {
                    k = Integer.valueOf(s1[i - 1]) * 2;
                    if (k > 9) {
                        String s = "" + k;
                        k = Integer.valueOf(s.substring(0, 1)) + Integer.valueOf(s.substring(1));
                    }
                    checksum += Integer.valueOf(s1[i]) + k;
                    continue;
                }
                checksum += Integer.valueOf(s1[0]).intValue();
            }
            return checksum % 10 == 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static int getCardID(String number) {
        int valid = -1;
        String digit1 = number.substring(0, 1);
        String digit2 = number.substring(0, 2);
        String digit3 = number.substring(0, 3);
        String digit4 = number.substring(0, 4);
        if (CreditCardVerifier.isNumber(number)) {
            if (digit1.equals("4")) {
                if (number.length() == 13 || number.length() == 16) {
                    valid = 0;
                }
            } else if (digit2.compareTo("51") >= 0 && digit2.compareTo("55") <= 0) {
                if (number.length() == 16) {
                    valid = 1;
                }
            } else if (digit2.equals("34") || digit2.equals("37")) {
                if (number.length() == 15) {
                    valid = 2;
                }
            } else if (digit4.equals("2014") || digit4.equals("2149")) {
                if (number.length() == 15) {
                    valid = 3;
                }
            } else if (digit2.equals("36") || digit2.equals("38") || digit3.compareTo("300") >= 0 && digit3.compareTo("305") <= 0) {
                if (number.length() == 14) {
                    valid = 4;
                }
            } else if (digit2.equals("60") && number.length() == 16) {
                valid = 4;
            }
        }
        return valid;
    }

    public static boolean isNumber(String n) {
        try {
            Double.valueOf(n).doubleValue();
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

