/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import io.netty.channel.Channel;
import java.util.concurrent.atomic.AtomicReference;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.impl.ClientStatistics;
import org.infinispan.client.hotrod.impl.ClientTopology;
import org.infinispan.client.hotrod.impl.operations.HotRodOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;

public abstract class StatsAffectingHotRodOperation<T>
extends HotRodOperation<T> {
    protected ClientStatistics clientStatistics;
    private long startTime;

    protected StatsAffectingHotRodOperation(short requestCode, short responseCode, Codec codec, int flags, Configuration cfg, byte[] cacheName, AtomicReference<ClientTopology> clientTopology, ChannelFactory channelFactory, DataFormat dataFormat, ClientStatistics clientStatistics) {
        super(requestCode, responseCode, codec, flags, cfg, cacheName, clientTopology, channelFactory, dataFormat);
        this.clientStatistics = clientStatistics;
    }

    @Override
    protected void scheduleRead(Channel channel) {
        if (this.clientStatistics.isEnabled()) {
            this.startTime = this.clientStatistics.time();
        }
        super.scheduleRead(channel);
    }

    protected void statsDataRead(boolean success) {
        if (this.clientStatistics.isEnabled()) {
            this.clientStatistics.dataRead(success, this.startTime, 1);
        }
    }

    protected void statsDataRead(boolean success, int count) {
        if (this.clientStatistics.isEnabled() && count > 0) {
            this.clientStatistics.dataRead(success, this.startTime, count);
        }
    }

    protected void statsDataStore() {
        if (this.clientStatistics.isEnabled()) {
            this.clientStatistics.dataStore(this.startTime, 1);
        }
    }

    protected void statsDataStore(int count) {
        if (this.clientStatistics.isEnabled() && count > 0) {
            this.clientStatistics.dataStore(this.startTime, count);
        }
    }
}

