/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.fluent;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import org.snmp4j.PDU;
import org.snmp4j.ScopedPDU;
import org.snmp4j.Session;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.event.ResponseListener;
import org.snmp4j.smi.Address;

public class SnmpCompletableFuture
extends CompletableFuture<PDU>
implements ResponseListener {
    public static final String ERR_TIMEOUT = "SNMP Request timed out";
    private ResponseEvent<?> responseEvent;
    private Object[] userObjects;
    protected String timeoutMessage = "SNMP Request timed out";

    protected SnmpCompletableFuture() {
    }

    @Override
    public <A extends Address> void onResponse(ResponseEvent<A> event) {
        ((Session)event.getSource()).cancel(event.getRequest(), this);
        this.responseEvent = event;
        this.userObjects = (Object[])event.getUserObject();
        if (event.getError() != null) {
            this.completeExceptionally(event.getError());
        } else if (event.getResponse() == null) {
            this.completeExceptionally(new TimeoutException(this.timeoutMessage));
        } else if (event.getResponse().getType() == -88) {
            this.completeExceptionally(new ReportException((ScopedPDU)event.getResponse()));
        } else if (event.getResponse().getErrorStatus() != 0) {
            this.completeExceptionally(new SnmpErrorException(event.getResponse().getErrorStatus(), event.getResponse().getErrorIndex()));
        } else {
            this.complete(event.getResponse());
        }
    }

    public ResponseEvent<?> getResponseEvent() {
        return this.responseEvent;
    }

    public static <A extends Address> SnmpCompletableFuture send(Snmp snmp, Target<A> target, PDU pdu, Object ... userObjects) {
        SnmpCompletableFuture future = new SnmpCompletableFuture();
        try {
            snmp.send(pdu, target, userObjects, future);
            if (!pdu.isConfirmedPdu()) {
                future.complete(null);
            }
        }
        catch (IOException iox) {
            future.completeExceptionally(iox);
        }
        return future;
    }

    public Object[] getUserObjects() {
        return this.userObjects;
    }

    public static class ReportException
    extends Exception {
        private static final long serialVersionUID = 1539501546791678999L;
        private final ScopedPDU report;

        public ReportException(ScopedPDU report) {
            super("SNMP REPORT error: " + String.valueOf(report));
            this.report = report;
        }

        public ScopedPDU getReport() {
            return this.report;
        }
    }

    public static class SnmpErrorException
    extends Exception {
        private static final long serialVersionUID = -2338397456373295345L;
        private final int errorStatus;
        private final int errorIndex;

        public SnmpErrorException(int errorStatus, int errorIndex) {
            super("SNMP error " + PDU.toErrorStatusText(errorStatus) + " on index " + errorIndex);
            this.errorStatus = errorStatus;
            this.errorIndex = errorIndex;
        }

        public int getErrorStatus() {
            return this.errorStatus;
        }

        public int getErrorIndex() {
            return this.errorIndex;
        }

        public String getErrorMessage() {
            return PDU.toErrorStatusText(this.errorStatus);
        }
    }
}

