"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TEXT2VIZ_API = exports.TEXT2VEGA_WITH_INSTRUCTIONS_AGENT_CONFIG_ID = exports.TEXT2VEGA_RULE_BASED_AGENT_CONFIG_ID = exports.TEXT2VEGA_INPUT_SIZE_LIMIT = exports.TEXT2PPL_AGENT_CONFIG_ID = exports.SUMMARY_ASSISTANT_API = exports.NOTEBOOK_PREFIX = exports.NOTEBOOK_API = exports.DSL_SEARCH = exports.DSL_BASE = exports.DEFAULT_USER_NAME = exports.DATA2SUMMARY_AGENT_CONFIG_ID = exports.ASSISTANT_API = exports.API_BASE = exports.AGENT_API = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const API_BASE = exports.API_BASE = '/api/assistant';
const DSL_BASE = exports.DSL_BASE = '/api/dsl';
const DSL_SEARCH = exports.DSL_SEARCH = '/search';
const NOTEBOOK_PREFIX = exports.NOTEBOOK_PREFIX = '/api/observability/notebooks';
const ASSISTANT_API = exports.ASSISTANT_API = {
  SEND_MESSAGE: `${API_BASE}/send_message`,
  CONVERSATION: `${API_BASE}/conversation`,
  CONVERSATIONS: `${API_BASE}/conversations`,
  FEEDBACK: `${API_BASE}/feedback`,
  ABORT_AGENT_EXECUTION: `${API_BASE}/abort`,
  REGENERATE: `${API_BASE}/regenerate`,
  TRACE: `${API_BASE}/trace`,
  ACCOUNT: `${API_BASE}/account`
};
const TEXT2VIZ_API = exports.TEXT2VIZ_API = {
  TEXT2PPL: `${API_BASE}/text2ppl`,
  TEXT2VEGA: `${API_BASE}/text2vega`
};
const AGENT_API = exports.AGENT_API = {
  EXECUTE: `${API_BASE}/agent/_execute`,
  CONFIG_EXISTS: `${API_BASE}/agent_config/_exists`
};
const SUMMARY_ASSISTANT_API = exports.SUMMARY_ASSISTANT_API = {
  SUMMARIZE: `${API_BASE}/summary`,
  INSIGHT: `${API_BASE}/insight`,
  DATA2SUMMARY: `${API_BASE}/data2summary`
};
const NOTEBOOK_API = exports.NOTEBOOK_API = {
  CREATE_NOTEBOOK: `${NOTEBOOK_PREFIX}/note/savedNotebook`,
  SET_PARAGRAPH: `${NOTEBOOK_PREFIX}/savedNotebook/set_paragraphs`
};
const DEFAULT_USER_NAME = exports.DEFAULT_USER_NAME = 'User';
const TEXT2VEGA_INPUT_SIZE_LIMIT = exports.TEXT2VEGA_INPUT_SIZE_LIMIT = 400;
const TEXT2VEGA_RULE_BASED_AGENT_CONFIG_ID = exports.TEXT2VEGA_RULE_BASED_AGENT_CONFIG_ID = 'os_text2vega';
const TEXT2VEGA_WITH_INSTRUCTIONS_AGENT_CONFIG_ID = exports.TEXT2VEGA_WITH_INSTRUCTIONS_AGENT_CONFIG_ID = 'os_text2vega_with_instructions';
const TEXT2PPL_AGENT_CONFIG_ID = exports.TEXT2PPL_AGENT_CONFIG_ID = 'os_query_assist_ppl';
const DATA2SUMMARY_AGENT_CONFIG_ID = exports.DATA2SUMMARY_AGENT_CONFIG_ID = 'os_data2summary';
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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