"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.streamSerializer = exports.streamDeserializer = void 0;
var _eventsourceParser = require("eventsource-parser");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const separators = `\n\n`;
const prefix = 'data: ';
const streamSerializer = chunk => {
  const {
    event,
    data
  } = chunk;
  let chunkString = '';
  if (event) {
    chunkString += `event: ${event}\n`;
  }
  chunkString += `${prefix}${JSON.stringify(data)}${separators}`;
  return chunkString;
};
exports.streamSerializer = streamSerializer;
const streamDeserializer = content => {
  const streamChunks = [];
  const parser = (0, _eventsourceParser.createParser)({
    onEvent(message) {
      try {
        const dataPayload = JSON.parse(message.data);
        streamChunks.push({
          ...message,
          data: dataPayload
        });
      } catch (e) {
        streamChunks.push({
          event: 'error',
          data: e.message
        });
      }
    },
    onError(error) {
      streamChunks.push({
        event: 'error',
        data: error.message
      });
    }
  });
  parser.feed(content);
  return streamChunks;
};
exports.streamDeserializer = streamDeserializer;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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