"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addAlertsMethods = addAlertsMethods;
var _constants = require("../utils/constants");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function addAlertsMethods(securityAnalytics, createAction) {
  securityAnalytics[_constants.METHOD_NAMES.GET_ALERTS] = createAction({
    url: {
      fmt: `${_constants.API.GET_ALERTS}`,
      params: {
        detector_id: {
          type: 'string'
        },
        sortOrder: {
          type: 'string'
        },
        size: {
          type: 'number'
        },
        startIndex: {
          type: 'number'
        }
      }
    },
    needBody: false,
    method: 'GET'
  });
  securityAnalytics[_constants.METHOD_NAMES.ACKNOWLEDGE_ALERTS] = createAction({
    url: {
      fmt: `${_constants.BASE_API_PATH}/detectors/<%=detector_id%>/_acknowledge/alerts`,
      req: {
        detector_id: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'POST'
  });
  securityAnalytics[_constants.METHOD_NAMES.GET_THREAT_INTEL_ALERTS] = createAction({
    url: {
      fmt: `${_constants.API.THREAT_INTEL_BASE}/alerts`,
      params: {
        sortOrder: {
          type: 'string'
        },
        size: {
          type: 'number'
        },
        startIndex: {
          type: 'number'
        },
        startTime: {
          type: 'number'
        },
        endTime: {
          type: 'number'
        }
      }
    },
    needBody: false,
    method: 'GET'
  });
  securityAnalytics[_constants.METHOD_NAMES.UPDATE_THREAT_INTEL_ALERTS_STATE] = createAction({
    url: {
      fmt: `${_constants.API.THREAT_INTEL_BASE}/alerts/status`,
      params: {
        state: {
          type: 'string',
          required: true
        },
        alert_ids: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'PUT'
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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