"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _constants = require("../utils/constants");
var _MDSEnabledClientService = require("./MDSEnabledClientService");
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          */
class AlertService extends _MDSEnabledClientService.MDSEnabledClientService {
  constructor(...args) {
    super(...args);
    /**
     * Calls backend GET Alerts API.
     */
    _defineProperty(this, "getAlerts", async (context, request, response) => {
      try {
        const {
          detectorType,
          detector_id,
          sortOrder,
          size,
          startTime,
          endTime
        } = request.query;
        const defaultParams = {
          sortOrder,
          size,
          startTime,
          endTime
        };
        let params;
        if (detector_id) {
          params = {
            ...defaultParams,
            detector_id
          };
        } else if (detectorType) {
          params = {
            ...defaultParams,
            detectorType
          };
        } else {
          throw Error(`Invalid request params: detectorId or detectorType must be specified`);
        }
        const client = this.getClient(request, context);
        const getAlertsResponse = await client(_constants.CLIENT_ALERTS_METHODS.GET_ALERTS, params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: getAlertsResponse
          }
        });
      } catch (error) {
        console.error('Security Analytics - AlertService - getAlerts:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });
    /**
     * Calls backend POST Acknowledge Alerts API.
     */
    _defineProperty(this, "acknowledgeAlerts", async (context, request, response) => {
      try {
        const {
          detector_id
        } = request.params;
        const {
          alerts
        } = request.body;
        const body = {
          alerts: alerts
        };
        const params = {
          body,
          detector_id
        };
        const client = this.getClient(request, context);
        const acknowledgeAlertsResponse = await client(_constants.CLIENT_ALERTS_METHODS.ACKNOWLEDGE_ALERTS, params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: acknowledgeAlertsResponse
          }
        });
      } catch (error) {
        console.error('Security Analytics - AlertService - acknowledgeAlerts:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });
    _defineProperty(this, "getThreatIntelAlerts", async (context, request, response) => {
      try {
        const {
          sortOrder,
          size,
          startIndex,
          startTime,
          endTime
        } = request.query;
        const params = {
          sortOrder,
          size,
          startIndex,
          startTime,
          endTime
        };
        const client = this.getClient(request, context);
        const getAlertsResponse = await client(_constants.CLIENT_THREAT_INTEL_METHODS.GET_THREAT_INTEL_ALERTS, params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: getAlertsResponse
          }
        });
      } catch (error) {
        console.error('Security Analytics - AlertService - getThreatIntelAlerts:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });
    _defineProperty(this, "updateThreatIntelAlertsState", async (context, request, response) => {
      try {
        const {
          state,
          alert_ids
        } = request.query;
        const params = {
          state,
          alert_ids
        };
        const client = this.getClient(request, context);
        const updateStatusResponse = await client(_constants.CLIENT_THREAT_INTEL_METHODS.UPDATE_THREAT_INTEL_ALERTS_STATE, params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: updateStatusResponse
          }
        });
      } catch (error) {
        console.error('Security Analytics - AlertService - updateThreatIntelAlertsState:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });
  }
}
exports.default = AlertService;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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