/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.dtls;

import de.rub.nds.tlsattacker.core.protocol.message.DtlsHandshakeMessageFragment;
import de.rub.nds.tlsattacker.core.protocol.message.HandshakeMessage;
import de.rub.nds.tlsattacker.core.protocol.serializer.HandshakeMessageSerializer;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import java.util.LinkedList;
import java.util.List;
import org.bouncycastle.util.Arrays;

public class MessageFragmenter {
    private final int maxFragmentLength;

    public MessageFragmenter(int maxFragmentLength) {
        this.maxFragmentLength = maxFragmentLength;
    }

    public List<DtlsHandshakeMessageFragment> fragmentMessage(HandshakeMessage message, TlsContext context) {
        HandshakeMessageSerializer serializer = (HandshakeMessageSerializer)message.getHandler(context).getSerializer(message);
        byte[] bytes = serializer.serializeHandshakeMessageContent();
        List<DtlsHandshakeMessageFragment> dtlsFragments = this.generateFragments(message, bytes, this.maxFragmentLength, context);
        return dtlsFragments;
    }

    public DtlsHandshakeMessageFragment wrapInSingleFragment(HandshakeMessage message, TlsContext context) {
        HandshakeMessageSerializer serializer = (HandshakeMessageSerializer)message.getHandler(context).getSerializer(message);
        byte[] bytes = serializer.serializeHandshakeMessageContent();
        List<DtlsHandshakeMessageFragment> fragments = this.generateFragments(message, bytes, bytes.length, context);
        return fragments.get(0);
    }

    private List<DtlsHandshakeMessageFragment> generateFragments(HandshakeMessage message, byte[] handshakeBytes, int maxFragmentLength, TlsContext context) {
        LinkedList<DtlsHandshakeMessageFragment> fragments = new LinkedList<DtlsHandshakeMessageFragment>();
        int currentOffset = 0;
        do {
            byte[] fragmentBytes = Arrays.copyOfRange((byte[])handshakeBytes, (int)currentOffset, (int)Math.min(currentOffset + maxFragmentLength, handshakeBytes.length));
            DtlsHandshakeMessageFragment fragment = new DtlsHandshakeMessageFragment(message.getHandshakeMessageType(), fragmentBytes, (Integer)message.getMessageSequence().getValue(), currentOffset, handshakeBytes.length);
            fragment.getHandler(context).prepareMessage(fragment);
            fragments.add(fragment);
        } while ((currentOffset += maxFragmentLength) < handshakeBytes.length);
        return fragments;
    }
}

