/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.expression;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlExpression;
import org.apache.commons.jexl3.MapContext;
import org.jxls.expression.EvaluationException;
import org.jxls.expression.ExpressionEvaluator;

public class JexlExpressionEvaluator
implements ExpressionEvaluator {
    private final boolean silent;
    private final boolean strict;
    private JexlExpression jexlExpression;
    private JexlContext jexlContext;
    private static ThreadLocal<Map<String, JexlEngine>> jexlThreadLocal = new ThreadLocal<Map<String, JexlEngine>>(){

        @Override
        protected Map<String, JexlEngine> initialValue() {
            return new HashMap<String, JexlEngine>();
        }
    };
    private static final ThreadLocal<Map<String, JexlExpression>> expressionMapThreadLocal = new ThreadLocal<Map<String, JexlExpression>>(){

        @Override
        protected Map<String, JexlExpression> initialValue() {
            return new HashMap<String, JexlExpression>();
        }
    };

    public JexlExpressionEvaluator() {
        this(true, false);
    }

    public JexlExpressionEvaluator(boolean silent, boolean strict) {
        this.silent = silent;
        this.strict = strict;
    }

    public JexlExpressionEvaluator(String expression) {
        this();
        this.jexlExpression = this.getJexlEngine().createExpression(expression);
    }

    public JexlExpressionEvaluator(Map<String, Object> context) {
        this();
        this.jexlContext = new MapContext(context);
    }

    public JexlExpressionEvaluator(JexlContext jexlContext) {
        this();
        this.jexlContext = jexlContext;
    }

    @Override
    public Object evaluate(String expression, Map<String, Object> context) {
        MapContext jexlContext = new MapContext(context);
        try {
            Map<String, JexlExpression> expressionMap = expressionMapThreadLocal.get();
            JexlExpression jexlExpression = expressionMap.get(expression);
            if (jexlExpression == null) {
                jexlExpression = this.getJexlEngine().createExpression(expression);
                expressionMap.put(expression, jexlExpression);
            }
            return jexlExpression.evaluate((JexlContext)jexlContext);
        }
        catch (Exception e) {
            throw new EvaluationException("An error occurred when evaluating expression " + expression, e);
        }
    }

    @Override
    public Object evaluate(Map<String, Object> context) {
        this.jexlContext = new MapContext(context);
        try {
            return this.jexlExpression.evaluate(this.jexlContext);
        }
        catch (Exception e) {
            throw new EvaluationException("An error occurred when evaluating expression " + this.jexlExpression.getSourceText(), e);
        }
    }

    public JexlExpression getJexlExpression() {
        return this.jexlExpression;
    }

    public void setJexlEngine(JexlEngine jexlEngine) {
        String key = this.key();
        Map<String, JexlEngine> map = jexlThreadLocal.get();
        map.put(key, jexlEngine);
    }

    public JexlEngine getJexlEngine() {
        String key = this.key();
        Map<String, JexlEngine> map = jexlThreadLocal.get();
        JexlEngine ret = map.get(key);
        if (ret == null) {
            ret = new JexlBuilder().silent(this.silent).strict(this.strict).create();
            map.put(key, ret);
        }
        return ret;
    }

    private String key() {
        return this.silent + "-" + this.strict;
    }

    @Override
    public String getExpression() {
        return this.jexlExpression == null ? null : this.jexlExpression.getSourceText();
    }

    public void clear() {
        expressionMapThreadLocal.get().clear();
    }
}

