/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.CellError;
import org.armedbear.lisp.Cons;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.SpecialBindingsMark;
import org.armedbear.lisp.StandardClass;
import org.armedbear.lisp.Symbol;

public final class UnboundVariable
extends CellError {
    public UnboundVariable(LispObject obj) {
        super(StandardClass.UNBOUND_VARIABLE);
        if (obj instanceof Cons) {
            this.initialize(obj);
        } else {
            this.setCellName(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getMessage() {
        LispThread thread = LispThread.currentThread();
        SpecialBindingsMark mark = thread.markSpecialBindings();
        thread.bindSpecial(Symbol.PRINT_ESCAPE, Lisp.T);
        StringBuffer sb = new StringBuffer("The variable ");
        try {
            sb.append(this.getCellName().princToString());
        }
        finally {
            thread.resetSpecialBindings(mark);
        }
        sb.append(" is unbound.");
        return sb.toString();
    }

    @Override
    public LispObject typeOf() {
        return Symbol.UNBOUND_VARIABLE;
    }

    @Override
    public LispObject classOf() {
        return StandardClass.UNBOUND_VARIABLE;
    }

    @Override
    public LispObject typep(LispObject type) {
        if (type == Symbol.UNBOUND_VARIABLE) {
            return Lisp.T;
        }
        if (type == StandardClass.UNBOUND_VARIABLE) {
            return Lisp.T;
        }
        return super.typep(type);
    }
}

