/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.util.Objects;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.internal.impl.LocalPathComposer;
import org.eclipse.aether.metadata.Metadata;

@Singleton
@Named
public final class DefaultLocalPathComposer
implements LocalPathComposer {
    @Override
    public String getPathForArtifact(Artifact artifact, boolean local2) {
        Objects.requireNonNull(artifact);
        StringBuilder path2 = new StringBuilder(128);
        path2.append(artifact.getGroupId().replace('.', '/')).append('/');
        path2.append(artifact.getArtifactId()).append('/');
        path2.append(artifact.getBaseVersion()).append('/');
        path2.append(artifact.getArtifactId()).append('-');
        if (local2) {
            path2.append(artifact.getBaseVersion());
        } else {
            path2.append(artifact.getVersion());
        }
        if (artifact.getClassifier().length() > 0) {
            path2.append('-').append(artifact.getClassifier());
        }
        if (artifact.getExtension().length() > 0) {
            path2.append('.').append(artifact.getExtension());
        }
        return path2.toString();
    }

    @Override
    public String getPathForMetadata(Metadata metadata, String repositoryKey) {
        Objects.requireNonNull(metadata);
        Objects.requireNonNull(repositoryKey);
        StringBuilder path2 = new StringBuilder(128);
        if (metadata.getGroupId().length() > 0) {
            path2.append(metadata.getGroupId().replace('.', '/')).append('/');
            if (metadata.getArtifactId().length() > 0) {
                path2.append(metadata.getArtifactId()).append('/');
                if (metadata.getVersion().length() > 0) {
                    path2.append(metadata.getVersion()).append('/');
                }
            }
        }
        path2.append(this.insertRepositoryKey(metadata.getType(), repositoryKey));
        return path2.toString();
    }

    private String insertRepositoryKey(String metadataType, String repositoryKey) {
        int idx = metadataType.indexOf(46);
        String result = idx < 0 ? metadataType + '-' + repositoryKey : metadataType.substring(0, idx) + '-' + repositoryKey + metadataType.substring(idx);
        return result;
    }
}

