# GNU Typist - improved typing tutor program for UNIX systems
#
# Copyright (C) 1998, 1999, 2000, 2001, 2002, 2003  Simon Baldwin
# Copyright (C) 2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010, 2011,
#               2012, 2013, 2014, 2016, 2017, 2018, 2019, 2020
#               Felix Natter, Paul Goins, Tim Marston, Mihai Gătejescu
# Copyright (C) 2021, 2022, 2023 Felix Natter, Mihai Gătejescu
#
# GNU Typist is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# GNU Typist is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with GNU Typist.  If not, see <http://www.gnu.org/licenses/>.
#

#------------------------------------------------------------------------------
# Series U
#------------------------------------------------------------------------------
G:_U_MENU
*:_U_NO_MENU

#------------------------------------------------------------------------------
# Lesson U1
#------------------------------------------------------------------------------
*:U1
*:_U_S_U1
B:                            Lesson U1

*:_U_R_L0
T:			Welcome to lesson U1
 :
 :Still don't know how to touch-type?  Let's start from the beginning and
 :drill you starting with the home row.

I:(1) Try this:
*:_U_R_L1
D:has half hag gad gash glass sash ash slash shall flash
 :had hall gas gaff gall glad dash ask slag shad ah

G:_U_E_U1

#------------------------------------------------------------------------------
# Lesson U2
#------------------------------------------------------------------------------
*:U2
*:_U_S_U2
B:                            Lesson U2

I:(1) Familiarize yourself with the top row and between the index fingers:
*:_U_R_L3
D:juj kik lol ;p; jyj
 :frf ded sws aqa ftf

I:(2) Some words:
*:_U_R_L4
D:jug part ye aqua their hearty dry great why whose youth
 :kit free use type last lower drug light wheat proper your
 :lot dear its rear were pretty grip quiet where proud yellow
 :hear sweep old easy writer fresh group equip who please yes

I:(3) Now for the bottom row:
*:_U_R_L5
D:jmj k,k l.l ;/; jnj
 :fvf dcd sxs aza fbf

I:(4) Some words:
*:_U_R_L6
D:man come body vacant many tax ribbon lining believing
 :name can beam make examine none native baby commission
 :vain sex not cancel even mention woman brick quicken
 :become zero cave lazy benzine opening very branch textile

G:_U_E_U2

#------------------------------------------------------------------------------
# Lesson U3
#------------------------------------------------------------------------------
*:U3
*:_U_S_U3
B:                            Lesson U3

I:(1)
*:_U_R_L8
D:Do you live in Scranton, Pennsylvania?

I:(2)
*:_U_R_L9
D:Mary Brown and Nancy Smith are in New York City.

I:(3)
*:_U_R_L10
D:Violet, Helen, Dora, Jennie, and Elsie are staying at the Hotel Commodore.

I:(4)
*:_U_R_L11
D:I have lived in Los Angeles, San Francisco, Portland, Chicago, St. Louis, and
 :Denver; Robert has lived in Boston, Philadelphia, Jersey City, and Utica.

I:(5)
*:_U_R_L12
D:j7j k8k l9l ;0; j6j
 :f4f d3d s2s a1a f5f

I:(6)
*:_U_R_L13
D:j&j k*k l(l ;); j^j
 :f$f d#d s@s a!a f%f

I:(7)
*:_U_R_L14
S:Please send me the book "Facts & Figures."
 :Send us the items (3 dozen coats) right away.
 :The amount of the bill is $17,563.49; the discount is 2% 10 days, net 30 days.
 :The cards should be made up in the following sizes: 4 5/16 x 8 3/16 and
 :3 5/8 x 6 7/8.

I:(8)
*:_U_R_L15
D:2's 3's 4's 5's
 :#' #2 #3 #4 #5

G:_U_E_U3

#------------------------------------------------------------------------------
# Lesson U4
#------------------------------------------------------------------------------
*:U4
*:_U_S_U4
B:                            Lesson U4

I:(1)
*:_U_R_L15A
D:;'; ;"; ;/; ;?; ;[; ;{; ;-; ;_;

I:(2)
*:_U_R_L17
D:The quick brown fox jumps over the lazy dog.

I:(3)
*:_U_R_L18
D:This is a specimen of the work done on this machine.

I:(4)
*:_U_R_L19
D:Now is the time for all good men to come to the aid of their party.

I:(5)
*:_U_R_L20
D:1$ 2$ 3$ 4$ 5$ 6$ 7$ 8$ 9$ 10$
 :2 coats @ $20.00 5 hats @ $4.00

G:_U_E_U4

#------------------------------------------------------------------------------
# Lesson U5
#------------------------------------------------------------------------------
*:U5
*:_U_S_U5
B:                            Lesson U5

*:_U_R_L21
T:
 :		   (Drill on S Combinations)

I:(1)
*:_U_R_L22
D:sas ses sis sos sus sc scr sh sk sl sm sn sp spl spr st str sw

I:(2)
*:_U_R_L23
D:says sides springs slips snows shops sweets streets
 :sees souls spreads schools smiles shoots swings strikes
 :sues speaks splashes screams skates sheets stones stresses

I:(3)
*:_U_R_L24
S:She wishes to show us some samples.
 :The sisters wear the same size dresses.
 :She says she speaks to Sally in school.
 :The shipment was shipped by fast express.
 :Simplicity and sincerity are social assets.

I:(4)
*:_U_R_L25
S:     Safety first.  This slogan is well known.  Yet many care-
 :less people disregard it and so we have accidents.  It is pos-
 :sible to avoid many types of accidents by a little forethought.
 :Don't be careless.  Do your share to avoid mishaps.

G:_U_E_U5

#------------------------------------------------------------------------------
# Lesson U6
#------------------------------------------------------------------------------
*:U6
*:_U_S_U6
B:                            Lesson U6

*:_U_R_L26
T:
 :		(Drill on R Combinations)

I:(1)
*:_U_R_L27
D:rar rer rir ror rur br cr dr fr gr pr shr tr thr

I:(2)
*:_U_R_L28
D:rare rural proper trader drier freer cracker
 :rear broker prefer trapper dresser fresher grammar
 :roar brewer prepare thrower shrewder creamer greater

I:(3)
*:_U_R_L29
S:Every promise made should be observed.
 :The price of the property is really $2,500.
 :Try to remember to bring your grammar with you.
 :Proof of your brokerage experience will be required.
 :The orange grower must have favorable weather conditions.

I:(4)
*:_U_R_L30
S:     Some people break promises as readily as they make them.
 :As a result, they acquire a reputation for unreliability.  It
 :is particularly important to be reliable in the business world.
 :A person or firm that comes to be regarded as unreliable has a
 :poor chance of success.

G:_U_E_U6

#------------------------------------------------------------------------------
# Lesson U7
#------------------------------------------------------------------------------
*:U7
*:_U_S_U7
B:                            Lesson U7

*:_U_R_L31
T:
 :		(Drill on L Combinations)


I:(1)
*:_U_R_L32
D:lal lel lil lol lul ly bl cl fl gl pl sl

I:(2)
*:_U_R_L33
D:loll play blow clear glass flesh slow fully
 :lisle plow blue class globe fleet sleep silly
 :label please blood claim gleam flail slight really

I:(3)
*:_U_R_L34
S:The mill will close in April.
 :It is clear to all who will listen.
 :The clerk sells cloth of fine value.
 :You will rely on them to supply you.
 :He held the floor until a relatively late hour.

I:(4)
*:_U_R_L35
S:     Play is most important to a child.  All of us must play
 :a little.  All work and no play makes Jack a dull boy, the
 :old saying goes.  Play affords relaxation.  Some people claim
 :their work is so enthralling that they do not need to play.
 :Psychologists say that the stress of modern life demands that
 :all adults have some hobby away from their daily pursuit.

G:_U_E_U7

#------------------------------------------------------------------------------
# Lesson U8
#------------------------------------------------------------------------------
*:U8
*:_U_S_U8
B:                            Lesson U8

*:_U_R_L36
T:
 :		(Drill on D-T Combinations)

I:(1)
*:_U_R_L37
D:dad ded did dod dud dr ld nd rd
 :tat tet tit tot tut th tr ct ft lt nt pt st

I:(2)
*:_U_R_L38
D:did bend tot total that last rented mended
 :deed lend toot tutor this kept melted handed
 :dude bold tight taught them chest drafted founded
 :dodo board trait treats there first directed doubted

I:(3)
*:_U_R_L39
S:The first shall be last.
 :Credit the cost to the estate.
 :Record your thoughts from time to time.
 :An effort should be made to settle the estate.
 :Rest assured you will succeed if you try hard.

I:(4)
*:_U_R_L40
D:     To learn to typewrite is not difficult.  The keyboard
 :of the typewriter may be mastered in a few hours, but to
 :get speed in typewriting calls for a good deal of practice.
 :One of the best methods of getting up speed is to write a
 :selection over and over again until it can be written easily
 :and accurately.

G:_U_E_U8

#------------------------------------------------------------------------------
# Lesson U9
#------------------------------------------------------------------------------
*:U9
*:_U_S_U9
B:                            Lesson U9

*:_U_R_L41
T:
 :		(Drill on M-N Combinations)

I:(1)
*:_U_R_L42
D:am em im om um mb mp ment
 :an en in on un ng nk

I:(2)
*:_U_R_L43
D:amount damper only singing payment moment
 :emblem camper enter ringing enrollment judgment
 :immense hamper under longing engagement excitement
 :omnibus lumber income banking appointment settlement
 :umbrella bomber answer thinking entertainment employment

I:(3)
*:_U_R_L44
S:We are informed that an increase is anticipated.
 :Please inform us if you are interested in an engine.
 :Banks will extend financial aid to the business man.
 :Unless your invoice is paid, no shipment can be made.
 :The amount of your investment in common stocks is $800.

I:(8)
*:_U_R_L45
S:     The employer must consider any increase in cost that
 :enters into the manufacture of his product.  Unless he includes
 :such cost in his selling price, he is unlikely to show a profit.
 :The installation of a cost system that enables the employer
 :to break down his costs to a unit basis is a prime necessity.

G:_U_E_U9

#------------------------------------------------------------------------------
# Lesson U10
#------------------------------------------------------------------------------
*:U10
*:_U_S_U10
B:                            Lesson U10

*:_U_R_L46
T:
 :		(Drill on com-con Combinations)

I:(1)
*:_U_R_L47
D:com recom decom discom incom uncom
 :con recon decon discon incon uncon

I:(2)
*:_U_R_L48
D:common commit decompose conduct consign incomplete
 :comply comment discomfort connect confuse unconvinced
 :combine compose disconnect consist contrast uncontrolled
 :commerce compare discontinue control contrary incomparable
 :commence complete inconvenient contract convince uncomfortable

I:(3)
*:_U_R_L49
S:The lawyer consulted the complainant.
 :Please continue to comply with all recommendations.
 :Their income is derived from common stock commitments.
 :The concern communicated its conclusions convincingly.
 :Under the circumstances, the company will command control.

I:(4)
*:_U_R_L50
S:     Character shows itself in a man's conduct.  Deeds speak
 :louder than words.  Words sometimes confuse an issue where
 :deeds clarify it.  The test of a man's sincerity is not what
 :he says but what he does.  Consider this well and you will
 :never be confused in estimating a man's worth.

G:_U_E_U10

#------------------------------------------------------------------------------
# Lesson U11
#------------------------------------------------------------------------------
*:U11
*:_U_S_U11
B:                            Lesson U11

*:_U_R_L51
T:
 :		(Drill on sion-tion Combinations)

I:(1)
*:_U_R_L52
D:asion esion ision osion usion
 :ation etion ition otion ution

I:(2)
*:_U_R_L53
D:action motion quotation session caution ambition
 :nation ration invention division exhibition attention
 :portion station intention possession connection situation
 :location creation condition impression completion commission

I:(3)
*:_U_R_L54
S:Information on the invention has been sent you.
 :The cancellation of the exhibition was announced.
 :Your communication of February 16 has been received.
 :Students are taught addition, subtraction, and division.
 :Your attention is called to the action of the Commission.

I:(4)
*:_U_R_L55
S:     Concentration is a valuable faculty.  The ability to direct
 :one's attention exclusively along certain lines accounts for
 :the success of some people.  Diffusion of effort is considered
 :an enemy of success.  We are told that this is an age of
 :specialization, and specialization demands concentration.

G:_U_E_U11

#------------------------------------------------------------------------------
# Lesson U12
#------------------------------------------------------------------------------
*:U12
*:_U_S_U12
B:                            Lesson U12

*:_U_R_L56
T:
 :	(Drill on ter, ther, tor, ture, ster, der Combinations)

I:(1)
*:_U_R_L57
D:ater oter etor utor ider ather other eture uture ister
 :eter uter itor ader oder ether uther iture aster oster
 :iter ator otor eder uder ither ature oture ester uster

I:(2)
*:_U_R_L58
D:water later actor order father future faster
 :alter matter motor wider mother nature poster
 :voter better factor reader rather feature master
 :writer letter doctor modern either fixture register

I:(3)
*:_U_R_L59
S:The voter was required to register.
 :The reader made a study of the literature.
 :The actor was better in the theatre than in pictures.
 :The writer wrote a letter to his future sister-in-law.
 :The minister received a letter from his father and mother.

I:(4)
*:_U_R_L60
S:     The best letter writers express themselves simply.  They
 :avoid long words where shorter words will do.  They have some-
 :thing to say and they say it interestingly and to the point.
 :A business letter should not be a literary masterpiece, but
 :that is not to say that it should not have style.

G:_U_E_U12

#------------------------------------------------------------------------------
# Lesson U13
#------------------------------------------------------------------------------
*:U13
*:_U_S_U13
B:                            Lesson U13

*:_U_R_L61
T:
 :	(Drill on qu, ch, wh, dw, sw, tw Combinations)
 :	(Drill on de, des, dis, ex, self, tran)
 :	(Drill on cial, cious, ology, ship, tive)

I:(1)
*:_U_R_L62
D:quick each white sweet dwell exist desire transfer
 :quest touch where swell dwarf expose desert transact
 :quiet cheap whole twist expect degree dislike transmit
 :queen child wheat twenty express deprive dismiss translate

I:(2)
*:_U_R_L63
D:special gracious active biology worship self-regard
 :official conscious native geology hardship self-respect
 :financial delicious positive pathology steamship self-defense

I:(3)
*:_U_R_L64
S:The squadron marched quickly and quietly.
 :When will the twenty cars of wheat go forward?
 :The study of psychology is a "must" in college.
 :We desire to dispose of our financial interests.
 :A selfish person has his own self-interest at heart.

I:(4)
*:_U_R_L65
S:Raymond Investment Co.
 :120 Wall Street
 :New York, NY 10005
 :
 :Gentlemen:
 :
 :     For many years our medium has been the leading adver-
 :tising paper used by responsible investment firms who desire
 :to obtain new accounts.
 :
 :     Our records show that you are not now making use of the
 :Adviser, and we ask that you consider its use in connection
 :with your new promotion effort.
 :
 :Yours truly,

I:(5)
*:_U_R_L66
S:Mr. Z. Dexter
 :250 Madison Avenue
 :New York, NY 10016
 :
 :Dear Mr. Dexter:
 :
 :I am enclosing herewith the annual report of our corporation
 :for the year just ended; also table showing Profit and Loss
 :Account for the past ten years.
 :
 :I am placing your name on our mailing list for all future
 :reports sent out by the company, and if at any time you have
 :any questions regarding the report or the company, if you
 :will advise me, I shall be happy to give you any additional
 :information that I may have.
 :
 :Very truly yours,

I:(6)
*:_U_R_L67
S:Strive for typing accuracy.  Speed without accuracy is of little value.
 :Rhythm is the secret of typing skill.  Don't write one part of a word
 :faster than another.  Slow down so that you can maintain a regular rhythm.
 :
 :Think of the letters before you strike them.  Strike the keys evenly, so
 :that the printing impression does not vary.  At the same time, try to
 :develop your stroking speed and make it a habit to release the keys quickly.
 :To get up speed, type each exercise three or four times.
 :
 :To do your best, it is necessary that you be relaxed.  You may be trying so
 :hard that you are all tied up in knots.  Relax consciously.  If you have a
 :feeling of tenseness and hurry, you are not properly relaxed.

G:_U_E_U13

#------------------------------------------------------------------------------
# Lesson series U jump tables
#------------------------------------------------------------------------------
*:_U_E_U1
Q: Do you want to continue to lesson U2 [Y/N] ?
N:_U_MENU
G:_U_S_U2
*:_U_E_U2
Q: Do you want to continue to lesson U3 [Y/N] ?
N:_U_MENU
G:_U_S_U3
*:_U_E_U3
Q: Do you want to continue to lesson U4 [Y/N] ?
N:_U_MENU
G:_U_S_U4
*:_U_E_U4
Q: Do you want to continue to lesson U5 [Y/N] ?
N:_U_MENU
G:_U_S_U5
*:_U_E_U5
Q: Do you want to continue to lesson U6 [Y/N] ?
N:_U_MENU
G:_U_S_U6
*:_U_E_U6
Q: Do you want to continue to lesson U7 [Y/N] ?
N:_U_MENU
G:_U_S_U7
*:_U_E_U7
Q: Do you want to continue to lesson U8 [Y/N] ?
N:_U_MENU
G:_U_S_U8
*:_U_E_U8
Q: Do you want to continue to lesson U9 [Y/N] ?
N:_U_MENU
G:_U_S_U9
*:_U_E_U9
Q: Do you want to continue to lesson U10 [Y/N] ?
N:_U_MENU
G:_U_S_U10
*:_U_E_U10
Q: Do you want to continue to lesson U11 [Y/N] ?
N:_U_MENU
G:_U_S_U11
*:_U_E_U11
Q: Do you want to continue to lesson U12 [Y/N] ?
N:_U_MENU
G:_U_S_U12
*:_U_E_U12
Q: Do you want to continue to lesson U13 [Y/N] ?
N:_U_MENU
G:_U_S_U13
*:_U_E_U13
G:_U_MENU

#------------------------------------------------------------------------------
# Lesson series U menu
#------------------------------------------------------------------------------
*:_U_MENU
B:                     QWERTY Review lessons
M: UP=_EXIT "The U series contains the following 13 lessons"
 :_U_S_U1  "Lesson U1     Home row"
 :_U_S_U2  "Lesson U2     Other letters"
 :_U_S_U3  "Lesson U3     Shift numerals figs"
 :_U_S_U4  "Lesson U4     Practise"
 :_U_S_U5  "Lesson U5     Drill on S Combinations"
 :_U_S_U6  "Lesson U6     Drill on R Combinations"
 :_U_S_U7  "Lesson U7     Drill on L Combinations"
 :_U_S_U8  "Lesson U8     Drill on D-T Combinations"
 :_U_S_U9  "Lesson U9     Drill on M-N Combinations"
 :_U_S_U10 "Lesson U10    Drill on com-con Combinations"
 :_U_S_U11 "Lesson U11    Drill on sion-tion Combinations"
 :_U_S_U12 "Lesson U12    Drill on ter, ther, tor, ture, ster, der"
 :_U_S_U13 "Lesson U13    Drill on qu, ch, wh, dw, sw, tw, de, des, dis, ex,"
 :_U_S_U13 "              self, tran, cial, cious, ology, ship, tive"
*:_U_EXIT
#------------------------------------------------------------------------------
