/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.objectstore;

import com.arjuna.ats.arjuna.common.ObjectStoreEnvironmentBean;
import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.objectstore.ObjectStoreAPI;
import com.arjuna.ats.arjuna.state.InputObjectState;
import java.io.File;
import java.io.SyncFailedException;

public abstract class ObjectStore
implements ObjectStoreAPI {
    protected final int shareStatus;
    protected final String _objectStoreRoot;
    private final String _objectStoreDir;

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public boolean allObjUids(String s, InputObjectState buff) throws ObjectStoreException {
        return this.allObjUids(s, buff, -1);
    }

    @Override
    public void sync() throws SyncFailedException, ObjectStoreException {
    }

    public String locateStore(String localOSRoot) throws ObjectStoreException {
        Object toReturn = null;
        if (localOSRoot == null || ((String)localOSRoot).length() == 0) {
            localOSRoot = this._objectStoreRoot != null && this._objectStoreRoot.length() > 0 ? this._objectStoreRoot : "defaultStore" + File.separator;
        }
        if (localOSRoot != null && ((String)localOSRoot).length() > 0) {
            toReturn = this._objectStoreDir + File.separator + (String)localOSRoot;
        }
        if (!((String)toReturn).endsWith(File.separator)) {
            toReturn = (String)toReturn + File.separator;
        }
        return toReturn;
    }

    @Override
    public boolean fullCommitNeeded() {
        return true;
    }

    @Override
    public boolean isType(Uid u, String tn, int st) throws ObjectStoreException {
        return this.currentState(u, tn) == st;
    }

    public final void initialise(Uid u, String tn) {
    }

    public final int shareState() {
        return this.shareStatus;
    }

    public final String storeDir() {
        return this._objectStoreDir;
    }

    public final String storeRoot() {
        return this._objectStoreRoot;
    }

    protected ObjectStore(ObjectStoreEnvironmentBean objectStoreEnvironmentBean) throws ObjectStoreException {
        this.shareStatus = objectStoreEnvironmentBean.getShare();
        if (objectStoreEnvironmentBean.getObjectStoreDir() == null || objectStoreEnvironmentBean.getObjectStoreDir().length() == 0) {
            throw new ObjectStoreException("object store location property not set.");
        }
        this._objectStoreRoot = objectStoreEnvironmentBean.getLocalOSRoot() == null ? "" : objectStoreEnvironmentBean.getLocalOSRoot();
        Object storeDir = objectStoreEnvironmentBean.getObjectStoreDir();
        if (!((String)storeDir).endsWith(File.separator)) {
            storeDir = (String)storeDir + File.separator;
        }
        this._objectStoreDir = (String)storeDir + this.getClass().getSimpleName();
    }

    protected abstract boolean supressEntry(String var1);

    protected String revealedId(String name) {
        return name;
    }
}

