/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.truetype;

import org.pentaho.reporting.libraries.fonts.registry.BaselineInfo;
import org.pentaho.reporting.libraries.fonts.registry.FontMetrics;
import org.pentaho.reporting.libraries.fonts.tools.StrictGeomUtility;
import org.pentaho.reporting.libraries.fonts.truetype.ScalableTrueTypeFontMetrics;

public class TrueTypeFontMetrics
implements FontMetrics {
    private ScalableTrueTypeFontMetrics fontMetrics;
    private double fontSize;

    public TrueTypeFontMetrics(ScalableTrueTypeFontMetrics fontMetrics, double fontSize) {
        if (fontMetrics == null) {
            throw new NullPointerException("The font must not be null");
        }
        this.fontMetrics = fontMetrics;
        this.fontSize = fontSize;
    }

    @Override
    public boolean isUniformFontMetrics() {
        return true;
    }

    @Override
    public long getAscent() {
        return (long)(this.fontSize * (double)this.fontMetrics.getAscent());
    }

    @Override
    public long getDescent() {
        return (long)(this.fontSize * (double)this.fontMetrics.getDescent());
    }

    @Override
    public long getLeading() {
        return (long)(this.fontSize * (double)this.fontMetrics.getLeading());
    }

    @Override
    public long getXHeight() {
        return (long)(this.fontSize * (double)this.fontMetrics.getXHeight());
    }

    @Override
    public long getOverlinePosition() {
        return this.getLeading() - Math.max(1000L, StrictGeomUtility.toInternalValue(this.fontSize) / 20L);
    }

    @Override
    public long getUnderlinePosition() {
        return (long)(this.fontSize * (double)this.fontMetrics.getUnderlinePosition());
    }

    @Override
    public long getStrikeThroughPosition() {
        return (long)(this.fontSize * (double)this.fontMetrics.getStrikeThroughPosition());
    }

    @Override
    public long getMaxAscent() {
        return (long)(this.fontSize * (double)this.fontMetrics.getMaxAscent());
    }

    @Override
    public long getMaxDescent() {
        return (long)(this.fontSize * (double)this.fontMetrics.getMaxDescent());
    }

    @Override
    public long getItalicAngle() {
        return this.fontMetrics.getItalicAngle();
    }

    @Override
    public long getMaxHeight() {
        return (long)((double)(this.fontMetrics.getMaxAscent() + this.fontMetrics.getMaxDescent() + this.fontMetrics.getLeading()) * this.fontSize);
    }

    @Override
    public long getMaxCharAdvance() {
        return (long)((double)this.fontMetrics.getMaxCharAdvance() * this.fontSize);
    }

    @Override
    public long getCharWidth(int character) {
        return 0L;
    }

    @Override
    public long getKerning(int previous, int character) {
        return 0L;
    }

    @Override
    public BaselineInfo getBaselines(int c, BaselineInfo info) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }
}

