/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.cmd;

import java.net.InetAddress;
import net.wimpi.modbus.Modbus;
import net.wimpi.modbus.io.ModbusUDPTransaction;
import net.wimpi.modbus.msg.WriteCoilRequest;
import net.wimpi.modbus.net.UDPMasterConnection;

public class UDPDOTest {
    public static void main(String[] args) {
        UDPMasterConnection conn = null;
        ModbusUDPTransaction trans = null;
        WriteCoilRequest req = null;
        InetAddress addr = null;
        int ref = 0;
        boolean set = false;
        int repeat = 1;
        int port = 502;
        try {
            if (args.length < 3) {
                UDPDOTest.printUsage();
                System.exit(1);
            } else {
                try {
                    String astr = args[0];
                    int idx = astr.indexOf(58);
                    if (idx > 0) {
                        port = Integer.parseInt(astr.substring(idx + 1));
                        astr = astr.substring(0, idx);
                    }
                    addr = InetAddress.getByName(astr);
                    ref = Integer.parseInt(args[1]);
                    set = "true".equals(args[2]);
                    if (args.length == 4) {
                        repeat = Integer.parseInt(args[3]);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    UDPDOTest.printUsage();
                    System.exit(1);
                }
            }
            conn = new UDPMasterConnection(addr);
            conn.setPort(502);
            conn.connect();
            req = new WriteCoilRequest(ref, set);
            req.setUnitID(0);
            if (Modbus.debug) {
                System.out.println("Request: " + req.getHexMessage());
            }
            trans = new ModbusUDPTransaction(conn);
            trans.setRequest(req);
            int k = 0;
            do {
                trans.execute();
                if (!Modbus.debug) continue;
                System.out.println("Response: " + trans.getResponse().getHexMessage());
            } while (++k < repeat);
            conn.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void printUsage() {
        System.out.println("java net.wimpi.modbus.cmd.UDPDOTest <address{:<port>} [String]> <register [int16]> <state [boolean]> {<repeat [int]>}");
    }
}

