/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.websocket;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.ws.rs.core.SecurityContext;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jetty.websocket.server.WebSocketServerFactory;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeRequest;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeResponse;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;
import org.eclipse.jetty.websocket.servlet.WebSocketServlet;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;
import org.openhab.core.auth.AuthenticationException;
import org.openhab.core.io.rest.auth.AuthFilter;
import org.openhab.core.io.websocket.WebSocketAdapter;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.http.NamespaceException;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardServletName;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardServletPattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@HttpWhiteboardServletName(value="/ws")
@HttpWhiteboardServletPattern(value={"/ws/*"})
@Component(immediate=true, service={Servlet.class})
public class CommonWebSocketServlet
extends WebSocketServlet {
    private static final long serialVersionUID = 1L;
    public static final String SERVLET_PATH = "/ws";
    public static final String DEFAULT_ADAPTER_ID = "event-subscriber";
    private final Map<String, WebSocketAdapter> connectionHandlers = new HashMap<String, WebSocketAdapter>();
    private final AuthFilter authFilter;
    private @Nullable WebSocketServerFactory importNeeded;

    @Activate
    public CommonWebSocketServlet(@Reference AuthFilter authFilter) throws ServletException, NamespaceException {
        this.authFilter = authFilter;
    }

    public void configure(@NonNullByDefault(value={}) WebSocketServletFactory webSocketServletFactory) {
        webSocketServletFactory.getPolicy().setIdleTimeout(10000L);
        webSocketServletFactory.setCreator((WebSocketCreator)new CommonWebSocketCreator());
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addWebSocketAdapter(WebSocketAdapter wsAdapter) {
        this.connectionHandlers.put(wsAdapter.getId(), wsAdapter);
    }

    protected void removeWebSocketAdapter(WebSocketAdapter wsAdapter) {
        this.connectionHandlers.remove(wsAdapter.getId());
    }

    private class CommonWebSocketCreator
    implements WebSocketCreator {
        private final Logger logger = LoggerFactory.getLogger(CommonWebSocketCreator.class);

        private CommonWebSocketCreator() {
        }

        public @Nullable Object createWebSocket(@Nullable ServletUpgradeRequest servletUpgradeRequest, @Nullable ServletUpgradeResponse servletUpgradeResponse) {
            if (servletUpgradeRequest == null || servletUpgradeResponse == null) {
                return null;
            }
            if (this.isAuthorizedRequest(servletUpgradeRequest)) {
                WebSocketAdapter wsAdapter;
                String pathPrefix;
                boolean useDefaultAdapter;
                String requestPath = servletUpgradeRequest.getRequestURI().getPath();
                boolean bl = useDefaultAdapter = requestPath.equals(pathPrefix = "/ws/") || !requestPath.startsWith(pathPrefix);
                if (!useDefaultAdapter) {
                    String adapterId = requestPath.substring(pathPrefix.length());
                    wsAdapter = CommonWebSocketServlet.this.connectionHandlers.get(adapterId);
                    if (wsAdapter == null) {
                        this.logger.warn("Missing WebSocket adapter for path {}", (Object)adapterId);
                        return null;
                    }
                } else {
                    wsAdapter = CommonWebSocketServlet.this.connectionHandlers.get(CommonWebSocketServlet.DEFAULT_ADAPTER_ID);
                    if (wsAdapter == null) {
                        this.logger.warn("Default WebSocket adapter is missing");
                        return null;
                    }
                }
                this.logger.debug("New connection handled by {}", (Object)wsAdapter.getId());
                return wsAdapter.createWebSocket(servletUpgradeRequest, servletUpgradeResponse);
            }
            this.logger.warn("Unauthenticated request to create a websocket from {}.", (Object)servletUpgradeRequest.getRemoteAddress());
            return null;
        }

        private boolean isAuthorizedRequest(ServletUpgradeRequest servletUpgradeRequest) {
            try {
                SecurityContext securityContext = CommonWebSocketServlet.this.authFilter.getSecurityContext(servletUpgradeRequest.getHttpServletRequest(), true);
                return securityContext != null && (securityContext.isUserInRole("user") || securityContext.isUserInRole("administrator"));
            }
            catch (IOException | AuthenticationException e) {
                this.logger.warn("Error handling WebSocket authorization", e);
                return false;
            }
        }
    }
}

