/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.net.InetSocketAddress;
import java.util.Arrays;
import org.eclipse.californium.elements.util.NoPublicAPI;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.HandshakeType;

@NoPublicAPI
public class GenericHandshakeMessage
extends HandshakeMessage {
    private final HandshakeType type;

    protected GenericHandshakeMessage(HandshakeType type, InetSocketAddress peerAddress) {
        super(peerAddress);
        this.type = type;
    }

    @Override
    public HandshakeType getMessageType() {
        return this.type;
    }

    @Override
    public int getMessageLength() {
        return this.getRawMessage().length - 12;
    }

    @Override
    public byte[] fragmentToByteArray() {
        byte[] rawMessage = this.getRawMessage();
        return Arrays.copyOfRange(rawMessage, 12, rawMessage.length);
    }

    public static GenericHandshakeMessage fromByteArray(HandshakeType type, InetSocketAddress peerAddress) {
        return new GenericHandshakeMessage(type, peerAddress);
    }
}

