/*
 * Decompiled with CFR 0.152.
 */
package processing.app.debug;

import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventIterator;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.event.ExceptionEvent;
import com.sun.jdi.event.MethodEntryEvent;
import com.sun.jdi.event.MethodExitEvent;
import com.sun.jdi.event.ModificationWatchpointEvent;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import com.sun.jdi.event.VMStartEvent;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.ExceptionRequest;
import com.sun.jdi.request.ModificationWatchpointRequest;
import com.sun.jdi.request.StepRequest;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import processing.app.debug.Runner;

public class EventThread
extends Thread {
    private final Runner parent;
    private final VirtualMachine vm;
    private final String[] excludes;
    private final PrintWriter writer;
    static String nextBaseIndent = "";
    private boolean connected = true;
    private boolean vmDied = true;
    private Map traceMap = new HashMap();

    public EventThread(Runner parent, VirtualMachine vm, String[] excludes, PrintWriter writer) {
        super("event-handler");
        this.parent = parent;
        this.vm = vm;
        this.excludes = excludes;
        this.writer = writer;
    }

    public void run() {
        EventQueue queue = this.vm.eventQueue();
        while (this.connected) {
            try {
                EventSet eventSet = queue.remove();
                EventIterator it = eventSet.eventIterator();
                while (it.hasNext()) {
                    this.handleEvent(it.nextEvent());
                }
                eventSet.resume();
            }
            catch (InterruptedException exc) {
            }
            catch (VMDisconnectedException discExc) {
                this.handleDisconnectedException();
                break;
            }
        }
    }

    public void setEventRequests(boolean watchFields) {
        EventRequestManager mgr = this.vm.eventRequestManager();
        ExceptionRequest excReq = mgr.createExceptionRequest(null, false, true);
        excReq.setSuspendPolicy(2);
        excReq.enable();
    }

    ThreadTrace threadTrace(ThreadReference thread) {
        ThreadTrace trace = (ThreadTrace)this.traceMap.get(thread);
        if (trace == null) {
            trace = new ThreadTrace(thread);
            this.traceMap.put(thread, trace);
        }
        return trace;
    }

    private void handleEvent(Event event) {
        if (event instanceof ExceptionEvent) {
            this.exceptionEvent((ExceptionEvent)event);
        } else if (event instanceof ModificationWatchpointEvent) {
            this.fieldWatchEvent((ModificationWatchpointEvent)event);
        } else if (event instanceof MethodEntryEvent) {
            this.methodEntryEvent((MethodEntryEvent)event);
        } else if (event instanceof MethodExitEvent) {
            this.methodExitEvent((MethodExitEvent)event);
        } else if (event instanceof StepEvent) {
            this.stepEvent((StepEvent)event);
        } else if (event instanceof ThreadDeathEvent) {
            this.threadDeathEvent((ThreadDeathEvent)event);
        } else if (event instanceof ClassPrepareEvent) {
            this.classPrepareEvent((ClassPrepareEvent)event);
        } else if (event instanceof VMStartEvent) {
            this.vmStartEvent((VMStartEvent)event);
        } else if (event instanceof VMDeathEvent) {
            this.vmDeathEvent((VMDeathEvent)event);
        } else if (event instanceof VMDisconnectEvent) {
            this.vmDisconnectEvent((VMDisconnectEvent)event);
        } else {
            throw new Error("Unexpected event type");
        }
    }

    synchronized void handleDisconnectedException() {
        EventQueue queue = this.vm.eventQueue();
        while (this.connected) {
            try {
                EventSet eventSet = queue.remove();
                EventIterator iter = eventSet.eventIterator();
                while (iter.hasNext()) {
                    Event event = iter.nextEvent();
                    if (event instanceof VMDeathEvent) {
                        this.vmDeathEvent((VMDeathEvent)event);
                        continue;
                    }
                    if (!(event instanceof VMDisconnectEvent)) continue;
                    this.vmDisconnectEvent((VMDisconnectEvent)event);
                }
                eventSet.resume();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void vmStartEvent(VMStartEvent event) {
        if (this.writer != null) {
            this.writer.println("-- VM Started --");
        }
    }

    private void methodEntryEvent(MethodEntryEvent event) {
        this.threadTrace(event.thread()).methodEntryEvent(event);
    }

    private void methodExitEvent(MethodExitEvent event) {
        this.threadTrace(event.thread()).methodExitEvent(event);
    }

    private void stepEvent(StepEvent event) {
        this.threadTrace(event.thread()).stepEvent(event);
    }

    private void fieldWatchEvent(ModificationWatchpointEvent event) {
        this.threadTrace(event.thread()).fieldWatchEvent(event);
    }

    void threadDeathEvent(ThreadDeathEvent event) {
        ThreadTrace trace = (ThreadTrace)this.traceMap.get(event.thread());
        if (trace != null) {
            trace.threadDeathEvent(event);
        }
    }

    private void classPrepareEvent(ClassPrepareEvent event) {
        EventRequestManager mgr = this.vm.eventRequestManager();
        List<Field> fields = event.referenceType().visibleFields();
        for (Field field : fields) {
            ModificationWatchpointRequest req = mgr.createModificationWatchpointRequest(field);
            for (int i = 0; i < this.excludes.length; ++i) {
                req.addClassExclusionFilter(this.excludes[i]);
            }
            req.setSuspendPolicy(0);
            req.enable();
        }
    }

    private void exceptionEvent(ExceptionEvent event) {
        this.parent.exception(event);
    }

    public void vmDeathEvent(VMDeathEvent event) {
        this.vmDied = true;
        if (this.writer != null) {
            this.writer.println("-- The application exited --");
        }
    }

    public void vmDisconnectEvent(VMDisconnectEvent event) {
        this.connected = false;
        if (!this.vmDied && this.writer != null) {
            this.writer.println("-- The application has been disconnected --");
        }
    }

    class ThreadTrace {
        final ThreadReference thread;
        final String baseIndent;
        static final String threadDelta = "                     ";
        StringBuffer indent;

        ThreadTrace(ThreadReference thread) {
            this.thread = thread;
            this.baseIndent = nextBaseIndent;
            this.indent = new StringBuffer(this.baseIndent);
            nextBaseIndent = nextBaseIndent + threadDelta;
            this.println("====== " + thread.name() + " ======");
        }

        private void println(String str) {
            if (EventThread.this.writer != null) {
                EventThread.this.writer.print(this.indent);
                EventThread.this.writer.println(str);
                EventThread.this.writer.flush();
            }
        }

        void methodEntryEvent(MethodEntryEvent event) {
            this.println(event.method().name() + "  --  " + event.method().declaringType().name());
            this.indent.append("| ");
        }

        void methodExitEvent(MethodExitEvent event) {
            this.indent.setLength(this.indent.length() - 2);
        }

        void fieldWatchEvent(ModificationWatchpointEvent event) {
            Field field = event.field();
            Value value = event.valueToBe();
            this.println("    " + field.name() + " = " + value);
        }

        void exceptionEvent(ExceptionEvent event) {
            this.println("Exception: " + event.exception() + " catch: " + event.catchLocation());
            EventRequestManager mgr = EventThread.this.vm.eventRequestManager();
            StepRequest req = mgr.createStepRequest(this.thread, -1, 1);
            req.addCountFilter(1);
            req.setSuspendPolicy(2);
            req.enable();
        }

        void stepEvent(StepEvent event) {
            int cnt = 0;
            this.indent = new StringBuffer(this.baseIndent);
            try {
                cnt = this.thread.frameCount();
            }
            catch (IncompatibleThreadStateException exc) {
                // empty catch block
            }
            while (cnt-- > 0) {
                this.indent.append("| ");
            }
            EventRequestManager mgr = EventThread.this.vm.eventRequestManager();
            mgr.deleteEventRequest(event.request());
        }

        void threadDeathEvent(ThreadDeathEvent event) {
            this.indent = new StringBuffer(this.baseIndent);
            this.println("====== " + this.thread.name() + " end ======");
        }
    }
}

