/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import kafka.network.RequestChannel;
import kafka.server.AuthHelper;
import kafka.server.DelayedFuturePurgatory;
import kafka.server.KafkaConfig;
import kafka.server.RequestHandlerHelper;
import kafka.utils.Logging;
import kafka.utils.NotNothing$;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.SecurityDisabledException;
import org.apache.kafka.common.message.CreateAclsRequestData;
import org.apache.kafka.common.message.CreateAclsResponseData;
import org.apache.kafka.common.message.DeleteAclsResponseData;
import org.apache.kafka.common.message.DescribeAclsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.CreateAclsRequest;
import org.apache.kafka.common.requests.CreateAclsResponse;
import org.apache.kafka.common.requests.DeleteAclsRequest;
import org.apache.kafka.common.requests.DeleteAclsResponse;
import org.apache.kafka.common.requests.DescribeAclsRequest;
import org.apache.kafka.common.requests.DescribeAclsResponse;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.Authorizer;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005}4AAD\b\u0001)!A\u0011\u0005\u0001B\u0001B\u0003%!\u0005\u0003\u0005'\u0001\t\u0005\t\u0015!\u0003(\u0011!)\u0004A!A!\u0002\u00131\u0004\u0002C\u001d\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001e\t\u0011\u0015\u0003!\u0011!Q\u0001\n\u0019CQ!\u0013\u0001\u0005\u0002)Cq!\u0015\u0001C\u0002\u0013%!\u000b\u0003\u0004W\u0001\u0001\u0006Ia\u0015\u0005\u0006/\u0002!\t\u0001\u0017\u0005\u00069\u0002!\t!\u0018\u0005\u0006C\u0002!\tA\u0019\u0005\u0006s\u0002!\tA\u001f\u0005\u0006y\u0002!\t! \u0002\b\u0003\u000ed\u0017\t]5t\u0015\t\u0001\u0012#\u0001\u0004tKJ4XM\u001d\u0006\u0002%\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001\u00167A\u0011a#G\u0007\u0002/)\t\u0001$A\u0003tG\u0006d\u0017-\u0003\u0002\u001b/\t1\u0011I\\=SK\u001a\u0004\"\u0001H\u0010\u000e\u0003uQ!AH\t\u0002\u000bU$\u0018\u000e\\:\n\u0005\u0001j\"a\u0002'pO\u001eLgnZ\u0001\u000bCV$\b\u000eS3ma\u0016\u0014\bCA\u0012%\u001b\u0005y\u0011BA\u0013\u0010\u0005)\tU\u000f\u001e5IK2\u0004XM]\u0001\u000bCV$\bn\u001c:ju\u0016\u0014\bc\u0001\f)U%\u0011\u0011f\u0006\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005-\u001aT\"\u0001\u0017\u000b\u0005\u0019j#B\u0001\t/\u0015\t\u0011rF\u0003\u00021c\u00051\u0011\r]1dQ\u0016T\u0011AM\u0001\u0004_J<\u0017B\u0001\u001b-\u0005)\tU\u000f\u001e5pe&TXM]\u0001\u000ee\u0016\fX/Z:u\u0011\u0016d\u0007/\u001a:\u0011\u0005\r:\u0014B\u0001\u001d\u0010\u0005Q\u0011V-];fgRD\u0015M\u001c3mKJDU\r\u001c9fe\u0006!a.Y7f!\tY$I\u0004\u0002=\u0001B\u0011QhF\u0007\u0002})\u0011qhE\u0001\u0007yI|w\u000e\u001e \n\u0005\u0005;\u0012A\u0002)sK\u0012,g-\u0003\u0002D\t\n11\u000b\u001e:j]\u001eT!!Q\f\u0002\r\r|gNZ5h!\t\u0019s)\u0003\u0002I\u001f\tY1*\u00194lC\u000e{gNZ5h\u0003\u0019a\u0014N\\5u}Q11\nT'O\u001fB\u0003\"a\t\u0001\t\u000b\u00052\u0001\u0019\u0001\u0012\t\u000b\u00192\u0001\u0019A\u0014\t\u000bU2\u0001\u0019\u0001\u001c\t\u000be2\u0001\u0019\u0001\u001e\t\u000b\u00153\u0001\u0019\u0001$\u0002%\u0005dG/\u001a:BG2\u001c\b+\u001e:hCR|'/_\u000b\u0002'B\u00111\u0005V\u0005\u0003+>\u0011a\u0003R3mCf,GMR;ukJ,\u0007+\u001e:hCR|'/_\u0001\u0014C2$XM]!dYN\u0004VO]4bi>\u0014\u0018\u0010I\u0001\tSN\u001cEn\\:fIV\t\u0011\f\u0005\u0002\u00175&\u00111l\u0006\u0002\b\u0005>|G.Z1o\u0003\u0015\u0019Gn\\:f)\u0005q\u0006C\u0001\f`\u0013\t\u0001wC\u0001\u0003V]&$\u0018A\u00055b]\u0012dW\rR3tGJL'-Z!dYN$\"aY7\u0011\u0007\u0011\\g,D\u0001f\u0015\t1w-\u0001\u0006d_:\u001cWO\u001d:f]RT!\u0001[5\u0002\tU$\u0018\u000e\u001c\u0006\u0002U\u0006!!.\u0019<b\u0013\taWMA\tD_6\u0004H.\u001a;bE2,g)\u001e;ve\u0016DQA\\\u0006A\u0002=\fqA]3rk\u0016\u001cH\u000f\u0005\u0002qm:\u0011\u0011\u000f^\u0007\u0002e*\u00111/E\u0001\b]\u0016$xo\u001c:l\u0013\t)(/\u0001\bSKF,Xm\u001d;DQ\u0006tg.\u001a7\n\u0005]D(a\u0002*fcV,7\u000f\u001e\u0006\u0003kJ\f\u0001\u0003[1oI2,7I]3bi\u0016\f5\r\\:\u0015\u0005\r\\\b\"\u00028\r\u0001\u0004y\u0017\u0001\u00055b]\u0012dW\rR3mKR,\u0017i\u00197t)\t\u0019g\u0010C\u0003o\u001b\u0001\u0007q\u000e")
public class AclApis
implements Logging {
    private final AuthHelper authHelper;
    private final Option<Authorizer> authorizer;
    private final RequestHandlerHelper requestHelper;
    private final KafkaConfig config;
    private final DelayedFuturePurgatory alterAclsPurgatory;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private DelayedFuturePurgatory alterAclsPurgatory() {
        return this.alterAclsPurgatory;
    }

    public boolean isClosed() {
        return this.alterAclsPurgatory().isShutdown();
    }

    public void close() {
        this.alterAclsPurgatory().shutdown();
    }

    public CompletableFuture<BoxedUnit> handleDescribeAcls(RequestChannel.Request request) {
        this.authHelper.authorizeClusterOperation(request, AclOperation.DESCRIBE);
        DescribeAclsRequest describeAclsRequest = (DescribeAclsRequest)request.body(ClassTag$.MODULE$.apply(DescribeAclsRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        Option<Authorizer> option = this.authorizer;
        if (None$.MODULE$.equals(option)) {
            this.requestHelper.sendResponseMaybeThrottle(request, (Function1<Object, AbstractResponse>)(Function1 & Serializable)requestThrottleMs -> AclApis.$anonfun$handleDescribeAcls$1(describeAclsRequest, BoxesRunTime.unboxToInt((Object)requestThrottleMs)));
        } else if (option instanceof Some) {
            Authorizer auth = (Authorizer)((Some)option).value();
            AclBindingFilter filter = describeAclsRequest.filter();
            HashSet returnedAcls = new HashSet();
            auth.acls(filter).forEach(x$1 -> returnedAcls.add(x$1));
            this.requestHelper.sendResponseMaybeThrottle(request, (Function1<Object, AbstractResponse>)(Function1 & Serializable)requestThrottleMs -> AclApis.$anonfun$handleDescribeAcls$3(returnedAcls, describeAclsRequest, BoxesRunTime.unboxToInt((Object)requestThrottleMs)));
        } else {
            throw new MatchError(option);
        }
        return CompletableFuture.completedFuture(BoxedUnit.UNIT);
    }

    public CompletableFuture<BoxedUnit> handleCreateAcls(RequestChannel.Request request) {
        this.authHelper.authorizeClusterOperation(request, AclOperation.ALTER);
        CreateAclsRequest createAclsRequest = (CreateAclsRequest)request.body(ClassTag$.MODULE$.apply(CreateAclsRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        Option<Authorizer> option = this.authorizer;
        if (None$.MODULE$.equals(option)) {
            this.requestHelper.sendResponseMaybeThrottle(request, (Function1<Object, AbstractResponse>)(Function1 & Serializable)requestThrottleMs -> createAclsRequest.getErrorResponse(BoxesRunTime.unboxToInt((Object)requestThrottleMs), (Throwable)new SecurityDisabledException("No Authorizer is configured.")));
            return CompletableFuture.completedFuture(BoxedUnit.UNIT);
        }
        if (option instanceof Some) {
            Authorizer auth = (Authorizer)((Some)option).value();
            Buffer allBindings = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(createAclsRequest.aclCreations()).asScala().map((Function1 & Serializable)x$1 -> CreateAclsRequest.aclBinding((CreateAclsRequestData.AclCreation)x$1));
            Map errorResults = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
            ArrayBuffer validBindings = new ArrayBuffer();
            allBindings.foreach(arg_0 -> AclApis.$anonfun$handleCreateAcls$3(this, errorResults, validBindings, arg_0));
            CompletableFuture future = new CompletableFuture();
            Buffer createResults = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(auth.createAcls((AuthorizableRequestContext)request.context(), CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)validBindings).asJava())).asScala().map((Function1 & Serializable)x$1 -> x$1.toCompletableFuture());
            this.alterAclsPurgatory().tryCompleteElseWatch(Predef$.MODULE$.Long2long(this.config.connectionsMaxIdleMs()), createResults, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> AclApis.sendResponseCallback$1(allBindings, errorResults, createResults, validBindings, future));
            return future.thenApply(aclCreationResults -> {
                this.requestHelper.sendResponseMaybeThrottle(request, (Function1<Object, AbstractResponse>)(Function1 & Serializable)requestThrottleMs -> AclApis.$anonfun$handleCreateAcls$12(aclCreationResults, BoxesRunTime.unboxToInt((Object)requestThrottleMs)));
                return BoxedUnit.UNIT;
            });
        }
        throw new MatchError(option);
    }

    public CompletableFuture<BoxedUnit> handleDeleteAcls(RequestChannel.Request request) {
        this.authHelper.authorizeClusterOperation(request, AclOperation.ALTER);
        DeleteAclsRequest deleteAclsRequest = (DeleteAclsRequest)request.body(ClassTag$.MODULE$.apply(DeleteAclsRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        Option<Authorizer> option = this.authorizer;
        if (None$.MODULE$.equals(option)) {
            this.requestHelper.sendResponseMaybeThrottle(request, (Function1<Object, AbstractResponse>)(Function1 & Serializable)requestThrottleMs -> deleteAclsRequest.getErrorResponse(BoxesRunTime.unboxToInt((Object)requestThrottleMs), (Throwable)new SecurityDisabledException("No Authorizer is configured.")));
            return CompletableFuture.completedFuture(BoxedUnit.UNIT);
        }
        if (option instanceof Some) {
            Authorizer auth = (Authorizer)((Some)option).value();
            CompletableFuture future = new CompletableFuture();
            List deleteResults = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(auth.deleteAcls((AuthorizableRequestContext)request.context(), deleteAclsRequest.filters())).asScala().map((Function1 & Serializable)x$2 -> x$2.toCompletableFuture())).toList();
            this.alterAclsPurgatory().tryCompleteElseWatch(Predef$.MODULE$.Long2long(this.config.connectionsMaxIdleMs()), deleteResults, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> AclApis.sendResponseCallback$2(deleteResults, future));
            return future.thenApply(filterResults -> {
                this.requestHelper.sendResponseMaybeThrottle(request, (Function1<Object, AbstractResponse>)(Function1 & Serializable)requestThrottleMs -> AclApis.$anonfun$handleDeleteAcls$7(filterResults, deleteAclsRequest$1, BoxesRunTime.unboxToInt((Object)requestThrottleMs)));
                return BoxedUnit.UNIT;
            });
        }
        throw new MatchError(option);
    }

    public static final /* synthetic */ DescribeAclsResponse $anonfun$handleDescribeAcls$1(DescribeAclsRequest describeAclsRequest$1, int requestThrottleMs) {
        return new DescribeAclsResponse(new DescribeAclsResponseData().setErrorCode(Errors.SECURITY_DISABLED.code()).setErrorMessage("No Authorizer is configured on the broker").setThrottleTimeMs(requestThrottleMs), describeAclsRequest$1.version());
    }

    public static final /* synthetic */ DescribeAclsResponse $anonfun$handleDescribeAcls$3(HashSet returnedAcls$1, DescribeAclsRequest describeAclsRequest$1, int requestThrottleMs) {
        return new DescribeAclsResponse(new DescribeAclsResponseData().setThrottleTimeMs(requestThrottleMs).setResources(DescribeAclsResponse.aclsResources((Collection)returnedAcls$1)), describeAclsRequest$1.version());
    }

    public static final /* synthetic */ String $anonfun$handleCreateAcls$4(AclBinding acl$1, ResourcePattern resource$1) {
        return new StringBuilder(22).append("Failed to add acl ").append(acl$1).append(" to ").append(resource$1).toString();
    }

    public static final /* synthetic */ InvalidRequestException $anonfun$handleCreateAcls$5(InvalidRequestException throwable$1) {
        return throwable$1;
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ Object $anonfun$handleCreateAcls$3(AclApis $this, Map errorResults$1, ArrayBuffer validBindings$1, AclBinding acl) {
        resource = acl.pattern();
        v0 = resource.resourceType();
        var6_5 = ResourceType.CLUSTER;
        if (v0 != null ? v0.equals(var6_5) == false : var6_5 != null) ** GOTO lbl-1000
        if (!resource.name().equals("kafka-cluster")) {
            v1 = new InvalidRequestException("The only valid name for the CLUSTER resource is kafka-cluster");
        } else lbl-1000:
        // 2 sources

        {
            v1 = throwable = resource.name().isEmpty() != false ? new InvalidRequestException("Invalid empty resource name") : null;
        }
        if (throwable != null) {
            $this.debug((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$handleCreateAcls$4(org.apache.kafka.common.acl.AclBinding org.apache.kafka.common.resource.ResourcePattern ), ()Ljava/lang/String;)((AclBinding)acl, (ResourcePattern)resource), (Function0<Throwable>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$handleCreateAcls$5(org.apache.kafka.common.errors.InvalidRequestException ), ()Lorg/apache/kafka/common/errors/InvalidRequestException;)((InvalidRequestException)throwable));
            errorResults$1.update((Object)acl, (Object)new AclCreateResult((ApiException)throwable));
            return BoxedUnit.UNIT;
        }
        return validBindings$1.$plus$eq((Object)acl);
    }

    private static final void sendResponseCallback$1(Buffer allBindings$1, Map errorResults$1, Buffer createResults$1, ArrayBuffer validBindings$1, CompletableFuture future$1) {
        Buffer aclCreationResults = (Buffer)allBindings$1.map((Function1 & Serializable)acl -> {
            AclCreateResult result = (AclCreateResult)errorResults$1.getOrElse(acl, (Function0 & Serializable)() -> (AclCreateResult)((CompletableFuture)createResults$1.apply(validBindings$1.indexOf(acl))).get());
            CreateAclsResponseData.AclCreationResult creationResult = new CreateAclsResponseData.AclCreationResult();
            OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(result.exception())).foreach((Function1 & Serializable)throwable -> {
                ApiError apiError = ApiError.fromThrowable((Throwable)throwable);
                return creationResult.setErrorCode(apiError.error().code()).setErrorMessage(apiError.message());
            });
            return creationResult;
        });
        future$1.complete(CollectionConverters$.MODULE$.BufferHasAsJava(aclCreationResults).asJava());
    }

    public static final /* synthetic */ CreateAclsResponse $anonfun$handleCreateAcls$12(java.util.List aclCreationResults$1, int requestThrottleMs) {
        return new CreateAclsResponse(new CreateAclsResponseData().setThrottleTimeMs(requestThrottleMs).setResults(aclCreationResults$1));
    }

    private static final void sendResponseCallback$2(List deleteResults$1, CompletableFuture future$2) {
        java.util.List filterResults = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)deleteResults$1.map((Function1 & Serializable)x$3 -> (AclDeleteResult)x$3.get()).map((Function1 & Serializable)x$1 -> DeleteAclsResponse.filterResult((AclDeleteResult)x$1))).asJava();
        future$2.complete(filterResults);
    }

    public static final /* synthetic */ DeleteAclsResponse $anonfun$handleDeleteAcls$7(java.util.List filterResults$1, DeleteAclsRequest deleteAclsRequest$1, int requestThrottleMs) {
        return new DeleteAclsResponse(new DeleteAclsResponseData().setThrottleTimeMs(requestThrottleMs).setFilterResults(filterResults$1), deleteAclsRequest$1.version());
    }

    public AclApis(AuthHelper authHelper, Option<Authorizer> authorizer, RequestHandlerHelper requestHelper, String name, KafkaConfig config) {
        this.authHelper = authHelper;
        this.authorizer = authorizer;
        this.requestHelper = requestHelper;
        this.config = config;
        this.logIdent_$eq(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("[AclApis-%s-%s] "), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{name, BoxesRunTime.boxToInteger((int)config.nodeId())})));
        this.alterAclsPurgatory = new DelayedFuturePurgatory("AlterAcls", config.nodeId());
    }
}

