/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.metrics;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.coordinator.group.classic.ClassicGroupState;
import org.apache.kafka.coordinator.group.consumer.ConsumerGroup;
import org.apache.kafka.coordinator.group.metrics.CoordinatorMetricsShard;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.apache.kafka.timeline.TimelineLong;

public class GroupCoordinatorMetricsShard
implements CoordinatorMetricsShard {
    private final Map<ClassicGroupState, AtomicLong> classicGroupGauges;
    private final Map<ConsumerGroup.ConsumerGroupState, TimelineGaugeCounter> consumerGroupGauges;
    private final Map<String, Sensor> globalSensors;
    private final TimelineGaugeCounter numOffsetsTimelineGaugeCounter;
    private final TimelineGaugeCounter numClassicGroupsTimelineCounter;
    private final TopicPartition topicPartition;

    public GroupCoordinatorMetricsShard(SnapshotRegistry snapshotRegistry, Map<String, Sensor> globalSensors, TopicPartition topicPartition) {
        Objects.requireNonNull(snapshotRegistry);
        this.numOffsetsTimelineGaugeCounter = new TimelineGaugeCounter(new TimelineLong(snapshotRegistry), new AtomicLong(0L));
        this.numClassicGroupsTimelineCounter = new TimelineGaugeCounter(new TimelineLong(snapshotRegistry), new AtomicLong(0L));
        this.classicGroupGauges = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)((Object)ClassicGroupState.PREPARING_REBALANCE), (Object)new AtomicLong(0L)), Utils.mkEntry((Object)((Object)ClassicGroupState.COMPLETING_REBALANCE), (Object)new AtomicLong(0L)), Utils.mkEntry((Object)((Object)ClassicGroupState.STABLE), (Object)new AtomicLong(0L)), Utils.mkEntry((Object)((Object)ClassicGroupState.DEAD), (Object)new AtomicLong(0L)), Utils.mkEntry((Object)((Object)ClassicGroupState.EMPTY), (Object)new AtomicLong(0L))});
        this.consumerGroupGauges = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)((Object)ConsumerGroup.ConsumerGroupState.EMPTY), (Object)new TimelineGaugeCounter(new TimelineLong(snapshotRegistry), new AtomicLong(0L))), Utils.mkEntry((Object)((Object)ConsumerGroup.ConsumerGroupState.ASSIGNING), (Object)new TimelineGaugeCounter(new TimelineLong(snapshotRegistry), new AtomicLong(0L))), Utils.mkEntry((Object)((Object)ConsumerGroup.ConsumerGroupState.RECONCILING), (Object)new TimelineGaugeCounter(new TimelineLong(snapshotRegistry), new AtomicLong(0L))), Utils.mkEntry((Object)((Object)ConsumerGroup.ConsumerGroupState.STABLE), (Object)new TimelineGaugeCounter(new TimelineLong(snapshotRegistry), new AtomicLong(0L))), Utils.mkEntry((Object)((Object)ConsumerGroup.ConsumerGroupState.DEAD), (Object)new TimelineGaugeCounter(new TimelineLong(snapshotRegistry), new AtomicLong(0L)))});
        this.globalSensors = Objects.requireNonNull(globalSensors);
        this.topicPartition = Objects.requireNonNull(topicPartition);
    }

    public void incrementNumClassicGroups(ClassicGroupState state) {
        AtomicLong counter = this.classicGroupGauges.get((Object)state);
        if (counter != null) {
            counter.incrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementNumOffsets() {
        TimelineLong timelineLong = this.numOffsetsTimelineGaugeCounter.timelineLong;
        synchronized (timelineLong) {
            this.numOffsetsTimelineGaugeCounter.timelineLong.increment();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementNumConsumerGroups(ConsumerGroup.ConsumerGroupState state) {
        TimelineGaugeCounter gaugeCounter = this.consumerGroupGauges.get((Object)state);
        if (gaugeCounter != null) {
            TimelineLong timelineLong = gaugeCounter.timelineLong;
            synchronized (timelineLong) {
                gaugeCounter.timelineLong.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrementNumOffsets() {
        TimelineLong timelineLong = this.numOffsetsTimelineGaugeCounter.timelineLong;
        synchronized (timelineLong) {
            this.numOffsetsTimelineGaugeCounter.timelineLong.decrement();
        }
    }

    public void decrementNumClassicGroups(ClassicGroupState state) {
        AtomicLong counter = this.classicGroupGauges.get((Object)state);
        if (counter != null) {
            counter.decrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrementNumConsumerGroups(ConsumerGroup.ConsumerGroupState state) {
        TimelineGaugeCounter gaugeCounter = this.consumerGroupGauges.get((Object)state);
        if (gaugeCounter != null) {
            TimelineLong timelineLong = gaugeCounter.timelineLong;
            synchronized (timelineLong) {
                gaugeCounter.timelineLong.decrement();
            }
        }
    }

    public long numOffsets() {
        return this.numOffsetsTimelineGaugeCounter.atomicLong.get();
    }

    public long numClassicGroups(ClassicGroupState state) {
        AtomicLong counter = this.classicGroupGauges.get((Object)state);
        if (counter != null) {
            return counter.get();
        }
        return 0L;
    }

    public long numClassicGroups() {
        return this.classicGroupGauges.values().stream().mapToLong(AtomicLong::get).sum();
    }

    public long numConsumerGroups(ConsumerGroup.ConsumerGroupState state) {
        TimelineGaugeCounter gaugeCounter = this.consumerGroupGauges.get((Object)state);
        if (gaugeCounter != null) {
            return gaugeCounter.atomicLong.get();
        }
        return 0L;
    }

    public long numConsumerGroups() {
        return this.consumerGroupGauges.values().stream().mapToLong(timelineGaugeCounter -> timelineGaugeCounter.atomicLong.get()).sum();
    }

    @Override
    public void record(String sensorName) {
        Sensor sensor = this.globalSensors.get(sensorName);
        if (sensor != null) {
            sensor.record();
        }
    }

    @Override
    public void record(String sensorName, double val) {
        Sensor sensor = this.globalSensors.get(sensorName);
        if (sensor != null) {
            sensor.record(val);
        }
    }

    @Override
    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commitUpTo(long offset) {
        long value;
        this.consumerGroupGauges.forEach((__, gaugeCounter) -> {
            long value;
            TimelineLong timelineLong = gaugeCounter.timelineLong;
            synchronized (timelineLong) {
                value = gaugeCounter.timelineLong.get(offset);
            }
            gaugeCounter.atomicLong.set(value);
        });
        TimelineLong timelineLong = this.numClassicGroupsTimelineCounter.timelineLong;
        synchronized (timelineLong) {
            value = this.numClassicGroupsTimelineCounter.timelineLong.get(offset);
            this.numClassicGroupsTimelineCounter.atomicLong.set(value);
        }
        timelineLong = this.numOffsetsTimelineGaugeCounter.timelineLong;
        synchronized (timelineLong) {
            value = this.numOffsetsTimelineGaugeCounter.timelineLong.get(offset);
            this.numOffsetsTimelineGaugeCounter.atomicLong.set(value);
        }
    }

    public void onClassicGroupStateTransition(ClassicGroupState oldState, ClassicGroupState newState) {
        if (newState != null) {
            switch (newState) {
                case PREPARING_REBALANCE: {
                    this.incrementNumClassicGroups(ClassicGroupState.PREPARING_REBALANCE);
                    break;
                }
                case COMPLETING_REBALANCE: {
                    this.incrementNumClassicGroups(ClassicGroupState.COMPLETING_REBALANCE);
                    break;
                }
                case STABLE: {
                    this.incrementNumClassicGroups(ClassicGroupState.STABLE);
                    break;
                }
                case DEAD: {
                    this.incrementNumClassicGroups(ClassicGroupState.DEAD);
                    break;
                }
                case EMPTY: {
                    this.incrementNumClassicGroups(ClassicGroupState.EMPTY);
                }
            }
        }
        if (oldState != null) {
            switch (oldState) {
                case PREPARING_REBALANCE: {
                    this.decrementNumClassicGroups(ClassicGroupState.PREPARING_REBALANCE);
                    break;
                }
                case COMPLETING_REBALANCE: {
                    this.decrementNumClassicGroups(ClassicGroupState.COMPLETING_REBALANCE);
                    break;
                }
                case STABLE: {
                    this.decrementNumClassicGroups(ClassicGroupState.STABLE);
                    break;
                }
                case DEAD: {
                    this.decrementNumClassicGroups(ClassicGroupState.DEAD);
                    break;
                }
                case EMPTY: {
                    this.decrementNumClassicGroups(ClassicGroupState.EMPTY);
                }
            }
        }
    }

    public void onConsumerGroupStateTransition(ConsumerGroup.ConsumerGroupState oldState, ConsumerGroup.ConsumerGroupState newState) {
        if (newState != null) {
            switch (newState) {
                case EMPTY: {
                    this.incrementNumConsumerGroups(ConsumerGroup.ConsumerGroupState.EMPTY);
                    break;
                }
                case ASSIGNING: {
                    this.incrementNumConsumerGroups(ConsumerGroup.ConsumerGroupState.ASSIGNING);
                    break;
                }
                case RECONCILING: {
                    this.incrementNumConsumerGroups(ConsumerGroup.ConsumerGroupState.RECONCILING);
                    break;
                }
                case STABLE: {
                    this.incrementNumConsumerGroups(ConsumerGroup.ConsumerGroupState.STABLE);
                    break;
                }
                case DEAD: {
                    this.incrementNumConsumerGroups(ConsumerGroup.ConsumerGroupState.DEAD);
                }
            }
        }
        if (oldState != null) {
            switch (oldState) {
                case EMPTY: {
                    this.decrementNumConsumerGroups(ConsumerGroup.ConsumerGroupState.EMPTY);
                    break;
                }
                case ASSIGNING: {
                    this.decrementNumConsumerGroups(ConsumerGroup.ConsumerGroupState.ASSIGNING);
                    break;
                }
                case RECONCILING: {
                    this.decrementNumConsumerGroups(ConsumerGroup.ConsumerGroupState.RECONCILING);
                    break;
                }
                case STABLE: {
                    this.decrementNumConsumerGroups(ConsumerGroup.ConsumerGroupState.STABLE);
                    break;
                }
                case DEAD: {
                    this.decrementNumConsumerGroups(ConsumerGroup.ConsumerGroupState.DEAD);
                }
            }
        }
    }

    private static class TimelineGaugeCounter {
        final TimelineLong timelineLong;
        final AtomicLong atomicLong;

        public TimelineGaugeCounter(TimelineLong timelineLong, AtomicLong atomicLong) {
            this.timelineLong = timelineLong;
            this.atomicLong = atomicLong;
        }
    }
}

