/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Query;
import org.apache.solr.analytics.AnalyticsRequestManager;
import org.apache.solr.analytics.facet.AbstractSolrQueryFacet;
import org.apache.solr.analytics.facet.StreamingFacet;
import org.apache.solr.analytics.function.ReductionCollectionManager;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.SolrIndexSearcher;

public class AnalyticsDriver {
    public static void drive(AnalyticsRequestManager manager, SolrIndexSearcher searcher, DocSet filter, SolrQueryRequest queryRequest) throws IOException {
        AnalyticsRequestManager.StreamingInfo streamingInfo = manager.getStreamingFacetInfo();
        Collection<StreamingFacet> streamingFacets = streamingInfo.streamingFacets;
        ReductionCollectionManager collectionManager = streamingInfo.streamingCollectionManager;
        Query fq = filter.makeQuery();
        Iterable<AbstractSolrQueryFacet.FacetValueQueryExecuter> facetExecuters = manager.getFacetExecuters(fq, queryRequest);
        if (collectionManager.needsCollection()) {
            List contexts = searcher.getTopReaderContext().leaves();
            for (int leafNum = 0; leafNum < contexts.size(); ++leafNum) {
                LeafReaderContext context = (LeafReaderContext)contexts.get(leafNum);
                DocIdSetIterator disi = filter.iterator(context);
                if (disi == null) continue;
                collectionManager.doSetNextReader(context);
                int doc = disi.nextDoc();
                while (doc != Integer.MAX_VALUE) {
                    collectionManager.collect(doc);
                    streamingFacets.forEach(facet -> facet.addFacetValueCollectionTargets());
                    collectionManager.apply();
                    doc = disi.nextDoc();
                }
            }
        }
        for (AbstractSolrQueryFacet.FacetValueQueryExecuter executer : facetExecuters) {
            executer.execute(searcher);
        }
    }
}

