/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.windows.amd64;

import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.ThreadProxy;
import sun.jvm.hotspot.debugger.amd64.AMD64ThreadContext;
import sun.jvm.hotspot.debugger.cdbg.CFrame;
import sun.jvm.hotspot.debugger.cdbg.basic.BasicCFrame;
import sun.jvm.hotspot.debugger.windbg.WindbgDebugger;

public class WindowsAMD64CFrame
extends BasicCFrame {
    private Address rbp;
    private Address pc;
    private static final int ADDRESS_SIZE = 8;
    private WindbgDebugger dbg;

    public WindowsAMD64CFrame(WindbgDebugger dbg, Address rbp, Address pc) {
        super(dbg.getCDebugger());
        this.rbp = rbp;
        this.pc = pc;
        this.dbg = dbg;
    }

    @Override
    public CFrame sender(ThreadProxy thread) {
        AMD64ThreadContext context = (AMD64ThreadContext)thread.getContext();
        Address rsp = context.getRegisterAsAddress(20);
        if (this.rbp == null || this.rbp.lessThan(rsp)) {
            return null;
        }
        if (this.dbg.getAddressValue(this.rbp) % 8L != 0L) {
            return null;
        }
        Address nextRBP = this.rbp.getAddressAt(0L);
        if (nextRBP == null || nextRBP.lessThanOrEqual(this.rbp)) {
            return null;
        }
        Address nextPC = this.rbp.getAddressAt(8L);
        if (nextPC == null) {
            return null;
        }
        return new WindowsAMD64CFrame(this.dbg, nextRBP, nextPC);
    }

    @Override
    public Address pc() {
        return this.pc;
    }

    @Override
    public Address localVariableBase() {
        return this.rbp;
    }
}

