/*
 * Decompiled with CFR 0.152.
 */
package json.ext;

import java.util.function.BiFunction;
import json.ext.OptionsReader;
import json.ext.RuntimeInfo;
import json.ext.StringDecoder;
import json.ext.Utils;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.ConvertBytes;
import org.jruby.util.ConvertDouble;

public class Parser
extends RubyObject {
    private final RuntimeInfo info;
    private RubyString vSource;
    private RubyString createId;
    private boolean createAdditions;
    private boolean deprecatedCreateAdditions;
    private int maxNesting;
    private boolean allowNaN;
    private boolean allowTrailingComma;
    private boolean symbolizeNames;
    private boolean freeze;
    private RubyClass objectClass;
    private RubyClass arrayClass;
    private RubyClass decimalClass;
    BiFunction<ThreadContext, ByteList, IRubyObject> decimalFactory;
    private RubyHash match_string;
    private static final int DEFAULT_MAX_NESTING = 100;
    private static final ByteList JSON_MINUS_INFINITY = new ByteList(ByteList.plain((CharSequence)"-Infinity"));
    private static final String CONST_NAN = "NaN";
    private static final String CONST_INFINITY = "Infinity";
    private static final String CONST_MINUS_INFINITY = "MinusInfinity";
    static final ObjectAllocator ALLOCATOR = Parser::new;

    public Parser(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
        this.info = RuntimeInfo.forRuntime(ruby);
    }

    @JRubyMethod(name={"new"}, meta=true)
    public static IRubyObject newInstance(IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) {
        Parser parser = (Parser)((RubyClass)iRubyObject).allocate();
        parser.callInit(iRubyObject2, block);
        return parser;
    }

    @JRubyMethod(name={"new"}, meta=true)
    public static IRubyObject newInstance(IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3, Block block) {
        Parser parser = (Parser)((RubyClass)iRubyObject).allocate();
        parser.callInit(iRubyObject2, iRubyObject3, block);
        return parser;
    }

    @JRubyMethod(meta=true)
    public static IRubyObject parse(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        Parser parser = (Parser)((RubyClass)iRubyObject).allocate();
        parser.callInit(iRubyObject2, iRubyObject3, null);
        return parser.parse(threadContext);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.initialize(threadContext, iRubyObject, null);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        Ruby ruby = threadContext.runtime;
        if (this.vSource != null) {
            throw ruby.newTypeError("already initialized instance");
        }
        OptionsReader optionsReader = new OptionsReader(threadContext, iRubyObject2);
        this.maxNesting = optionsReader.getInt("max_nesting", 100);
        this.allowNaN = optionsReader.getBool("allow_nan", false);
        this.allowTrailingComma = optionsReader.getBool("allow_trailing_comma", false);
        this.symbolizeNames = optionsReader.getBool("symbolize_names", false);
        this.freeze = optionsReader.getBool("freeze", false);
        this.createId = optionsReader.getString("create_id", this.getCreateId(threadContext));
        IRubyObject iRubyObject3 = optionsReader.get("create_additions");
        this.createAdditions = false;
        this.deprecatedCreateAdditions = false;
        if (iRubyObject3 != null) {
            if (iRubyObject3.isNil()) {
                this.createAdditions = true;
                this.deprecatedCreateAdditions = true;
            } else {
                this.createAdditions = optionsReader.getBool("create_additions", false);
            }
        }
        this.objectClass = optionsReader.getClass("object_class", ruby.getHash());
        this.arrayClass = optionsReader.getClass("array_class", ruby.getArray());
        this.decimalClass = optionsReader.getClass("decimal_class", null);
        this.match_string = optionsReader.getHash("match_string");
        this.decimalFactory = this.decimalClass == null ? this::createFloat : (this.decimalClass == ruby.getClass("BigDecimal") ? this::createBigDecimal : this::createCustomDecimal);
        if (this.symbolizeNames && this.createAdditions) {
            throw ruby.newArgumentError("options :symbolize_names and :create_additions cannot be used in conjunction");
        }
        this.vSource = iRubyObject.convertToString();
        this.vSource = this.convertEncoding(threadContext, this.vSource);
        return this;
    }

    private RubyString convertEncoding(ThreadContext threadContext, RubyString rubyString) {
        Encoding encoding = rubyString.getEncoding();
        if (encoding == ASCIIEncoding.INSTANCE) {
            rubyString = (RubyString)rubyString.dup();
            rubyString.setEncoding((Encoding)UTF8Encoding.INSTANCE);
            rubyString.clearCodeRange();
        } else if (encoding != UTF8Encoding.INSTANCE) {
            rubyString = (RubyString)rubyString.encode(threadContext, threadContext.runtime.getEncodingService().convertEncodingToRubyEncoding((Encoding)UTF8Encoding.INSTANCE));
        }
        return rubyString;
    }

    @JRubyMethod
    public IRubyObject parse(ThreadContext threadContext) {
        return new ParserSession(this, threadContext, this.info).parse(threadContext);
    }

    @JRubyMethod(name={"source"})
    public IRubyObject source_get(ThreadContext threadContext) {
        return this.checkAndGetSource(threadContext).dup();
    }

    public RubyString checkAndGetSource(ThreadContext threadContext) {
        if (this.vSource != null) {
            return this.vSource;
        }
        throw threadContext.runtime.newTypeError("uninitialized instance");
    }

    private RubyString getCreateId(ThreadContext threadContext) {
        IRubyObject iRubyObject = ((RubyModule)this.info.jsonModule.get()).callMethod(threadContext, "create_id");
        return iRubyObject.isTrue() ? iRubyObject.convertToString() : null;
    }

    private RubyFloat createFloat(ThreadContext threadContext, ByteList byteList) {
        return RubyFloat.newFloat((Ruby)threadContext.runtime, (double)new ConvertDouble.DoubleConverter().parse(byteList, true, true));
    }

    private IRubyObject createBigDecimal(ThreadContext threadContext, ByteList byteList) {
        Ruby ruby = threadContext.runtime;
        return ruby.getKernel().callMethod(threadContext, "BigDecimal", (IRubyObject)ruby.newString(byteList));
    }

    private IRubyObject createCustomDecimal(ThreadContext threadContext, ByteList byteList) {
        return this.decimalClass.newInstance(threadContext, (IRubyObject)threadContext.runtime.newString(byteList), Block.NULL_BLOCK);
    }

    static /* synthetic */ boolean access$100(Parser parser) {
        return parser.allowNaN;
    }

    static /* synthetic */ ByteList access$200() {
        return JSON_MINUS_INFINITY;
    }

    static /* synthetic */ boolean access$300(Parser parser) {
        return parser.freeze;
    }

    static /* synthetic */ boolean access$400(Parser parser) {
        return parser.createAdditions;
    }

    static /* synthetic */ RubyHash access$500(Parser parser) {
        return parser.match_string;
    }

    static /* synthetic */ boolean access$600(Parser parser) {
        return parser.deprecatedCreateAdditions;
    }

    static /* synthetic */ int access$700(Parser parser) {
        return parser.maxNesting;
    }

    static /* synthetic */ RubyClass access$800(Parser parser) {
        return parser.arrayClass;
    }

    static /* synthetic */ boolean access$900(Parser parser) {
        return parser.allowTrailingComma;
    }

    static /* synthetic */ RubyClass access$1000(Parser parser) {
        return parser.objectClass;
    }

    static /* synthetic */ boolean access$1100(Parser parser) {
        return parser.symbolizeNames;
    }

    static /* synthetic */ RubyString access$1200(Parser parser) {
        return parser.createId;
    }

    private static class ParserSession {
        private final Parser parser;
        private final RuntimeInfo info;
        private final ByteList byteList;
        private final ByteList view;
        private final byte[] data;
        private final StringDecoder decoder;
        private int currentNesting = 0;
        private static final byte[] _JSON_value_actions = ParserSession.init__JSON_value_actions_0();
        private static final byte[] _JSON_value_key_offsets = ParserSession.init__JSON_value_key_offsets_0();
        private static final char[] _JSON_value_trans_keys = ParserSession.init__JSON_value_trans_keys_0();
        private static final byte[] _JSON_value_single_lengths = ParserSession.init__JSON_value_single_lengths_0();
        private static final byte[] _JSON_value_range_lengths = ParserSession.init__JSON_value_range_lengths_0();
        private static final byte[] _JSON_value_index_offsets = ParserSession.init__JSON_value_index_offsets_0();
        private static final byte[] _JSON_value_trans_targs = ParserSession.init__JSON_value_trans_targs_0();
        private static final byte[] _JSON_value_trans_actions = ParserSession.init__JSON_value_trans_actions_0();
        private static final byte[] _JSON_value_from_state_actions = ParserSession.init__JSON_value_from_state_actions_0();
        static final int JSON_value_start = 1;
        static final int JSON_value_first_final = 21;
        static final int JSON_value_error = 0;
        static final int JSON_value_en_main = 1;
        private static final byte[] _JSON_integer_actions = ParserSession.init__JSON_integer_actions_0();
        private static final byte[] _JSON_integer_key_offsets = ParserSession.init__JSON_integer_key_offsets_0();
        private static final char[] _JSON_integer_trans_keys = ParserSession.init__JSON_integer_trans_keys_0();
        private static final byte[] _JSON_integer_single_lengths = ParserSession.init__JSON_integer_single_lengths_0();
        private static final byte[] _JSON_integer_range_lengths = ParserSession.init__JSON_integer_range_lengths_0();
        private static final byte[] _JSON_integer_index_offsets = ParserSession.init__JSON_integer_index_offsets_0();
        private static final byte[] _JSON_integer_indicies = ParserSession.init__JSON_integer_indicies_0();
        private static final byte[] _JSON_integer_trans_targs = ParserSession.init__JSON_integer_trans_targs_0();
        private static final byte[] _JSON_integer_trans_actions = ParserSession.init__JSON_integer_trans_actions_0();
        static final int JSON_integer_start = 1;
        static final int JSON_integer_first_final = 3;
        static final int JSON_integer_error = 0;
        static final int JSON_integer_en_main = 1;
        private static final byte[] _JSON_float_actions = ParserSession.init__JSON_float_actions_0();
        private static final byte[] _JSON_float_key_offsets = ParserSession.init__JSON_float_key_offsets_0();
        private static final char[] _JSON_float_trans_keys = ParserSession.init__JSON_float_trans_keys_0();
        private static final byte[] _JSON_float_single_lengths = ParserSession.init__JSON_float_single_lengths_0();
        private static final byte[] _JSON_float_range_lengths = ParserSession.init__JSON_float_range_lengths_0();
        private static final byte[] _JSON_float_index_offsets = ParserSession.init__JSON_float_index_offsets_0();
        private static final byte[] _JSON_float_indicies = ParserSession.init__JSON_float_indicies_0();
        private static final byte[] _JSON_float_trans_targs = ParserSession.init__JSON_float_trans_targs_0();
        private static final byte[] _JSON_float_trans_actions = ParserSession.init__JSON_float_trans_actions_0();
        static final int JSON_float_start = 1;
        static final int JSON_float_first_final = 8;
        static final int JSON_float_error = 0;
        static final int JSON_float_en_main = 1;
        private static final byte[] _JSON_string_actions = ParserSession.init__JSON_string_actions_0();
        private static final byte[] _JSON_string_key_offsets = ParserSession.init__JSON_string_key_offsets_0();
        private static final char[] _JSON_string_trans_keys = ParserSession.init__JSON_string_trans_keys_0();
        private static final byte[] _JSON_string_single_lengths = ParserSession.init__JSON_string_single_lengths_0();
        private static final byte[] _JSON_string_range_lengths = ParserSession.init__JSON_string_range_lengths_0();
        private static final byte[] _JSON_string_index_offsets = ParserSession.init__JSON_string_index_offsets_0();
        private static final byte[] _JSON_string_indicies = ParserSession.init__JSON_string_indicies_0();
        private static final byte[] _JSON_string_trans_targs = ParserSession.init__JSON_string_trans_targs_0();
        private static final byte[] _JSON_string_trans_actions = ParserSession.init__JSON_string_trans_actions_0();
        static final int JSON_string_start = 1;
        static final int JSON_string_first_final = 8;
        static final int JSON_string_error = 0;
        static final int JSON_string_en_main = 1;
        private static final byte[] _JSON_array_actions = ParserSession.init__JSON_array_actions_0();
        private static final byte[] _JSON_array_cond_offsets = ParserSession.init__JSON_array_cond_offsets_0();
        private static final byte[] _JSON_array_cond_lengths = ParserSession.init__JSON_array_cond_lengths_0();
        private static final int[] _JSON_array_cond_keys = ParserSession.init__JSON_array_cond_keys_0();
        private static final byte[] _JSON_array_cond_spaces = ParserSession.init__JSON_array_cond_spaces_0();
        private static final byte[] _JSON_array_key_offsets = ParserSession.init__JSON_array_key_offsets_0();
        private static final int[] _JSON_array_trans_keys = ParserSession.init__JSON_array_trans_keys_0();
        private static final byte[] _JSON_array_single_lengths = ParserSession.init__JSON_array_single_lengths_0();
        private static final byte[] _JSON_array_range_lengths = ParserSession.init__JSON_array_range_lengths_0();
        private static final short[] _JSON_array_index_offsets = ParserSession.init__JSON_array_index_offsets_0();
        private static final byte[] _JSON_array_indicies = ParserSession.init__JSON_array_indicies_0();
        private static final byte[] _JSON_array_trans_targs = ParserSession.init__JSON_array_trans_targs_0();
        private static final byte[] _JSON_array_trans_actions = ParserSession.init__JSON_array_trans_actions_0();
        static final int JSON_array_start = 1;
        static final int JSON_array_first_final = 22;
        static final int JSON_array_error = 0;
        static final int JSON_array_en_main = 1;
        private static final byte[] _JSON_object_actions = ParserSession.init__JSON_object_actions_0();
        private static final byte[] _JSON_object_cond_offsets = ParserSession.init__JSON_object_cond_offsets_0();
        private static final byte[] _JSON_object_cond_lengths = ParserSession.init__JSON_object_cond_lengths_0();
        private static final int[] _JSON_object_cond_keys = ParserSession.init__JSON_object_cond_keys_0();
        private static final byte[] _JSON_object_cond_spaces = ParserSession.init__JSON_object_cond_spaces_0();
        private static final byte[] _JSON_object_key_offsets = ParserSession.init__JSON_object_key_offsets_0();
        private static final int[] _JSON_object_trans_keys = ParserSession.init__JSON_object_trans_keys_0();
        private static final byte[] _JSON_object_single_lengths = ParserSession.init__JSON_object_single_lengths_0();
        private static final byte[] _JSON_object_range_lengths = ParserSession.init__JSON_object_range_lengths_0();
        private static final short[] _JSON_object_index_offsets = ParserSession.init__JSON_object_index_offsets_0();
        private static final byte[] _JSON_object_indicies = ParserSession.init__JSON_object_indicies_0();
        private static final byte[] _JSON_object_trans_targs = ParserSession.init__JSON_object_trans_targs_0();
        private static final byte[] _JSON_object_trans_actions = ParserSession.init__JSON_object_trans_actions_0();
        static final int JSON_object_start = 1;
        static final int JSON_object_first_final = 32;
        static final int JSON_object_error = 0;
        static final int JSON_object_en_main = 1;
        private static final byte[] _JSON_actions = ParserSession.init__JSON_actions_0();
        private static final byte[] _JSON_key_offsets = ParserSession.init__JSON_key_offsets_0();
        private static final char[] _JSON_trans_keys = ParserSession.init__JSON_trans_keys_0();
        private static final byte[] _JSON_single_lengths = ParserSession.init__JSON_single_lengths_0();
        private static final byte[] _JSON_range_lengths = ParserSession.init__JSON_range_lengths_0();
        private static final byte[] _JSON_index_offsets = ParserSession.init__JSON_index_offsets_0();
        private static final byte[] _JSON_indicies = ParserSession.init__JSON_indicies_0();
        private static final byte[] _JSON_trans_targs = ParserSession.init__JSON_trans_targs_0();
        private static final byte[] _JSON_trans_actions = ParserSession.init__JSON_trans_actions_0();
        static final int JSON_start = 1;
        static final int JSON_first_final = 10;
        static final int JSON_error = 0;
        static final int JSON_en_main = 1;
        RubyHash.VisitorWithState<IRubyObject[]> MATCH_VISITOR = new RubyHash.VisitorWithState<IRubyObject[]>(){

            public void visit(ThreadContext threadContext, RubyHash rubyHash, IRubyObject iRubyObject, IRubyObject iRubyObject2, int n, IRubyObject[] iRubyObjectArray) {
                if (iRubyObject.callMethod(threadContext, "===", iRubyObjectArray[0]).isTrue()) {
                    iRubyObjectArray[1] = iRubyObject2;
                    throw JumpException.SPECIAL_JUMP;
                }
            }
        };

        private ParserSession(Parser parser, ThreadContext threadContext, RuntimeInfo runtimeInfo) {
            this.parser = parser;
            this.info = runtimeInfo;
            this.byteList = parser.checkAndGetSource(threadContext).getByteList();
            this.data = this.byteList.unsafeBytes();
            this.view = new ByteList(this.data, false);
            this.decoder = new StringDecoder();
        }

        private RaiseException unexpectedToken(ThreadContext threadContext, int n, int n2) {
            RubyString rubyString = threadContext.runtime.newString("unexpected token at '").cat(this.data, n, Math.min(n2 - n, 32)).cat((byte)39);
            return this.newException(threadContext, "ParserError", rubyString);
        }

        private static byte[] init__JSON_value_actions_0() {
            return new byte[]{0, 1, 0, 1, 1, 1, 2, 1, 3, 1, 4, 1, 5, 1, 6, 1, 7, 1, 8, 1, 9};
        }

        private static byte[] init__JSON_value_key_offsets_0() {
            return new byte[]{0, 0, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30};
        }

        private static char[] init__JSON_value_trans_keys_0() {
            return new char[]{'\"', '-', 'I', 'N', '[', 'f', 'n', 't', '{', '0', '9', 'n', 'f', 'i', 'n', 'i', 't', 'y', 'a', 'N', 'a', 'l', 's', 'e', 'u', 'l', 'l', 'r', 'u', 'e', '\u0000'};
        }

        private static byte[] init__JSON_value_single_lengths_0() {
            return new byte[]{0, 9, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0};
        }

        private static byte[] init__JSON_value_range_lengths_0() {
            return new byte[]{0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        }

        private static byte[] init__JSON_value_index_offsets_0() {
            return new byte[]{0, 0, 11, 13, 15, 17, 19, 21, 23, 25, 27, 29, 31, 33, 35, 37, 39, 41, 43, 45, 47, 49};
        }

        private static byte[] init__JSON_value_trans_targs_0() {
            return new byte[]{21, 21, 2, 9, 21, 11, 15, 18, 21, 21, 0, 3, 0, 4, 0, 5, 0, 6, 0, 7, 0, 8, 0, 21, 0, 10, 0, 21, 0, 12, 0, 13, 0, 14, 0, 21, 0, 16, 0, 17, 0, 21, 0, 19, 0, 20, 0, 21, 0, 0, 0};
        }

        private static byte[] init__JSON_value_trans_actions_0() {
            return new byte[]{13, 11, 0, 0, 15, 0, 0, 0, 17, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 5, 0, 0, 0};
        }

        private static byte[] init__JSON_value_from_state_actions_0() {
            return new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 19};
        }

        /*
         * Unable to fully structure code
         */
        void parseValue(ThreadContext var1_1, ParserResult var2_2, int var3_3, int var4_4) {
            var6_5 = null;
            var5_6 = 1;
            var8_7 = 0;
            var12_8 = 0;
            block19: while (true) {
                switch (var12_8) {
                    case 0: {
                        if (var3_3 == var4_4) {
                            var12_8 = 4;
                            continue block19;
                        }
                        if (var5_6 == 0) {
                            var12_8 = 5;
                            continue block19;
                        }
                    }
                    case 1: {
                        var9_10 = ParserSession._JSON_value_from_state_actions[var5_6];
                        var10_11 = ParserSession._JSON_value_actions[var9_10++];
                        while (var10_11-- > 0) {
                            switch (ParserSession._JSON_value_actions[var9_10++]) {
                                case 9: {
                                    --var3_3;
                                    ++var3_3;
                                    var12_8 = 5;
                                    continue block19;
                                }
                            }
                        }
                        var11_12 = ParserSession._JSON_value_key_offsets[var5_6];
                        var8_7 = ParserSession._JSON_value_index_offsets[var5_6];
                        var7_9 = ParserSession._JSON_value_single_lengths[var5_6];
                        if (var7_9 <= 0) ** GOTO lbl43
                        var13_13 = var11_12;
                        var15_15 = var11_12 + var7_9 - 1;
                        while (var15_15 >= var13_13) {
                            var14_14 = var13_13 + (var15_15 - var13_13 >> 1);
                            if (this.data[var3_3] < ParserSession._JSON_value_trans_keys[var14_14]) {
                                var15_15 = var14_14 - 1;
                                continue;
                            }
                            if (this.data[var3_3] > ParserSession._JSON_value_trans_keys[var14_14]) {
                                var13_13 = var14_14 + 1;
                                continue;
                            }
                            var8_7 += var14_14 - var11_12;
                            ** GOTO lbl57
                        }
                        var11_12 += var7_9;
                        var8_7 += var7_9;
lbl43:
                        // 2 sources

                        if ((var7_9 = ParserSession._JSON_value_range_lengths[var5_6]) > 0) {
                            var13_13 = var11_12;
                            var15_15 = var11_12 + (var7_9 << 1) - 2;
                            while (var15_15 >= var13_13) {
                                var14_14 = var13_13 + (var15_15 - var13_13 >> 1 & -2);
                                if (this.data[var3_3] < ParserSession._JSON_value_trans_keys[var14_14]) {
                                    var15_15 = var14_14 - 2;
                                    continue;
                                }
                                if (this.data[var3_3] > ParserSession._JSON_value_trans_keys[var14_14 + 1]) {
                                    var13_13 = var14_14 + 2;
                                    continue;
                                }
                                var8_7 += var14_14 - var11_12 >> 1;
                                ** GOTO lbl57
                            }
                            var8_7 += var7_9;
                        }
lbl57:
                        // 5 sources

                        var5_6 = ParserSession._JSON_value_trans_targs[var8_7];
                        if (ParserSession._JSON_value_trans_actions[var8_7] != 0) {
                            var9_10 = ParserSession._JSON_value_trans_actions[var8_7];
                            var10_11 = ParserSession._JSON_value_actions[var9_10++];
                            while (var10_11-- > 0) {
                                switch (ParserSession._JSON_value_actions[var9_10++]) {
                                    case 0: {
                                        var6_5 = var1_1.nil;
                                        break;
                                    }
                                    case 1: {
                                        var6_5 = var1_1.fals;
                                        break;
                                    }
                                    case 2: {
                                        var6_5 = var1_1.tru;
                                        break;
                                    }
                                    case 3: {
                                        if (Parser.access$100(this.parser)) {
                                            var6_5 = this.getConstant("NaN");
                                            break;
                                        }
                                        throw this.unexpectedToken(var1_1, var3_3 - 2, var4_4);
                                    }
                                    case 4: {
                                        if (Parser.access$100(this.parser)) {
                                            var6_5 = this.getConstant("Infinity");
                                            break;
                                        }
                                        throw this.unexpectedToken(var1_1, var3_3 - 7, var4_4);
                                    }
                                    case 5: {
                                        if (var4_4 > var3_3 + 8 && this.absSubSequence(var3_3, var3_3 + 9).equals((Object)Parser.access$200())) {
                                            if (Parser.access$100(this.parser)) {
                                                var6_5 = this.getConstant("MinusInfinity");
                                                var3_3 = var3_3 + 10 - 1;
                                                --var3_3;
                                                ++var3_3;
                                                var12_8 = 5;
                                                continue block19;
                                            }
                                            throw this.unexpectedToken(var1_1, var3_3, var4_4);
                                        }
                                        this.parseFloat(var1_1, var2_2, var3_3, var4_4);
                                        if (var2_2.result != null) {
                                            var6_5 = var2_2.result;
                                            var3_3 = var2_2.p - 1;
                                        }
                                        this.parseInteger(var1_1, var2_2, var3_3, var4_4);
                                        if (var2_2.result != null) {
                                            var6_5 = var2_2.result;
                                            var3_3 = var2_2.p - 1;
                                        }
                                        --var3_3;
                                        ++var3_3;
                                        var12_8 = 5;
                                        continue block19;
                                    }
                                    case 6: {
                                        this.parseString(var1_1, var2_2, var3_3, var4_4);
                                        if (var2_2.result == null) {
                                            --var3_3;
                                            ++var3_3;
                                            var12_8 = 5;
                                            continue block19;
                                        }
                                        var6_5 = var2_2.result;
                                        var3_3 = var2_2.p - 1;
                                        break;
                                    }
                                    case 7: {
                                        ++this.currentNesting;
                                        this.parseArray(var1_1, var2_2, var3_3, var4_4);
                                        --this.currentNesting;
                                        if (var2_2.result == null) {
                                            --var3_3;
                                            ++var3_3;
                                            var12_8 = 5;
                                            continue block19;
                                        }
                                        var6_5 = var2_2.result;
                                        var3_3 = var2_2.p - 1;
                                        break;
                                    }
                                    case 8: {
                                        ++this.currentNesting;
                                        this.parseObject(var1_1, var2_2, var3_3, var4_4);
                                        --this.currentNesting;
                                        if (var2_2.result == null) {
                                            --var3_3;
                                            ++var3_3;
                                            var12_8 = 5;
                                            continue block19;
                                        }
                                        var6_5 = var2_2.result;
                                        var3_3 = var2_2.p - 1;
                                    }
                                }
                            }
                        }
                    }
                    case 2: {
                        if (var5_6 == 0) {
                            var12_8 = 5;
                            continue block19;
                        }
                        if (++var3_3 == var4_4) break block19;
                        var12_8 = 1;
                        continue block19;
                    }
                }
                break;
            }
            if (var5_6 >= 21 && var6_5 != null) {
                if (Parser.access$300(this.parser)) {
                    var6_5.setFrozen(true);
                }
                var2_2.update(var6_5, var3_3);
            } else {
                var2_2.update(null, var3_3);
            }
        }

        private static byte[] init__JSON_integer_actions_0() {
            return new byte[]{0, 1, 0};
        }

        private static byte[] init__JSON_integer_key_offsets_0() {
            return new byte[]{0, 0, 4, 7, 9, 9};
        }

        private static char[] init__JSON_integer_trans_keys_0() {
            return new char[]{'-', '0', '1', '9', '0', '1', '9', '0', '9', '0', '9', '\u0000'};
        }

        private static byte[] init__JSON_integer_single_lengths_0() {
            return new byte[]{0, 2, 1, 0, 0, 0};
        }

        private static byte[] init__JSON_integer_range_lengths_0() {
            return new byte[]{0, 1, 1, 1, 0, 1};
        }

        private static byte[] init__JSON_integer_index_offsets_0() {
            return new byte[]{0, 0, 4, 7, 9, 10};
        }

        private static byte[] init__JSON_integer_indicies_0() {
            return new byte[]{0, 2, 3, 1, 2, 3, 1, 1, 4, 1, 3, 4, 0};
        }

        private static byte[] init__JSON_integer_trans_targs_0() {
            return new byte[]{2, 0, 3, 5, 4};
        }

        private static byte[] init__JSON_integer_trans_actions_0() {
            return new byte[]{0, 0, 0, 0, 1};
        }

        void parseInteger(ThreadContext threadContext, ParserResult parserResult, int n, int n2) {
            int n3 = this.parseIntegerInternal(n, n2);
            if (n3 == -1) {
                parserResult.update(null, n);
                return;
            }
            RubyInteger rubyInteger = this.createInteger(threadContext, n, n3);
            parserResult.update((IRubyObject)rubyInteger, n3 + 1);
        }

        /*
         * Unable to fully structure code
         */
        int parseIntegerInternal(int var1_1, int var2_2) {
            var3_3 = 1;
            var4_4 = var1_1;
            var6_5 = 0;
            var10_6 = 0;
            block8: while (true) {
                switch (var10_6) {
                    case 0: {
                        if (var1_1 == var2_2) {
                            var10_6 = 4;
                            continue block8;
                        }
                        if (var3_3 == 0) {
                            var10_6 = 5;
                            continue block8;
                        }
                    }
                    case 1: {
                        var9_10 = ParserSession._JSON_integer_key_offsets[var3_3];
                        var6_5 = ParserSession._JSON_integer_index_offsets[var3_3];
                        var5_7 = ParserSession._JSON_integer_single_lengths[var3_3];
                        if (var5_7 <= 0) ** GOTO lbl33
                        var11_11 = var9_10;
                        var13_13 = var9_10 + var5_7 - 1;
                        while (var13_13 >= var11_11) {
                            var12_12 = var11_11 + (var13_13 - var11_11 >> 1);
                            if (this.data[var1_1] < ParserSession._JSON_integer_trans_keys[var12_12]) {
                                var13_13 = var12_12 - 1;
                                continue;
                            }
                            if (this.data[var1_1] > ParserSession._JSON_integer_trans_keys[var12_12]) {
                                var11_11 = var12_12 + 1;
                                continue;
                            }
                            var6_5 += var12_12 - var9_10;
                            ** GOTO lbl47
                        }
                        var9_10 += var5_7;
                        var6_5 += var5_7;
lbl33:
                        // 2 sources

                        if ((var5_7 = ParserSession._JSON_integer_range_lengths[var3_3]) > 0) {
                            var11_11 = var9_10;
                            var13_13 = var9_10 + (var5_7 << 1) - 2;
                            while (var13_13 >= var11_11) {
                                var12_12 = var11_11 + (var13_13 - var11_11 >> 1 & -2);
                                if (this.data[var1_1] < ParserSession._JSON_integer_trans_keys[var12_12]) {
                                    var13_13 = var12_12 - 2;
                                    continue;
                                }
                                if (this.data[var1_1] > ParserSession._JSON_integer_trans_keys[var12_12 + 1]) {
                                    var11_11 = var12_12 + 2;
                                    continue;
                                }
                                var6_5 += var12_12 - var9_10 >> 1;
                                ** GOTO lbl47
                            }
                            var6_5 += var5_7;
                        }
lbl47:
                        // 5 sources

                        var6_5 = ParserSession._JSON_integer_indicies[var6_5];
                        var3_3 = ParserSession._JSON_integer_trans_targs[var6_5];
                        if (ParserSession._JSON_integer_trans_actions[var6_5] != 0) {
                            var7_8 = ParserSession._JSON_integer_trans_actions[var6_5];
                            var8_9 = ParserSession._JSON_integer_actions[var7_8++];
                            while (var8_9-- > 0) {
                                switch (ParserSession._JSON_integer_actions[var7_8++]) {
                                    case 0: {
                                        --var1_1;
                                        ++var1_1;
                                        var10_6 = 5;
                                        continue block8;
                                    }
                                }
                            }
                        }
                    }
                    case 2: {
                        if (var3_3 == 0) {
                            var10_6 = 5;
                            continue block8;
                        }
                        if (++var1_1 == var2_2) break block8;
                        var10_6 = 1;
                        continue block8;
                    }
                }
                break;
            }
            if (var3_3 < 3) {
                return -1;
            }
            return var1_1;
        }

        RubyInteger createInteger(ThreadContext threadContext, int n, int n2) {
            Ruby ruby = threadContext.runtime;
            ByteList byteList = this.absSubSequence(n, n2);
            return this.bytesToInum(ruby, byteList);
        }

        RubyInteger bytesToInum(Ruby ruby, ByteList byteList) {
            return ConvertBytes.byteListToInum((Ruby)ruby, (ByteList)byteList, (int)10, (boolean)true);
        }

        private static byte[] init__JSON_float_actions_0() {
            return new byte[]{0, 1, 0};
        }

        private static byte[] init__JSON_float_key_offsets_0() {
            return new byte[]{0, 0, 4, 7, 10, 12, 16, 18, 23, 29, 29};
        }

        private static char[] init__JSON_float_trans_keys_0() {
            return new char[]{'-', '0', '1', '9', '0', '1', '9', '.', 'E', 'e', '0', '9', '+', '-', '0', '9', '0', '9', '.', 'E', 'e', '0', '9', 'E', 'e', '-', '.', '0', '9', 'E', 'e', '-', '.', '0', '9', '\u0000'};
        }

        private static byte[] init__JSON_float_single_lengths_0() {
            return new byte[]{0, 2, 1, 3, 0, 2, 0, 3, 2, 0, 2};
        }

        private static byte[] init__JSON_float_range_lengths_0() {
            return new byte[]{0, 1, 1, 0, 1, 1, 1, 1, 2, 0, 2};
        }

        private static byte[] init__JSON_float_index_offsets_0() {
            return new byte[]{0, 0, 4, 7, 11, 13, 17, 19, 24, 29, 30};
        }

        private static byte[] init__JSON_float_indicies_0() {
            return new byte[]{0, 2, 3, 1, 2, 3, 1, 4, 5, 5, 1, 6, 1, 7, 7, 8, 1, 8, 1, 4, 5, 5, 3, 1, 5, 5, 1, 6, 9, 1, 1, 1, 1, 8, 9, 0};
        }

        private static byte[] init__JSON_float_trans_targs_0() {
            return new byte[]{2, 0, 3, 7, 4, 5, 8, 6, 10, 9};
        }

        private static byte[] init__JSON_float_trans_actions_0() {
            return new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 1};
        }

        void parseFloat(ThreadContext threadContext, ParserResult parserResult, int n, int n2) {
            int n3 = this.parseFloatInternal(n, n2);
            if (n3 == -1) {
                parserResult.update(null, n);
                return;
            }
            ByteList byteList = this.absSubSequence(n, n3);
            IRubyObject iRubyObject = this.parser.decimalFactory.apply(threadContext, byteList);
            parserResult.update(iRubyObject, n3 + 1);
        }

        /*
         * Unable to fully structure code
         */
        int parseFloatInternal(int var1_1, int var2_2) {
            var3_3 = 1;
            var4_4 = var1_1;
            var6_5 = 0;
            var10_6 = 0;
            block8: while (true) {
                switch (var10_6) {
                    case 0: {
                        if (var1_1 == var2_2) {
                            var10_6 = 4;
                            continue block8;
                        }
                        if (var3_3 == 0) {
                            var10_6 = 5;
                            continue block8;
                        }
                    }
                    case 1: {
                        var9_10 = ParserSession._JSON_float_key_offsets[var3_3];
                        var6_5 = ParserSession._JSON_float_index_offsets[var3_3];
                        var5_7 = ParserSession._JSON_float_single_lengths[var3_3];
                        if (var5_7 <= 0) ** GOTO lbl33
                        var11_11 = var9_10;
                        var13_13 = var9_10 + var5_7 - 1;
                        while (var13_13 >= var11_11) {
                            var12_12 = var11_11 + (var13_13 - var11_11 >> 1);
                            if (this.data[var1_1] < ParserSession._JSON_float_trans_keys[var12_12]) {
                                var13_13 = var12_12 - 1;
                                continue;
                            }
                            if (this.data[var1_1] > ParserSession._JSON_float_trans_keys[var12_12]) {
                                var11_11 = var12_12 + 1;
                                continue;
                            }
                            var6_5 += var12_12 - var9_10;
                            ** GOTO lbl47
                        }
                        var9_10 += var5_7;
                        var6_5 += var5_7;
lbl33:
                        // 2 sources

                        if ((var5_7 = ParserSession._JSON_float_range_lengths[var3_3]) > 0) {
                            var11_11 = var9_10;
                            var13_13 = var9_10 + (var5_7 << 1) - 2;
                            while (var13_13 >= var11_11) {
                                var12_12 = var11_11 + (var13_13 - var11_11 >> 1 & -2);
                                if (this.data[var1_1] < ParserSession._JSON_float_trans_keys[var12_12]) {
                                    var13_13 = var12_12 - 2;
                                    continue;
                                }
                                if (this.data[var1_1] > ParserSession._JSON_float_trans_keys[var12_12 + 1]) {
                                    var11_11 = var12_12 + 2;
                                    continue;
                                }
                                var6_5 += var12_12 - var9_10 >> 1;
                                ** GOTO lbl47
                            }
                            var6_5 += var5_7;
                        }
lbl47:
                        // 5 sources

                        var6_5 = ParserSession._JSON_float_indicies[var6_5];
                        var3_3 = ParserSession._JSON_float_trans_targs[var6_5];
                        if (ParserSession._JSON_float_trans_actions[var6_5] != 0) {
                            var7_8 = ParserSession._JSON_float_trans_actions[var6_5];
                            var8_9 = ParserSession._JSON_float_actions[var7_8++];
                            while (var8_9-- > 0) {
                                switch (ParserSession._JSON_float_actions[var7_8++]) {
                                    case 0: {
                                        --var1_1;
                                        ++var1_1;
                                        var10_6 = 5;
                                        continue block8;
                                    }
                                }
                            }
                        }
                    }
                    case 2: {
                        if (var3_3 == 0) {
                            var10_6 = 5;
                            continue block8;
                        }
                        if (++var1_1 == var2_2) break block8;
                        var10_6 = 1;
                        continue block8;
                    }
                }
                break;
            }
            if (var3_3 < 8) {
                return -1;
            }
            return var1_1;
        }

        private static byte[] init__JSON_string_actions_0() {
            return new byte[]{0, 2, 0, 1};
        }

        private static byte[] init__JSON_string_key_offsets_0() {
            return new byte[]{0, 0, 1, 5, 8, 14, 20, 26, 32};
        }

        private static char[] init__JSON_string_trans_keys_0() {
            return new char[]{'\"', '\"', '\\', '\u0000', '\u001f', 'u', '\u0000', '\u001f', '0', '9', 'A', 'F', 'a', 'f', '0', '9', 'A', 'F', 'a', 'f', '0', '9', 'A', 'F', 'a', 'f', '0', '9', 'A', 'F', 'a', 'f', '\u0000'};
        }

        private static byte[] init__JSON_string_single_lengths_0() {
            return new byte[]{0, 1, 2, 1, 0, 0, 0, 0, 0};
        }

        private static byte[] init__JSON_string_range_lengths_0() {
            return new byte[]{0, 0, 1, 1, 3, 3, 3, 3, 0};
        }

        private static byte[] init__JSON_string_index_offsets_0() {
            return new byte[]{0, 0, 2, 6, 9, 13, 17, 21, 25};
        }

        private static byte[] init__JSON_string_indicies_0() {
            return new byte[]{0, 1, 2, 3, 1, 0, 4, 1, 0, 5, 5, 5, 1, 6, 6, 6, 1, 7, 7, 7, 1, 0, 0, 0, 1, 1, 0};
        }

        private static byte[] init__JSON_string_trans_targs_0() {
            return new byte[]{2, 0, 8, 3, 4, 5, 6, 7};
        }

        private static byte[] init__JSON_string_trans_actions_0() {
            return new byte[]{0, 0, 1, 0, 0, 0, 0, 0};
        }

        /*
         * Unable to fully structure code
         */
        void parseString(ThreadContext var1_1, ParserResult var2_2, int var3_3, int var4_4) {
            var6_5 = null;
            var5_6 = 1;
            var7_7 = var3_3;
            var9_8 = 0;
            var13_10 = 0;
            block11: while (true) {
                switch (var13_10) {
                    case 0: {
                        if (var3_3 == var4_4) {
                            var13_10 = 4;
                            continue block11;
                        }
                        if (var5_6 == 0) {
                            var13_10 = 5;
                            continue block11;
                        }
                    }
                    case 1: {
                        var12_20 = ParserSession._JSON_string_key_offsets[var5_6];
                        var9_8 = ParserSession._JSON_string_index_offsets[var5_6];
                        var8_11 = ParserSession._JSON_string_single_lengths[var5_6];
                        if (var8_11 <= 0) ** GOTO lbl34
                        var14_21 = var12_20;
                        var16_24 = var12_20 + var8_11 - 1;
                        while (var16_24 >= var14_21) {
                            var15_22 = var14_21 + (var16_24 - var14_21 >> 1);
                            if (this.data[var3_3] < ParserSession._JSON_string_trans_keys[var15_22]) {
                                var16_24 = var15_22 - 1;
                                continue;
                            }
                            if (this.data[var3_3] > ParserSession._JSON_string_trans_keys[var15_22]) {
                                var14_21 = var15_22 + 1;
                                continue;
                            }
                            var9_8 += var15_22 - var12_20;
                            ** GOTO lbl48
                        }
                        var12_20 += var8_11;
                        var9_8 += var8_11;
lbl34:
                        // 2 sources

                        if ((var8_11 = ParserSession._JSON_string_range_lengths[var5_6]) > 0) {
                            var14_21 = var12_20;
                            var16_24 = var12_20 + (var8_11 << 1) - 2;
                            while (var16_24 >= var14_21) {
                                var15_22 = var14_21 + (var16_24 - var14_21 >> 1 & -2);
                                if (this.data[var3_3] < ParserSession._JSON_string_trans_keys[var15_22]) {
                                    var16_24 = var15_22 - 2;
                                    continue;
                                }
                                if (this.data[var3_3] > ParserSession._JSON_string_trans_keys[var15_22 + 1]) {
                                    var14_21 = var15_22 + 2;
                                    continue;
                                }
                                var9_8 += var15_22 - var12_20 >> 1;
                                ** GOTO lbl48
                            }
                            var9_8 += var8_11;
                        }
lbl48:
                        // 5 sources

                        var9_8 = ParserSession._JSON_string_indicies[var9_8];
                        var5_6 = ParserSession._JSON_string_trans_targs[var9_8];
                        if (ParserSession._JSON_string_trans_actions[var9_8] != 0) {
                            var10_15 = ParserSession._JSON_string_trans_actions[var9_8];
                            var11_19 = ParserSession._JSON_string_actions[var10_15++];
                            while (var11_19-- > 0) {
                                switch (ParserSession._JSON_string_actions[var10_15++]) {
                                    case 0: {
                                        var14_21 = this.byteList.begin();
                                        var15_23 = this.decoder.decode(var1_1, this.byteList, var7_7 + 1 - var14_21, var3_3 - var14_21);
                                        var6_5 = var1_1.runtime.newString(var15_23);
                                        if (var6_5 == null) {
                                            --var3_3;
                                            ++var3_3;
                                            var13_10 = 5;
                                            continue block11;
                                        }
                                        var3_3 = var3_3 + 1 - 1;
                                        break;
                                    }
                                    case 1: {
                                        --var3_3;
                                        ++var3_3;
                                        var13_10 = 5;
                                        continue block11;
                                    }
                                }
                            }
                        }
                    }
                    case 2: {
                        if (var5_6 == 0) {
                            var13_10 = 5;
                            continue block11;
                        }
                        if (++var3_3 == var4_4) break block11;
                        var13_10 = 1;
                        continue block11;
                    }
                }
                break;
            }
            if (Parser.access$400(this.parser) && (var8_12 = Parser.access$500(this.parser)) != null) {
                var9_9 = new IRubyObject[]{var6_5, null};
                try {
                    var8_12.visitAll(var1_1, this.MATCH_VISITOR, (Object)var9_9);
                }
                catch (JumpException var10_16) {
                    // empty catch block
                }
                if (var9_9[1] != null && (var10_18 = (RubyClass)var9_9[1]).respondsTo("json_creatable?") && var10_18.callMethod(var1_1, "json_creatable?").isTrue()) {
                    if (Parser.access$600(this.parser)) {
                        var1_1.runtime.getWarnings().warn("JSON.load implicit support for `create_additions: true` is deprecated and will be removed in 3.0, use JSON.unsafe_load or explicitly pass `create_additions: true`");
                    }
                    var6_5 = var10_18.callMethod(var1_1, "json_create", var6_5);
                }
            }
            if (var5_6 >= 8 && var6_5 != null) {
                if (var6_5 instanceof RubyString) {
                    var8_14 = (RubyString)var6_5;
                    var8_14.setEncoding((Encoding)UTF8Encoding.INSTANCE);
                    var8_14.clearCodeRange();
                    if (Parser.access$300(this.parser)) {
                        var8_14.setFrozen(true);
                        var8_14 = var1_1.runtime.freezeAndDedupString(var8_14);
                    }
                    var2_2.update((IRubyObject)var8_14, var3_3 + 1);
                } else {
                    var2_2.update(var6_5, var3_3 + 1);
                }
            } else {
                var2_2.update(null, var3_3 + 1);
            }
        }

        private static byte[] init__JSON_array_actions_0() {
            return new byte[]{0, 1, 0, 1, 1};
        }

        private static byte[] init__JSON_array_cond_offsets_0() {
            return new byte[]{0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 6, 6, 6, 6, 6, 8, 11, 16, 19};
        }

        private static byte[] init__JSON_array_cond_lengths_0() {
            return new byte[]{0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 2, 3, 5, 3, 0};
        }

        private static int[] init__JSON_array_cond_keys_0() {
            return new int[]{44, 44, 9, 9, 10, 10, 13, 13, 32, 32, 47, 47, 42, 42, 47, 47, 0, 41, 42, 42, 43, 65535, 0, 41, 42, 42, 43, 46, 47, 47, 48, 65535, 0, 9, 10, 10, 11, 65535, 0};
        }

        private static byte[] init__JSON_array_cond_spaces_0() {
            return new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        }

        private static byte[] init__JSON_array_key_offsets_0() {
            return new byte[]{0, 0, 1, 18, 26, 28, 29, 31, 32, 48, 50, 51, 53, 54, 76, 78, 79, 81, 82, 86, 92, 100, 106};
        }

        private static int[] init__JSON_array_trans_keys_0() {
            return new int[]{91, 13, 32, 34, 45, 47, 73, 78, 91, 93, 102, 110, 116, 123, 9, 10, 48, 57, 13, 32, 47, 93, 65580, 131116, 9, 10, 42, 47, 42, 42, 47, 10, 13, 32, 34, 45, 47, 73, 78, 91, 102, 110, 116, 123, 9, 10, 48, 57, 42, 47, 42, 42, 47, 10, 34, 45, 73, 78, 91, 93, 102, 110, 116, 123, 65549, 65568, 65583, 131085, 131104, 131119, 48, 57, 65545, 65546, 131081, 131082, 42, 47, 42, 42, 47, 10, 65578, 65583, 131114, 131119, 65578, 131114, 65536, 131071, 131072, 196607, 65578, 65583, 131114, 131119, 65536, 131071, 131072, 196607, 65546, 131082, 65536, 131071, 131072, 196607, 0};
        }

        private static byte[] init__JSON_array_single_lengths_0() {
            return new byte[]{0, 1, 13, 6, 2, 1, 2, 1, 12, 2, 1, 2, 1, 16, 2, 1, 2, 1, 4, 2, 4, 2, 0};
        }

        private static byte[] init__JSON_array_range_lengths_0() {
            return new byte[]{0, 0, 2, 1, 0, 0, 0, 0, 2, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 2, 2, 2, 0};
        }

        private static short[] init__JSON_array_index_offsets_0() {
            return new short[]{0, 0, 2, 18, 26, 29, 31, 34, 36, 51, 54, 56, 59, 61, 81, 84, 86, 89, 91, 96, 101, 108, 113};
        }

        private static byte[] init__JSON_array_indicies_0() {
            return new byte[]{0, 1, 0, 0, 2, 2, 3, 2, 2, 2, 4, 2, 2, 2, 2, 0, 2, 1, 5, 5, 6, 4, 7, 8, 5, 1, 9, 10, 1, 11, 9, 11, 5, 9, 5, 10, 7, 7, 2, 2, 12, 2, 2, 2, 2, 2, 2, 2, 7, 2, 1, 13, 14, 1, 15, 13, 15, 7, 13, 7, 14, 2, 2, 2, 2, 2, 4, 2, 2, 2, 2, 0, 0, 3, 8, 8, 16, 2, 0, 8, 1, 17, 18, 1, 19, 17, 19, 0, 17, 0, 18, 17, 18, 20, 21, 1, 19, 22, 17, 20, 1, 19, 0, 22, 8, 17, 20, 1, 0, 8, 18, 21, 1, 1, 0};
        }

        private static byte[] init__JSON_array_trans_targs_0() {
            return new byte[]{2, 0, 3, 14, 22, 3, 4, 8, 13, 5, 7, 6, 9, 10, 12, 11, 18, 15, 17, 16, 19, 21, 20};
        }

        private static byte[] init__JSON_array_trans_actions_0() {
            return new byte[]{0, 0, 1, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        void parseArray(ThreadContext var1_1, ParserResult var2_2, int var3_3, int var4_4) {
            if (Parser.access$700(this.parser) > 0 && this.currentNesting > Parser.access$700(this.parser)) {
                throw this.newException(var1_1, "NestingError", "nesting of " + this.currentNesting + " is too deep");
            }
            var6_5 /* !! */  = Parser.access$800(this.parser) == var1_1.runtime.getArray() ? RubyArray.newArray((Ruby)var1_1.runtime) : Parser.access$800(this.parser).newInstance(var1_1, IRubyObject.NULL_ARRAY, Block.NULL_BLOCK);
            var5_6 = 1;
            var8_7 = 0;
            var13_8 = 0;
            block12: while (true) {
                switch (var13_8) {
                    case 0: {
                        if (var3_3 == var4_4) {
                            var13_8 = 4;
                            continue block12;
                        }
                        if (var5_6 == 0) {
                            var13_8 = 5;
                            continue block12;
                        }
                    }
                    case 1: {
                        var9_10 = this.data[var3_3];
                        var12_13 = ParserSession._JSON_array_cond_offsets[var5_6] * 2;
                        var7_9 = ParserSession._JSON_array_cond_lengths[var5_6];
                        if (var7_9 > 0) {
                            var14_14 = var12_13;
                            var16_16 = var12_13 + (var7_9 << 1) - 2;
                            block13: while (var16_16 >= var14_14) {
                                var15_15 = var14_14 + (var16_16 - var14_14 >> 1 & -2);
                                if (var9_10 < ParserSession._JSON_array_cond_keys[var15_15]) {
                                    var16_16 = var15_15 - 2;
                                    continue;
                                }
                                if (var9_10 > ParserSession._JSON_array_cond_keys[var15_15 + 1]) {
                                    var14_14 = var15_15 + 2;
                                    continue;
                                }
                                switch (ParserSession._JSON_array_cond_spaces[ParserSession._JSON_array_cond_offsets[var5_6] + (var15_15 - var12_13 >> 1)]) {
                                    case 0: {
                                        var9_10 = 65536 + (this.data[var3_3] - 0);
                                        if (!Parser.access$900(this.parser)) break block13;
                                        var9_10 += 65536;
                                    }
                                }
                            }
                        }
                        var12_13 = ParserSession._JSON_array_key_offsets[var5_6];
                        var8_7 = ParserSession._JSON_array_index_offsets[var5_6];
                        var7_9 = ParserSession._JSON_array_single_lengths[var5_6];
                        if (var7_9 <= 0) ** GOTO lbl54
                        var14_14 = var12_13;
                        var16_16 = var12_13 + var7_9 - 1;
                        while (var16_16 >= var14_14) {
                            var15_15 = var14_14 + (var16_16 - var14_14 >> 1);
                            if (var9_10 < ParserSession._JSON_array_trans_keys[var15_15]) {
                                var16_16 = var15_15 - 1;
                                continue;
                            }
                            if (var9_10 > ParserSession._JSON_array_trans_keys[var15_15]) {
                                var14_14 = var15_15 + 1;
                                continue;
                            }
                            var8_7 += var15_15 - var12_13;
                            ** GOTO lbl68
                        }
                        var12_13 += var7_9;
                        var8_7 += var7_9;
lbl54:
                        // 2 sources

                        if ((var7_9 = ParserSession._JSON_array_range_lengths[var5_6]) > 0) {
                            var14_14 = var12_13;
                            var16_16 = var12_13 + (var7_9 << 1) - 2;
                            while (var16_16 >= var14_14) {
                                var15_15 = var14_14 + (var16_16 - var14_14 >> 1 & -2);
                                if (var9_10 < ParserSession._JSON_array_trans_keys[var15_15]) {
                                    var16_16 = var15_15 - 2;
                                    continue;
                                }
                                if (var9_10 > ParserSession._JSON_array_trans_keys[var15_15 + 1]) {
                                    var14_14 = var15_15 + 2;
                                    continue;
                                }
                                var8_7 += var15_15 - var12_13 >> 1;
                                ** GOTO lbl68
                            }
                            var8_7 += var7_9;
                        }
lbl68:
                        // 5 sources

                        var8_7 = ParserSession._JSON_array_indicies[var8_7];
                        var5_6 = ParserSession._JSON_array_trans_targs[var8_7];
                        if (ParserSession._JSON_array_trans_actions[var8_7] != 0) {
                            var10_11 = ParserSession._JSON_array_trans_actions[var8_7];
                            var11_12 = ParserSession._JSON_array_actions[var10_11++];
                            while (var11_12-- > 0) {
                                switch (ParserSession._JSON_array_actions[var10_11++]) {
                                    case 0: {
                                        this.parseValue(var1_1, var2_2, var3_3, var4_4);
                                        if (var2_2.result == null) {
                                            --var3_3;
                                            ++var3_3;
                                            var13_8 = 5;
                                            continue block12;
                                        }
                                        if (Parser.access$800(this.parser) == var1_1.runtime.getArray()) {
                                            var6_5 /* !! */ .append(var2_2.result);
                                        } else {
                                            var6_5 /* !! */ .callMethod(var1_1, "<<", var2_2.result);
                                        }
                                        var3_3 = var2_2.p - 1;
                                        break;
                                    }
                                    case 1: {
                                        --var3_3;
                                        ++var3_3;
                                        var13_8 = 5;
                                        continue block12;
                                    }
                                }
                            }
                        }
                    }
                    case 2: {
                        if (var5_6 == 0) {
                            var13_8 = 5;
                            continue block12;
                        }
                        if (++var3_3 == var4_4) break block12;
                        var13_8 = 1;
                        continue block12;
                    }
                }
                break;
            }
            if (var5_6 < 22) {
                throw this.unexpectedToken(var1_1, var3_3, var4_4);
            }
            var2_2.update((IRubyObject)var6_5 /* !! */ , var3_3 + 1);
        }

        private static byte[] init__JSON_object_actions_0() {
            return new byte[]{0, 1, 0, 1, 1, 1, 2};
        }

        private static byte[] init__JSON_object_cond_offsets_0() {
            return new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 8, 11, 16, 19, 19, 19, 19, 19, 19, 19, 19, 19};
        }

        private static byte[] init__JSON_object_cond_lengths_0() {
            return new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 3, 5, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        }

        private static int[] init__JSON_object_cond_keys_0() {
            return new int[]{9, 9, 10, 10, 13, 13, 32, 32, 44, 44, 47, 47, 42, 42, 47, 47, 0, 41, 42, 42, 43, 65535, 0, 41, 42, 42, 43, 46, 47, 47, 48, 65535, 0, 9, 10, 10, 11, 65535, 0};
        }

        private static byte[] init__JSON_object_cond_spaces_0() {
            return new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        }

        private static byte[] init__JSON_object_key_offsets_0() {
            return new byte[]{0, 0, 1, 8, 14, 16, 17, 19, 20, 36, 49, 56, 62, 64, 65, 67, 68, 70, 71, 73, 74, 78, 84, 92, 98, 100, 101, 103, 104, 106, 107, 109, 110};
        }

        private static int[] init__JSON_object_trans_keys_0() {
            return new int[]{123, 13, 32, 34, 47, 125, 9, 10, 13, 32, 47, 58, 9, 10, 42, 47, 42, 42, 47, 10, 13, 32, 34, 45, 47, 73, 78, 91, 102, 110, 116, 123, 9, 10, 48, 57, 125, 65549, 65568, 65580, 65583, 131085, 131104, 131116, 131119, 65545, 65546, 131081, 131082, 13, 32, 44, 47, 125, 9, 10, 13, 32, 34, 47, 9, 10, 42, 47, 42, 42, 47, 10, 42, 47, 42, 42, 47, 10, 65578, 65583, 131114, 131119, 65578, 131114, 65536, 131071, 131072, 196607, 65578, 65583, 131114, 131119, 65536, 131071, 131072, 196607, 65546, 131082, 65536, 131071, 131072, 196607, 42, 47, 42, 42, 47, 10, 42, 47, 42, 42, 47, 10, 0};
        }

        private static byte[] init__JSON_object_single_lengths_0() {
            return new byte[]{0, 1, 5, 4, 2, 1, 2, 1, 12, 9, 5, 4, 2, 1, 2, 1, 2, 1, 2, 1, 4, 2, 4, 2, 2, 1, 2, 1, 2, 1, 2, 1, 0};
        }

        private static byte[] init__JSON_object_range_lengths_0() {
            return new byte[]{0, 0, 1, 1, 0, 0, 0, 0, 2, 2, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        }

        private static short[] init__JSON_object_index_offsets_0() {
            return new short[]{0, 0, 2, 9, 15, 18, 20, 23, 25, 40, 52, 59, 65, 68, 70, 73, 75, 78, 80, 83, 85, 90, 95, 102, 107, 110, 112, 115, 117, 120, 122, 125, 127};
        }

        private static byte[] init__JSON_object_indicies_0() {
            return new byte[]{0, 1, 0, 0, 2, 3, 4, 0, 1, 5, 5, 6, 7, 5, 1, 8, 9, 1, 10, 8, 10, 5, 8, 5, 9, 7, 7, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 7, 11, 1, 4, 13, 13, 14, 15, 16, 16, 0, 17, 13, 16, 1, 13, 13, 14, 15, 4, 13, 1, 14, 14, 2, 18, 14, 1, 19, 20, 1, 21, 19, 21, 14, 19, 14, 20, 22, 23, 1, 24, 22, 24, 13, 22, 13, 23, 22, 23, 25, 26, 1, 24, 27, 22, 25, 1, 24, 13, 27, 16, 22, 25, 1, 13, 16, 23, 26, 1, 28, 29, 1, 30, 28, 30, 7, 28, 7, 29, 31, 32, 1, 33, 31, 33, 0, 31, 0, 32, 1, 0};
        }

        private static byte[] init__JSON_object_trans_targs_0() {
            return new byte[]{2, 0, 3, 28, 32, 3, 4, 8, 5, 7, 6, 9, 24, 10, 11, 16, 9, 20, 12, 13, 15, 14, 17, 19, 18, 21, 23, 22, 25, 27, 26, 29, 31, 30};
        }

        private static byte[] init__JSON_object_trans_actions_0() {
            return new byte[]{0, 0, 3, 0, 5, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        void parseObject(ThreadContext var1_1, ParserResult var2_2, int var3_3, int var4_4) {
            var6_5 /* !! */  = null;
            var7_6 = true;
            if (Parser.access$700(this.parser) > 0 && this.currentNesting > Parser.access$700(this.parser)) {
                throw this.newException(var1_1, "NestingError", "nesting of " + this.currentNesting + " is too deep");
            }
            if (Parser.access$1000(this.parser) == var1_1.runtime.getHash()) {
                var8_7 = RubyHash.newHash((Ruby)var1_1.runtime);
            } else {
                var7_6 = false;
                var8_7 = Parser.access$1000(this.parser).newInstance(var1_1, IRubyObject.NULL_ARRAY, Block.NULL_BLOCK);
            }
            var5_8 = 1;
            var10_9 = 0;
            var15_11 = 0;
            block13: while (true) {
                switch (var15_11) {
                    case 0: {
                        if (var3_3 == var4_4) {
                            var15_11 = 4;
                            continue block13;
                        }
                        if (var5_8 == 0) {
                            var15_11 = 5;
                            continue block13;
                        }
                    }
                    case 1: {
                        var11_14 = this.data[var3_3];
                        var14_18 = ParserSession._JSON_object_cond_offsets[var5_8] * 2;
                        var9_12 = ParserSession._JSON_object_cond_lengths[var5_8];
                        if (var9_12 > 0) {
                            var16_19 = var14_18;
                            var18_22 = var14_18 + (var9_12 << 1) - 2;
                            block14: while (var18_22 >= var16_19) {
                                var17_21 = var16_19 + (var18_22 - var16_19 >> 1 & -2);
                                if (var11_14 < ParserSession._JSON_object_cond_keys[var17_21]) {
                                    var18_22 = var17_21 - 2;
                                    continue;
                                }
                                if (var11_14 > ParserSession._JSON_object_cond_keys[var17_21 + 1]) {
                                    var16_19 = var17_21 + 2;
                                    continue;
                                }
                                switch (ParserSession._JSON_object_cond_spaces[ParserSession._JSON_object_cond_offsets[var5_8] + (var17_21 - var14_18 >> 1)]) {
                                    case 0: {
                                        var11_14 = 65536 + (this.data[var3_3] - 0);
                                        if (!Parser.access$900(this.parser)) break block14;
                                        var11_14 += 65536;
                                    }
                                }
                            }
                        }
                        var14_18 = ParserSession._JSON_object_key_offsets[var5_8];
                        var10_9 = ParserSession._JSON_object_index_offsets[var5_8];
                        var9_12 = ParserSession._JSON_object_single_lengths[var5_8];
                        if (var9_12 <= 0) ** GOTO lbl60
                        var16_19 = var14_18;
                        var18_22 = var14_18 + var9_12 - 1;
                        while (var18_22 >= var16_19) {
                            var17_21 = var16_19 + (var18_22 - var16_19 >> 1);
                            if (var11_14 < ParserSession._JSON_object_trans_keys[var17_21]) {
                                var18_22 = var17_21 - 1;
                                continue;
                            }
                            if (var11_14 > ParserSession._JSON_object_trans_keys[var17_21]) {
                                var16_19 = var17_21 + 1;
                                continue;
                            }
                            var10_9 += var17_21 - var14_18;
                            ** GOTO lbl74
                        }
                        var14_18 += var9_12;
                        var10_9 += var9_12;
lbl60:
                        // 2 sources

                        if ((var9_12 = ParserSession._JSON_object_range_lengths[var5_8]) > 0) {
                            var16_19 = var14_18;
                            var18_22 = var14_18 + (var9_12 << 1) - 2;
                            while (var18_22 >= var16_19) {
                                var17_21 = var16_19 + (var18_22 - var16_19 >> 1 & -2);
                                if (var11_14 < ParserSession._JSON_object_trans_keys[var17_21]) {
                                    var18_22 = var17_21 - 2;
                                    continue;
                                }
                                if (var11_14 > ParserSession._JSON_object_trans_keys[var17_21 + 1]) {
                                    var16_19 = var17_21 + 2;
                                    continue;
                                }
                                var10_9 += var17_21 - var14_18 >> 1;
                                ** GOTO lbl74
                            }
                            var10_9 += var9_12;
                        }
lbl74:
                        // 5 sources

                        var10_9 = ParserSession._JSON_object_indicies[var10_9];
                        var5_8 = ParserSession._JSON_object_trans_targs[var10_9];
                        if (ParserSession._JSON_object_trans_actions[var10_9] != 0) {
                            var12_16 = ParserSession._JSON_object_trans_actions[var10_9];
                            var13_17 = ParserSession._JSON_object_actions[var12_16++];
                            while (var13_17-- > 0) {
                                switch (ParserSession._JSON_object_actions[var12_16++]) {
                                    case 0: {
                                        this.parseValue(var1_1, var2_2, var3_3, var4_4);
                                        if (var2_2.result == null) {
                                            --var3_3;
                                            ++var3_3;
                                            var15_11 = 5;
                                            continue block13;
                                        }
                                        if (Parser.access$1000(this.parser) == var1_1.runtime.getHash()) {
                                            var8_7.op_aset(var1_1, (IRubyObject)var6_5 /* !! */ , var2_2.result);
                                        } else {
                                            Helpers.invoke((ThreadContext)var1_1, (IRubyObject)var8_7, (String)"[]=", (IRubyObject)var6_5 /* !! */ , (IRubyObject)var2_2.result);
                                        }
                                        var3_3 = var2_2.p - 1;
                                        break;
                                    }
                                    case 1: {
                                        this.parseString(var1_1, var2_2, var3_3, var4_4);
                                        if (var2_2.result == null) {
                                            --var3_3;
                                            ++var3_3;
                                            var15_11 = 5;
                                            continue block13;
                                        }
                                        var16_20 = (RubyString)var2_2.result;
                                        var6_5 /* !! */  = Parser.access$1100(this.parser) != false ? var16_20.intern() : var16_20;
                                        var3_3 = var2_2.p - 1;
                                        break;
                                    }
                                    case 2: {
                                        --var3_3;
                                        ++var3_3;
                                        var15_11 = 5;
                                        continue block13;
                                    }
                                }
                            }
                        }
                    }
                    case 2: {
                        if (var5_8 == 0) {
                            var15_11 = 5;
                            continue block13;
                        }
                        if (++var3_3 == var4_4) break block13;
                        var15_11 = 1;
                        continue block13;
                    }
                }
                break;
            }
            if (var5_8 < 32) {
                var2_2.update(null, var3_3 + 1);
                return;
            }
            var9_13 = var8_7;
            if (Parser.access$400(this.parser) && !(var10_10 = var7_6 != false ? var8_7.op_aref(var1_1, (IRubyObject)Parser.access$1200(this.parser)) : var8_7.callMethod(var1_1, "[]", (IRubyObject)Parser.access$1200(this.parser))).isNil() && (var11_15 = ((RubyModule)Parser.access$1300((Parser)this.parser).jsonModule.get()).callMethod(var1_1, "deep_const_get", var10_10)).respondsTo("json_creatable?") && var11_15.callMethod(var1_1, "json_creatable?").isTrue()) {
                if (Parser.access$600(this.parser)) {
                    var1_1.runtime.getWarnings().warn("JSON.load implicit support for `create_additions: true` is deprecated and will be removed in 3.0, use JSON.unsafe_load or explicitly pass `create_additions: true`");
                }
                var9_13 = var11_15.callMethod(var1_1, "json_create", (IRubyObject)var8_7);
            }
            var2_2.update((IRubyObject)var9_13, var3_3 + 1);
        }

        private static byte[] init__JSON_actions_0() {
            return new byte[]{0, 1, 0};
        }

        private static byte[] init__JSON_key_offsets_0() {
            return new byte[]{0, 0, 16, 18, 19, 21, 22, 24, 25, 27, 28};
        }

        private static char[] init__JSON_trans_keys_0() {
            return new char[]{'\r', ' ', '\"', '-', '/', 'I', 'N', '[', 'f', 'n', 't', '{', '\t', '\n', '0', '9', '*', '/', '*', '*', '/', '\n', '*', '/', '*', '*', '/', '\n', '\r', ' ', '/', '\t', '\n', '\u0000'};
        }

        private static byte[] init__JSON_single_lengths_0() {
            return new byte[]{0, 12, 2, 1, 2, 1, 2, 1, 2, 1, 3};
        }

        private static byte[] init__JSON_range_lengths_0() {
            return new byte[]{0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1};
        }

        private static byte[] init__JSON_index_offsets_0() {
            return new byte[]{0, 0, 15, 18, 20, 23, 25, 28, 30, 33, 35};
        }

        private static byte[] init__JSON_indicies_0() {
            return new byte[]{0, 0, 2, 2, 3, 2, 2, 2, 2, 2, 2, 2, 0, 2, 1, 4, 5, 1, 6, 4, 6, 7, 4, 7, 5, 8, 9, 1, 10, 8, 10, 0, 8, 0, 9, 7, 7, 11, 7, 1, 0};
        }

        private static byte[] init__JSON_trans_targs_0() {
            return new byte[]{1, 0, 10, 6, 3, 5, 4, 10, 7, 9, 8, 2};
        }

        private static byte[] init__JSON_trans_actions_0() {
            return new byte[]{0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        }

        /*
         * Unable to fully structure code
         */
        public IRubyObject parseImplementation(ThreadContext var1_1) {
            var5_2 = null;
            var6_3 = new ParserResult();
            var2_4 = 1;
            var3_5 = this.byteList.begin();
            var4_6 = var3_5 + this.byteList.length();
            var8_7 = 0;
            var12_8 = 0;
            block8: while (true) {
                switch (var12_8) {
                    case 0: {
                        if (var3_5 == var4_6) {
                            var12_8 = 4;
                            continue block8;
                        }
                        if (var2_4 == 0) {
                            var12_8 = 5;
                            continue block8;
                        }
                    }
                    case 1: {
                        var11_12 = ParserSession._JSON_key_offsets[var2_4];
                        var8_7 = ParserSession._JSON_index_offsets[var2_4];
                        var7_9 = ParserSession._JSON_single_lengths[var2_4];
                        if (var7_9 <= 0) ** GOTO lbl36
                        var13_13 = var11_12;
                        var15_15 = var11_12 + var7_9 - 1;
                        while (var15_15 >= var13_13) {
                            var14_14 = var13_13 + (var15_15 - var13_13 >> 1);
                            if (this.data[var3_5] < ParserSession._JSON_trans_keys[var14_14]) {
                                var15_15 = var14_14 - 1;
                                continue;
                            }
                            if (this.data[var3_5] > ParserSession._JSON_trans_keys[var14_14]) {
                                var13_13 = var14_14 + 1;
                                continue;
                            }
                            var8_7 += var14_14 - var11_12;
                            ** GOTO lbl50
                        }
                        var11_12 += var7_9;
                        var8_7 += var7_9;
lbl36:
                        // 2 sources

                        if ((var7_9 = ParserSession._JSON_range_lengths[var2_4]) > 0) {
                            var13_13 = var11_12;
                            var15_15 = var11_12 + (var7_9 << 1) - 2;
                            while (var15_15 >= var13_13) {
                                var14_14 = var13_13 + (var15_15 - var13_13 >> 1 & -2);
                                if (this.data[var3_5] < ParserSession._JSON_trans_keys[var14_14]) {
                                    var15_15 = var14_14 - 2;
                                    continue;
                                }
                                if (this.data[var3_5] > ParserSession._JSON_trans_keys[var14_14 + 1]) {
                                    var13_13 = var14_14 + 2;
                                    continue;
                                }
                                var8_7 += var14_14 - var11_12 >> 1;
                                ** GOTO lbl50
                            }
                            var8_7 += var7_9;
                        }
lbl50:
                        // 5 sources

                        var8_7 = ParserSession._JSON_indicies[var8_7];
                        var2_4 = ParserSession._JSON_trans_targs[var8_7];
                        if (ParserSession._JSON_trans_actions[var8_7] != 0) {
                            var9_10 = ParserSession._JSON_trans_actions[var8_7];
                            var10_11 = ParserSession._JSON_actions[var9_10++];
                            while (var10_11-- > 0) {
                                switch (ParserSession._JSON_actions[var9_10++]) {
                                    case 0: {
                                        this.parseValue(var1_1, var6_3, var3_5, var4_6);
                                        if (var6_3.result == null) {
                                            --var3_5;
                                            ++var3_5;
                                            var12_8 = 5;
                                            continue block8;
                                        }
                                        var5_2 = var6_3.result;
                                        var3_5 = var6_3.p - 1;
                                    }
                                }
                            }
                        }
                    }
                    case 2: {
                        if (var2_4 == 0) {
                            var12_8 = 5;
                            continue block8;
                        }
                        if (++var3_5 == var4_6) break block8;
                        var12_8 = 1;
                        continue block8;
                    }
                }
                break;
            }
            if (var2_4 >= 10 && var3_5 == var4_6) {
                return var5_2;
            }
            throw this.unexpectedToken(var1_1, var3_5, var4_6);
        }

        public IRubyObject parse(ThreadContext threadContext) {
            return this.parseImplementation(threadContext);
        }

        private ByteList absSubSequence(int n, int n2) {
            this.view.setBegin(n);
            this.view.setRealSize(n2 - n);
            return this.view;
        }

        private IRubyObject getConstant(String string) {
            return ((RubyModule)((Parser)this.parser).info.jsonModule.get()).getConstant(string);
        }

        private RaiseException newException(ThreadContext threadContext, String string, String string2) {
            return Utils.newException(threadContext, string, string2);
        }

        private RaiseException newException(ThreadContext threadContext, String string, RubyString rubyString) {
            return Utils.newException(threadContext, string, rubyString);
        }
    }

    static final class ParserResult {
        IRubyObject result;
        int p;

        ParserResult() {
        }

        void update(IRubyObject iRubyObject, int n) {
            this.result = iRubyObject;
            this.p = n;
        }
    }
}

