/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.enhance.internal.bytebuddy;

import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.pool.TypePool;
import org.hibernate.bytecode.enhance.internal.bytebuddy.CorePrefixFilter;

class CoreCacheProvider
implements TypePool.CacheProvider {
    private final ConcurrentMap<String, TypePool.Resolution> storage = new ConcurrentHashMap<String, TypePool.Resolution>();
    private final CorePrefixFilter acceptedPrefixes;

    CoreCacheProvider(CorePrefixFilter acceptedPrefixes) {
        this.acceptedPrefixes = Objects.requireNonNull(acceptedPrefixes);
        this.register(Object.class.getName(), (TypePool.Resolution)new TypePool.Resolution.Simple(TypeDescription.ForLoadedType.of(Object.class)));
    }

    public TypePool.Resolution find(String name) {
        return (TypePool.Resolution)this.storage.get(name);
    }

    public TypePool.Resolution register(String name, TypePool.Resolution resolution) {
        if (this.acceptedPrefixes.isCoreClassName(name)) {
            TypePool.Resolution cached = this.storage.putIfAbsent(name, resolution);
            return cached == null ? resolution : cached;
        }
        return resolution;
    }

    public void clear() {
        this.storage.clear();
    }
}

