/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.array;

import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.dialect.function.array.DdlTypeHelper;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.query.sqm.produce.function.FunctionArgumentTypeResolver;
import org.hibernate.query.sqm.produce.function.internal.AbstractFunctionArgumentTypeResolver;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.type.BasicPluralType;

public class ArrayContainsArgumentTypeResolver
implements AbstractFunctionArgumentTypeResolver {
    public static final FunctionArgumentTypeResolver INSTANCE = new ArrayContainsArgumentTypeResolver();

    @Override
    public @Nullable MappingModelExpressible<?> resolveFunctionArgumentType(List<? extends SqmTypedNode<?>> arguments, int argumentIndex, SqmToSqlAstConverter converter) {
        if (argumentIndex == 0) {
            SqmExpression sqmExpression;
            MappingModelExpressible<?> expressible;
            SqmTypedNode<?> node = arguments.get(1);
            if (node instanceof SqmExpression && (expressible = converter.determineValueMapping(sqmExpression = (SqmExpression)node)) != null) {
                if (expressible.getSingleJdbcMapping() instanceof BasicPluralType) {
                    return expressible;
                }
                return DdlTypeHelper.resolveArrayType((DomainType)((Object)expressible.getSingleJdbcMapping()), converter.getCreationContext().getTypeConfiguration());
            }
        } else if (argumentIndex == 1) {
            SqmExpression sqmExpression;
            MappingModelExpressible<?> expressible;
            SqmTypedNode<?> nodeToResolve = arguments.get(1);
            if (nodeToResolve.getExpressible() instanceof MappingModelExpressible) {
                return null;
            }
            SqmTypedNode<?> node = arguments.get(0);
            if (node instanceof SqmExpression && (expressible = converter.determineValueMapping(sqmExpression = (SqmExpression)node)) instanceof BasicPluralType) {
                return expressible;
            }
        }
        return null;
    }
}

