/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.connections.internal;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import javax.sql.DataSource;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.connections.internal.ConnectionProviderInitiator;
import org.hibernate.engine.jdbc.connections.internal.DatabaseConnectionInfoImpl;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProviderConfigurationException;
import org.hibernate.engine.jdbc.connections.spi.DatabaseConnectionInfo;
import org.hibernate.engine.jdbc.env.spi.ExtractedDatabaseMetaData;
import org.hibernate.engine.jndi.spi.JndiService;
import org.hibernate.internal.log.ConnectionInfoLogger;
import org.hibernate.service.UnknownUnwrapTypeException;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.InjectService;
import org.hibernate.service.spi.Stoppable;

public class DatasourceConnectionProviderImpl
implements ConnectionProvider,
Configurable,
Stoppable {
    private DataSource dataSource;
    private String user;
    private String pass;
    private boolean useCredentials;
    private JndiService jndiService;
    private String dataSourceJndiName;
    private boolean available;

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @InjectService(required=false)
    public void setJndiService(JndiService jndiService) {
        this.jndiService = jndiService;
    }

    @Override
    public boolean isUnwrappableAs(Class<?> unwrapType) {
        return ConnectionProvider.class.equals(unwrapType) || DatasourceConnectionProviderImpl.class.isAssignableFrom(unwrapType) || DataSource.class.isAssignableFrom(unwrapType);
    }

    @Override
    public <T> T unwrap(Class<T> unwrapType) {
        if (ConnectionProvider.class.equals(unwrapType) || DatasourceConnectionProviderImpl.class.isAssignableFrom(unwrapType)) {
            return (T)this;
        }
        if (DataSource.class.isAssignableFrom(unwrapType)) {
            return (T)this.getDataSource();
        }
        throw new UnknownUnwrapTypeException(unwrapType);
    }

    @Override
    public void configure(Map<String, Object> configuration) {
        if (this.dataSource == null) {
            Object dataSourceSetting = configuration.get("hibernate.connection.datasource");
            if (dataSourceSetting instanceof DataSource) {
                DataSource instance;
                this.dataSource = instance = (DataSource)dataSourceSetting;
            } else if (dataSourceSetting instanceof String) {
                String jndiName;
                this.dataSourceJndiName = jndiName = (String)dataSourceSetting;
                if (this.jndiService == null) {
                    throw new ConnectionProviderConfigurationException("Unable to locate JndiService to lookup Datasource");
                }
                this.dataSource = (DataSource)this.jndiService.locate(jndiName);
            } else {
                throw new ConnectionProviderConfigurationException("DataSource to use was not injected nor specified by 'hibernate.connection.datasource'");
            }
        }
        if (this.dataSource == null) {
            throw new ConnectionProviderConfigurationException("Unable to determine appropriate DataSource to use");
        }
        if (configuration.containsKey("hibernate.connection.autocommit")) {
            ConnectionInfoLogger.INSTANCE.ignoredSetting("hibernate.connection.autocommit", DatasourceConnectionProviderImpl.class);
        }
        if (configuration.containsKey("hibernate.connection.isolation")) {
            ConnectionInfoLogger.INSTANCE.ignoredSetting("hibernate.connection.isolation", DatasourceConnectionProviderImpl.class);
        }
        this.user = (String)configuration.get("hibernate.connection.username");
        this.pass = (String)configuration.get("hibernate.connection.password");
        this.useCredentials = this.user != null || this.pass != null;
        this.available = true;
    }

    @Override
    public void stop() {
        this.available = false;
        this.dataSource = null;
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (!this.available) {
            throw new HibernateException("Provider is closed");
        }
        return this.useCredentials ? this.dataSource.getConnection(this.user, this.pass) : this.dataSource.getConnection();
    }

    @Override
    public void closeConnection(Connection connection) throws SQLException {
        connection.close();
    }

    @Override
    public boolean supportsAggressiveRelease() {
        return true;
    }

    @Override
    public DatabaseConnectionInfo getDatabaseConnectionInfo(Dialect dialect) {
        return this.getDatabaseConnectionInfo(dialect, null);
    }

    @Override
    public DatabaseConnectionInfo getDatabaseConnectionInfo(Dialect dialect, ExtractedDatabaseMetaData metaData) {
        return new DatabaseConnectionInfoImpl(DatasourceConnectionProviderImpl.class, metaData == null ? null : metaData.getUrl(), metaData == null ? null : metaData.getDriver(), dialect.getClass(), dialect.getVersion(), metaData == null || metaData.supportsSchemas(), metaData == null || metaData.supportsCatalogs(), metaData == null ? null : metaData.getConnectionSchemaName(), metaData == null ? null : metaData.getConnectionCatalogName(), null, metaData == null ? null : this.isolationString(metaData), null, null, metaData != null ? DatasourceConnectionProviderImpl.fetchSize(metaData) : null){

            @Override
            public String toInfoString() {
                return DatasourceConnectionProviderImpl.this.dataSourceJndiName != null ? "\tDataSource JNDI name [" + DatasourceConnectionProviderImpl.this.dataSourceJndiName + "]\n" + super.toInfoString() : super.toInfoString();
            }
        };
    }

    private static Integer fetchSize(ExtractedDatabaseMetaData metaData) {
        int defaultFetchSize = metaData.getDefaultFetchSize();
        return defaultFetchSize == -1 ? null : Integer.valueOf(defaultFetchSize);
    }

    private String isolationString(ExtractedDatabaseMetaData metaData) {
        return ConnectionProviderInitiator.toIsolationNiceName(metaData.getTransactionIsolation()) + " [default " + ConnectionProviderInitiator.toIsolationNiceName(metaData.getDefaultTransactionIsolation()) + "]";
    }
}

