/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.xmlns.parser;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class LoggingErrorHandler
implements ErrorHandler {
    private static final Logger defaultLogContext = Logger.getLogger(LoggingErrorHandler.class.getName());
    private Logger logContext;

    public LoggingErrorHandler() {
        this.logContext = defaultLogContext;
    }

    public LoggingErrorHandler(Logger logContext) {
        if (logContext == null) {
            throw new NullPointerException();
        }
        this.logContext = logContext;
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        if (this.logContext.isLoggable(Level.CONFIG)) {
            if (exception.getMessage().startsWith("URI was not reported to parser for entity")) {
                return;
            }
            this.logContext.severe("Parser-Warning: " + exception.getMessage());
        }
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        if (this.logContext.isLoggable(Level.WARNING)) {
            if (this.logContext.isLoggable(Level.CONFIG)) {
                this.logContext.warning("Recoverable Parser-Error:" + exception.getMessage());
            } else {
                this.logContext.warning("Recoverable Parser-Error:" + exception.getMessage());
            }
        }
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        if (this.logContext.isLoggable(Level.SEVERE)) {
            if (this.logContext.isLoggable(Level.CONFIG)) {
                this.logContext.severe("Fatal Parser-Error:" + exception.getMessage());
            } else {
                this.logContext.severe("Fatal Parser-Error:" + exception.getMessage());
            }
        }
    }
}

