/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.script.framework.provider.beanshell;

import com.sun.star.script.framework.provider.beanshell.GlyphGutter;
import com.sun.star.script.framework.provider.beanshell.ScriptSourceModel;
import com.sun.star.script.framework.provider.beanshell.ScriptSourceView;
import com.sun.star.script.framework.provider.beanshell.UnsavedChangesListener;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;

public class PlainSourceView
extends JScrollPane
implements ScriptSourceView,
DocumentListener {
    private final ScriptSourceModel model;
    private JTextArea ta;
    private GlyphGutter gg;
    private int linecount;
    private boolean isModified = false;
    private static final String undoKey = "Undo";
    private static final String redoKey = "Redo";
    private CompoundEdit compoundEdit = null;
    private static final int noLimit = -1;
    UndoManager undoManager;
    private List<UnsavedChangesListener> unsavedListener = new ArrayList<UnsavedChangesListener>();
    private static final Pattern tabPattern = Pattern.compile("^ *(\\t)");
    private static final Pattern indentationPattern = Pattern.compile("^([^\\S\\r\\n]*)(([^\\{])*\\{\\s*)*");

    public PlainSourceView(ScriptSourceModel scriptSourceModel) {
        this.model = scriptSourceModel;
        this.initUI();
        scriptSourceModel.setView(this);
    }

    @Override
    public void undo() {
        if (this.compoundEdit != null) {
            this.compoundEdit.end();
            this.undoManager.addEdit(this.compoundEdit);
            this.compoundEdit = null;
        }
        if (this.undoManager.canUndo()) {
            this.undoManager.undo();
        }
        if (!this.undoManager.canUndo()) {
            this.setModified(false);
        }
    }

    @Override
    public void redo() {
        if (this.undoManager.canRedo()) {
            this.undoManager.redo();
        }
    }

    @Override
    public void clear() {
        this.ta.setText("");
    }

    @Override
    public void update() {
        int n;
        this.ta.getDocument().removeDocumentListener(this);
        if (!this.isModified) {
            n = this.ta.getCaretPosition();
            this.ta.setText(this.model.getText());
            try {
                this.ta.setCaretPosition(n);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        try {
            n = this.ta.getLineStartOffset(this.model.getCurrentPosition());
            Rectangle rectangle = this.ta.modelToView(n);
            if (rectangle != null) {
                this.ta.scrollRectToVisible(rectangle);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.gg.repaint();
        this.ta.getDocument().addDocumentListener(this);
    }

    @Override
    public boolean isModified() {
        return this.isModified;
    }

    private void notifyListeners(boolean bl) {
        for (UnsavedChangesListener unsavedChangesListener : this.unsavedListener) {
            unsavedChangesListener.onUnsavedChanges(bl);
        }
    }

    @Override
    public void setModified(boolean bl) {
        if (bl != this.isModified) {
            this.notifyListeners(bl);
            this.isModified = bl;
        }
    }

    private void initUI() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.ta = new JTextArea();
        this.ta.setTabSize(4);
        this.ta.setRows(15);
        this.ta.setColumns(40);
        this.ta.setLineWrap(false);
        this.ta.insert(this.model.getText(), 0);
        this.ta.setFont(new Font("Monospaced", this.ta.getFont().getStyle(), this.ta.getFont().getSize()));
        this.undoManager = new UndoManager();
        this.undoManager.setLimit(-1);
        this.ta.getDocument().addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
                if (PlainSourceView.this.compoundEdit == null) {
                    PlainSourceView.this.compoundEdit = new CompoundEdit();
                }
                PlainSourceView.this.compoundEdit.addEdit(undoableEditEvent.getEdit());
            }
        });
        this.ta.getInputMap().put(KeyStroke.getKeyStroke(90, 2), undoKey);
        this.ta.getInputMap().put(KeyStroke.getKeyStroke(89, 2), redoKey);
        this.ta.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                Matcher matcher;
                int n;
                int n2;
                int n3;
                int n4;
                if (keyEvent.isShiftDown() && keyEvent.getKeyCode() == 9) {
                    try {
                        n4 = PlainSourceView.this.ta.getCaretPosition();
                        n3 = PlainSourceView.this.ta.getLineOfOffset(n4);
                        n2 = PlainSourceView.this.ta.getLineStartOffset(n3);
                        n = PlainSourceView.this.ta.getLineEndOffset(n3);
                        matcher = tabPattern.matcher(PlainSourceView.this.ta.getText(n2, n - n2));
                        if (matcher.find()) {
                            PlainSourceView.this.ta.replaceRange(null, n2 + matcher.start(1), n2 + matcher.end(1));
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
                if (keyEvent.getKeyCode() == 10) {
                    try {
                        n4 = PlainSourceView.this.ta.getCaretPosition();
                        n3 = PlainSourceView.this.ta.getLineOfOffset(n4);
                        n2 = PlainSourceView.this.ta.getLineStartOffset(n3);
                        n = PlainSourceView.this.ta.getLineEndOffset(n3);
                        matcher = indentationPattern.matcher(PlainSourceView.this.ta.getText(n2, n - n2));
                        PlainSourceView.this.ta.insert("\n", n4++);
                        if (matcher.find()) {
                            if (matcher.group(1).length() > 0) {
                                PlainSourceView.this.ta.insert(matcher.group(1), n4++);
                            }
                            if (matcher.group(3) != null) {
                                PlainSourceView.this.ta.insert("\t", n4);
                            }
                        }
                        keyEvent.consume();
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 32 || keyEvent.getKeyCode() == 10) {
                    PlainSourceView.this.compoundEdit.end();
                    PlainSourceView.this.undoManager.addEdit(PlainSourceView.this.compoundEdit);
                    PlainSourceView.this.compoundEdit = null;
                }
            }
        });
        this.ta.getActionMap().put(undoKey, new AbstractAction(undoKey){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PlainSourceView.this.undo();
            }
        });
        this.ta.getActionMap().put(redoKey, new AbstractAction(redoKey){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PlainSourceView.this.redo();
            }
        });
        this.linecount = this.ta.getLineCount();
        this.gg = new GlyphGutter(this);
        this.setViewportView(this.ta);
        this.setRowHeaderView(this.gg);
        this.ta.getDocument().addDocumentListener(this);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.doChanged();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.doChanged();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.doChanged();
    }

    private void doChanged() {
        this.setModified(true);
        if (this.linecount != this.ta.getLineCount()) {
            this.gg.update();
            this.linecount = this.ta.getLineCount();
        }
    }

    @Override
    public String getText() {
        return this.ta.getText();
    }

    public JTextArea getTextArea() {
        return this.ta;
    }

    public int getCurrentPosition() {
        return this.model.getCurrentPosition();
    }

    @Override
    public void addListener(UnsavedChangesListener unsavedChangesListener) {
        this.unsavedListener.add(unsavedChangesListener);
    }
}

