/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.wrapper;

import java.util.HashMap;
import java.util.Iterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SpaceStrippingRule;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.wrapper.SpaceStrippedNode;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.SchemaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpaceStrippedDocument
extends SpaceStrippedNode
implements DocumentInfo {
    private SpaceStrippingRule strippingRule;
    private boolean preservesSpace;
    private boolean containsAssertions;
    private HashMap<String, Object> userData;

    public SpaceStrippedDocument(DocumentInfo doc, SpaceStrippingRule strippingRule) {
        this.node = doc;
        this.parent = null;
        this.docWrapper = this;
        this.strippingRule = strippingRule;
        this.preservesSpace = SpaceStrippedDocument.findPreserveSpace(doc);
        this.containsAssertions = SpaceStrippedDocument.findAssertions(doc);
    }

    public SpaceStrippedNode wrap(NodeInfo node) {
        return SpaceStrippedDocument.makeWrapper(node, this, null);
    }

    @Override
    public boolean isTyped() {
        return ((DocumentInfo)this.node).isTyped();
    }

    public SpaceStrippingRule getStrippingRule() {
        return this.strippingRule;
    }

    @Override
    public Configuration getConfiguration() {
        return this.node.getConfiguration();
    }

    @Override
    public NamePool getNamePool() {
        return this.node.getNamePool();
    }

    @Override
    public long getDocumentNumber() {
        return this.node.getDocumentNumber();
    }

    @Override
    public NodeInfo selectID(String id, boolean getParent) {
        NodeInfo n = ((DocumentInfo)this.node).selectID(id, false);
        if (n == null) {
            return null;
        }
        return SpaceStrippedDocument.makeWrapper(n, this, null);
    }

    @Override
    public Iterator<String> getUnparsedEntityNames() {
        return ((DocumentInfo)this.node).getUnparsedEntityNames();
    }

    @Override
    public String[] getUnparsedEntity(String name) {
        return ((DocumentInfo)this.node).getUnparsedEntity(name);
    }

    private static boolean findPreserveSpace(DocumentInfo doc) {
        NodeInfo node;
        String val;
        AxisIterator iter = doc.iterateAxis((byte)4, NodeKindTest.ELEMENT);
        do {
            if ((node = iter.next()) != null) continue;
            return false;
        } while (!"preserve".equals(val = node.getAttributeValue("http://www.w3.org/XML/1998/namespace", "space")));
        return true;
    }

    private static boolean findAssertions(DocumentInfo doc) {
        if (doc.isTyped()) {
            NodeInfo node;
            SchemaType type;
            AxisIterator iter = doc.iterateAxis((byte)4, NodeKindTest.ELEMENT);
            do {
                if ((node = iter.next()) != null) continue;
                return false;
            } while (!(type = node.getSchemaType()).isComplexType() || !((ComplexType)type).hasAssertions());
            return true;
        }
        return false;
    }

    public boolean containsPreserveSpace() {
        return this.preservesSpace;
    }

    public boolean containsAssertions() {
        return this.containsAssertions;
    }

    @Override
    public void setUserData(String key, Object value) {
        if (this.userData == null) {
            this.userData = new HashMap(4);
        }
        if (value == null) {
            this.userData.remove(key);
        } else {
            this.userData.put(key, value);
        }
    }

    @Override
    public Object getUserData(String key) {
        if (this.userData == null) {
            return null;
        }
        return this.userData.get(key);
    }
}

