/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi.task;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.ops4j.pax.web.service.spi.model.OsgiContextModel;
import org.ops4j.pax.web.service.spi.model.elements.FilterModel;
import org.ops4j.pax.web.service.spi.task.BatchVisitor;
import org.ops4j.pax.web.service.spi.task.Change;
import org.ops4j.pax.web.service.spi.task.OpCode;

public class FilterModelChange
extends Change {
    private FilterModel filterModel;
    private final List<FilterModel> filterModels = new LinkedList<FilterModel>();
    private boolean disabled;
    private final List<OsgiContextModel> newModels = new LinkedList<OsgiContextModel>();

    public FilterModelChange(OpCode op, FilterModel filterModel, OsgiContextModel ... newModels) {
        this(op, filterModel, false, newModels);
    }

    public FilterModelChange(OpCode op, List<FilterModel> filterModels) {
        super(op);
        this.filterModels.addAll(filterModels);
    }

    public FilterModelChange(OpCode op, FilterModel filterModel, boolean disabled, OsgiContextModel ... newModels) {
        super(op);
        this.filterModel = filterModel;
        this.filterModels.add(filterModel);
        this.disabled = disabled;
        this.newModels.addAll(Arrays.asList(newModels));
    }

    public FilterModel getFilterModel() {
        return this.filterModel;
    }

    public List<FilterModel> getFilterModels() {
        return this.filterModels;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public boolean isDynamic() {
        return this.filterModel != null && this.filterModel.isDynamic();
    }

    public List<OsgiContextModel> getNewModels() {
        return this.newModels;
    }

    @Override
    public void uninstall(List<Change> operations) {
        if (this.getKind() == OpCode.ADD) {
            operations.add(new FilterModelChange(OpCode.DELETE, Collections.singletonList(this.filterModel)));
        }
    }

    @Override
    public void accept(BatchVisitor visitor) {
        visitor.visitFilterModelChange(this);
    }

    @Override
    public List<OsgiContextModel> getContextModels() {
        return this.newModels.size() > 0 ? this.newModels : this.filterModel.getContextModels();
    }

    public String toString() {
        FilterModel model = this.filterModel;
        if (model == null && this.filterModels.size() == 1) {
            model = this.filterModels.get(0);
        }
        if (model != null) {
            return (Object)((Object)this.getKind()) + ": " + model + (this.disabled ? " (disabled)" : " (enabled)");
        }
        return (Object)((Object)this.getKind()) + ": " + this.filterModels.size() + " filter models";
    }
}

