/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.transport.modbus;

import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.io.transport.modbus.ModbusRegisterArray;
import org.openhab.core.io.transport.modbus.ModbusWriteFunctionCode;
import org.openhab.core.io.transport.modbus.ModbusWriteRequestBlueprint;
import org.openhab.core.io.transport.modbus.ModbusWriteRequestBlueprintVisitor;

@NonNullByDefault
public class ModbusWriteRegisterRequestBlueprint
extends ModbusWriteRequestBlueprint {
    private final int slaveId;
    private final int reference;
    private final ModbusRegisterArray registers;
    private final boolean writeMultiple;
    private final int maxTries;

    public ModbusWriteRegisterRequestBlueprint(int slaveId, int reference, ModbusRegisterArray registers, boolean writeMultiple, int maxTries) throws IllegalArgumentException {
        this.slaveId = slaveId;
        this.reference = reference;
        this.registers = registers;
        this.writeMultiple = writeMultiple;
        this.maxTries = maxTries;
        if (!writeMultiple && registers.size() > 1) {
            throw new IllegalArgumentException("With multiple registers, writeMultiple must be true");
        }
        if (registers.size() == 0) {
            throw new IllegalArgumentException("Must have at least one register");
        }
        if (maxTries <= 0) {
            throw new IllegalArgumentException("maxTries should be positive");
        }
    }

    @Override
    public int getReference() {
        return this.reference;
    }

    @Override
    public int getUnitID() {
        return this.slaveId;
    }

    @Override
    public ModbusWriteFunctionCode getFunctionCode() {
        return this.writeMultiple ? ModbusWriteFunctionCode.WRITE_MULTIPLE_REGISTERS : ModbusWriteFunctionCode.WRITE_SINGLE_REGISTER;
    }

    public ModbusRegisterArray getRegisters() {
        return this.registers;
    }

    @Override
    public int getMaxTries() {
        return this.maxTries;
    }

    public String toString() {
        return "ModbusWriteRegisterRequestBlueprint [slaveId=" + this.slaveId + ", reference=" + this.reference + ", registers=" + String.valueOf(this.registers) + ", maxTries=" + this.maxTries + ", getFunctionCode()=" + String.valueOf((Object)this.getFunctionCode()) + "]";
    }

    @Override
    public void accept(ModbusWriteRequestBlueprintVisitor visitor) {
        visitor.visit(this);
    }
}

