/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.helper;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileStore;
import java.nio.file.FileSystems;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.model.Pair;

public final class Log {
    private static final String STACK_PACKAGE = "org.traccar";
    private static final int STACK_LIMIT = 4;

    private Log() {
    }

    public static void setupDefaultLogger() {
        String path = null;
        URL url = ClassLoader.getSystemClassLoader().getResource(".");
        if (url != null) {
            File jarPath = new File(url.getPath());
            File logsPath = new File(jarPath, "logs");
            if (!logsPath.exists() || !logsPath.isDirectory()) {
                logsPath = jarPath;
            }
            path = new File(logsPath, "tracker-server.log").getPath();
        }
        Log.setupLogger(path == null, path, Level.WARNING.getName(), false, true, "DAY");
    }

    public static void setupLogger(Config config) {
        Log.setupLogger(config.getBoolean(Keys.LOGGER_CONSOLE), config.getString(Keys.LOGGER_FILE), config.getString(Keys.LOGGER_LEVEL), config.getBoolean(Keys.LOGGER_FULL_STACK_TRACES), config.getBoolean(Keys.LOGGER_ROTATE), config.getString(Keys.LOGGER_ROTATE_INTERVAL));
    }

    private static void setupLogger(boolean console, String file, String levelString, boolean fullStackTraces, boolean rotate, String rotateInterval) {
        Logger rootLogger = Logger.getLogger("");
        for (Handler handler : rootLogger.getHandlers()) {
            rootLogger.removeHandler(handler);
        }
        Handler handler = console ? new ConsoleHandler() : new RollingFileHandler(file, rotate, rotateInterval);
        handler.setFormatter(new LogFormatter(fullStackTraces));
        Level level = Level.parse(levelString.toUpperCase());
        rootLogger.setLevel(level);
        handler.setLevel(level);
        handler.setFilter(record -> record != null && !record.getLoggerName().startsWith("sun"));
        rootLogger.addHandler(handler);
    }

    public static String exceptionStack(Throwable exception) {
        for (Throwable cause = exception.getCause(); cause != null && exception != cause; cause = cause.getCause()) {
            exception = cause;
        }
        StringBuilder s = new StringBuilder();
        String exceptionMsg = exception.getMessage();
        if (exceptionMsg != null) {
            s.append(exceptionMsg);
            s.append(" - ");
        }
        s.append(exception.getClass().getSimpleName());
        StackTraceElement[] stack = exception.getStackTrace();
        if (stack.length > 0) {
            int count = 4;
            boolean first = true;
            boolean skip = false;
            String file = "";
            s.append(" (");
            for (StackTraceElement element : stack) {
                if (count > 0 && element.getClassName().startsWith(STACK_PACKAGE)) {
                    if (!first) {
                        s.append(" < ");
                    } else {
                        first = false;
                    }
                    if (skip) {
                        s.append("... < ");
                        skip = false;
                    }
                    if (file.equals(element.getFileName())) {
                        s.append("*");
                    } else {
                        file = element.getFileName();
                        s.append(file, 0, file.length() - 5);
                        --count;
                    }
                    s.append(":").append(element.getLineNumber());
                    continue;
                }
                skip = true;
            }
            if (skip) {
                if (!first) {
                    s.append(" < ");
                }
                s.append("...");
            }
            s.append(")");
        }
        return s.toString();
    }

    public static long[] getStorageSpace() {
        ArrayList<Pair<Long, Long>> stores = new ArrayList<Pair<Long, Long>>();
        for (FileStore store : FileSystems.getDefault().getFileStores()) {
            try {
                long usableSpace = store.getUsableSpace();
                long totalSpace = store.getTotalSpace();
                if (totalSpace <= 1000000000L) continue;
                stores.add(new Pair<Long, Long>(usableSpace, totalSpace));
            }
            catch (IOException iOException) {}
        }
        return stores.stream().sorted(Comparator.comparingDouble(p -> (double)((Long)p.first()).longValue() / (double)((Long)p.second()).longValue())).flatMap(p -> Stream.of((Long)p.first(), (Long)p.second())).mapToLong(Long::longValue).toArray();
    }

    private static class RollingFileHandler
    extends Handler {
        private final String name;
        private String suffix;
        private Writer writer;
        private final boolean rotate;
        private final String template;

        RollingFileHandler(String name, boolean rotate, String rotateInterval) {
            this.name = name;
            this.rotate = rotate;
            this.template = rotateInterval.equalsIgnoreCase("HOUR") ? "yyyyMMddHH" : "yyyyMMdd";
        }

        @Override
        public synchronized void publish(LogRecord record) {
            if (this.isLoggable(record)) {
                try {
                    String suffix = "";
                    if (this.rotate) {
                        suffix = new SimpleDateFormat(this.template).format(new Date(record.getMillis()));
                        if (this.writer != null && !suffix.equals(this.suffix)) {
                            this.writer.close();
                            this.writer = null;
                            if (!new File(this.name).renameTo(new File(this.name + "." + this.suffix))) {
                                throw new RuntimeException("Log file renaming failed");
                            }
                        }
                    }
                    if (this.writer == null) {
                        this.suffix = suffix;
                        this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.name, true), StandardCharsets.UTF_8));
                    }
                    this.writer.write(this.getFormatter().format(record));
                    this.writer.flush();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        @Override
        public synchronized void flush() {
            if (this.writer != null) {
                try {
                    this.writer.flush();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        @Override
        public synchronized void close() throws SecurityException {
            if (this.writer != null) {
                try {
                    this.writer.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static class LogFormatter
    extends Formatter {
        private final boolean fullStackTraces;

        LogFormatter(boolean fullStackTraces) {
            this.fullStackTraces = fullStackTraces;
        }

        private static String formatLevel(Level level) {
            return switch (level.getName()) {
                case "FINEST" -> "TRACE";
                case "FINER", "FINE", "CONFIG" -> "DEBUG";
                case "INFO" -> "INFO";
                case "WARNING" -> "WARN";
                default -> "ERROR";
            };
        }

        @Override
        public String format(LogRecord record) {
            StringBuilder message = new StringBuilder();
            if (record.getMessage() != null) {
                message.append(record.getMessage());
            }
            if (record.getThrown() != null) {
                if (!message.isEmpty()) {
                    message.append(" - ");
                }
                if (this.fullStackTraces) {
                    StringWriter stringWriter = new StringWriter();
                    PrintWriter printWriter = new PrintWriter(stringWriter);
                    record.getThrown().printStackTrace(printWriter);
                    message.append(System.lineSeparator()).append(stringWriter);
                } else {
                    message.append(Log.exceptionStack(record.getThrown()));
                }
            }
            return String.format("%1$tF %1$tT %2$5s: %3$s%n", new Date(record.getMillis()), LogFormatter.formatLevel(record.getLevel()), message);
        }
    }
}

