/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import org.traccar.BaseFrameDecoder;

public class CellocatorFrameDecoder
extends BaseFrameDecoder {
    private static final int MESSAGE_MINIMUM_LENGTH = 15;

    @Override
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ByteBuf buf) throws Exception {
        if (buf.readableBytes() < 15) {
            return null;
        }
        int length = 0;
        short type = buf.getUnsignedByte(4);
        switch (type) {
            case 0: {
                length = 70;
                break;
            }
            case 3: {
                length = 31;
                break;
            }
            case 7: {
                length = 70;
                break;
            }
            case 8: {
                if (buf.readableBytes() < 19) break;
                length = 19 + buf.getUnsignedShortLE(buf.readerIndex() + 16);
                break;
            }
            case 9: {
                length = 15 + buf.getUnsignedByte(buf.readerIndex() + 13);
                break;
            }
            case 11: {
                length = 16 + buf.getUnsignedShortLE(buf.readerIndex() + 13);
            }
        }
        if (length > 0 && buf.readableBytes() >= length) {
            return buf.readRetainedSlice(length);
        }
        return null;
    }
}

