/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection.datum;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import org.openstreetmap.josm.data.projection.datum.NTV2GridShift;
import org.openstreetmap.josm.data.projection.datum.NTV2Util;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class NTV2SubGrid
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String subGridName;
    private final String parentSubGridName;
    private final String created;
    private final String updated;
    private final double minLat;
    private final double maxLat;
    private final double minLon;
    private final double maxLon;
    private final double latInterval;
    private final double lonInterval;
    private final int nodeCount;
    private final int lonColumnCount;
    private final int latRowCount;
    private final float[] latShift;
    private final float[] lonShift;
    private float[] latAccuracy;
    private float[] lonAccuracy;
    private NTV2SubGrid[] subGrid;

    public NTV2SubGrid(InputStream in, boolean bigEndian, boolean loadAccuracy) throws IOException {
        byte[] b8 = new byte[8];
        byte[] b4 = new byte[4];
        byte[] b1 = new byte[1];
        NTV2SubGrid.readBytes(in, b8);
        NTV2SubGrid.readBytes(in, b8);
        this.subGridName = new String(b8, StandardCharsets.UTF_8).trim();
        NTV2SubGrid.readBytes(in, b8);
        NTV2SubGrid.readBytes(in, b8);
        this.parentSubGridName = new String(b8, StandardCharsets.UTF_8).trim();
        NTV2SubGrid.readBytes(in, b8);
        NTV2SubGrid.readBytes(in, b8);
        this.created = new String(b8, StandardCharsets.UTF_8);
        NTV2SubGrid.readBytes(in, b8);
        NTV2SubGrid.readBytes(in, b8);
        this.updated = new String(b8, StandardCharsets.UTF_8);
        NTV2SubGrid.readBytes(in, b8);
        NTV2SubGrid.readBytes(in, b8);
        this.minLat = NTV2Util.getDouble(b8, bigEndian);
        NTV2SubGrid.readBytes(in, b8);
        NTV2SubGrid.readBytes(in, b8);
        this.maxLat = NTV2Util.getDouble(b8, bigEndian);
        NTV2SubGrid.readBytes(in, b8);
        NTV2SubGrid.readBytes(in, b8);
        this.minLon = NTV2Util.getDouble(b8, bigEndian);
        NTV2SubGrid.readBytes(in, b8);
        NTV2SubGrid.readBytes(in, b8);
        this.maxLon = NTV2Util.getDouble(b8, bigEndian);
        NTV2SubGrid.readBytes(in, b8);
        NTV2SubGrid.readBytes(in, b8);
        this.latInterval = NTV2Util.getDouble(b8, bigEndian);
        NTV2SubGrid.readBytes(in, b8);
        NTV2SubGrid.readBytes(in, b8);
        this.lonInterval = NTV2Util.getDouble(b8, bigEndian);
        this.lonColumnCount = 1 + (int)((this.maxLon - this.minLon) / this.lonInterval);
        this.latRowCount = 1 + (int)((this.maxLat - this.minLat) / this.latInterval);
        NTV2SubGrid.readBytes(in, b8);
        NTV2SubGrid.readBytes(in, b8);
        this.nodeCount = NTV2Util.getInt(b8, bigEndian);
        if (this.nodeCount != this.lonColumnCount * this.latRowCount) {
            throw new IllegalStateException("SubGrid " + this.subGridName + " has inconsistent grid dimesions");
        }
        this.latShift = new float[this.nodeCount];
        this.lonShift = new float[this.nodeCount];
        if (loadAccuracy) {
            this.latAccuracy = new float[this.nodeCount];
            this.lonAccuracy = new float[this.nodeCount];
        }
        for (int i = 0; i < this.nodeCount; ++i) {
            NTV2SubGrid.readBytes(in, b1);
            b4[0] = b1[0];
            NTV2SubGrid.readBytes(in, b1);
            b4[1] = b1[0];
            NTV2SubGrid.readBytes(in, b1);
            b4[2] = b1[0];
            NTV2SubGrid.readBytes(in, b1);
            b4[3] = b1[0];
            this.latShift[i] = NTV2Util.getFloat(b4, bigEndian);
            NTV2SubGrid.readBytes(in, b1);
            b4[0] = b1[0];
            NTV2SubGrid.readBytes(in, b1);
            b4[1] = b1[0];
            NTV2SubGrid.readBytes(in, b1);
            b4[2] = b1[0];
            NTV2SubGrid.readBytes(in, b1);
            b4[3] = b1[0];
            this.lonShift[i] = NTV2Util.getFloat(b4, bigEndian);
            NTV2SubGrid.readBytes(in, b1);
            b4[0] = b1[0];
            NTV2SubGrid.readBytes(in, b1);
            b4[1] = b1[0];
            NTV2SubGrid.readBytes(in, b1);
            b4[2] = b1[0];
            NTV2SubGrid.readBytes(in, b1);
            b4[3] = b1[0];
            if (loadAccuracy) {
                this.latAccuracy[i] = NTV2Util.getFloat(b4, bigEndian);
            }
            NTV2SubGrid.readBytes(in, b1);
            b4[0] = b1[0];
            NTV2SubGrid.readBytes(in, b1);
            b4[1] = b1[0];
            NTV2SubGrid.readBytes(in, b1);
            b4[2] = b1[0];
            NTV2SubGrid.readBytes(in, b1);
            b4[3] = b1[0];
            if (!loadAccuracy) continue;
            this.lonAccuracy[i] = NTV2Util.getFloat(b4, bigEndian);
        }
    }

    private static void readBytes(InputStream in, byte[] b) throws IOException {
        if (in.read(b) < b.length) {
            Logging.error("Failed to read expected amount of bytes (" + b.length + ") from stream");
        }
    }

    public NTV2SubGrid getSubGridForCoord(double lon, double lat) {
        return !this.isCoordWithin(lon, lat) ? null : (this.subGrid == null ? this : Arrays.stream(this.subGrid).filter(aSubGrid -> aSubGrid.isCoordWithin(lon, lat)).map(aSubGrid -> aSubGrid.getSubGridForCoord(lon, lat)).filter(Objects::nonNull).findFirst().orElse(this));
    }

    private boolean isCoordWithin(double lon, double lat) {
        return lon >= this.minLon && lon < this.maxLon && lat >= this.minLat && lat < this.maxLat;
    }

    private static double interpolate(float a, float b, float c, float d, double x, double y) {
        return (double)a + ((double)b - (double)a) * x + ((double)c - (double)a) * y + ((double)a + (double)d - (double)b - (double)c) * x * y;
    }

    public void interpolateGridShift(NTV2GridShift gs) {
        int lonIndex = (int)((gs.getLonPositiveWestSeconds() - this.minLon) / this.lonInterval);
        int latIndex = (int)((gs.getLatSeconds() - this.minLat) / this.latInterval);
        double x = (gs.getLonPositiveWestSeconds() - (this.minLon + this.lonInterval * (double)lonIndex)) / this.lonInterval;
        double y = (gs.getLatSeconds() - (this.minLat + this.latInterval * (double)latIndex)) / this.latInterval;
        int indexA = lonIndex + latIndex * this.lonColumnCount;
        int indexB = indexA + 1;
        int indexC = indexA + this.lonColumnCount;
        int indexD = indexC + 1;
        gs.setLonShiftPositiveWestSeconds(NTV2SubGrid.interpolate(this.lonShift[indexA], this.lonShift[indexB], this.lonShift[indexC], this.lonShift[indexD], x, y));
        gs.setLatShiftSeconds(NTV2SubGrid.interpolate(this.latShift[indexA], this.latShift[indexB], this.latShift[indexC], this.latShift[indexD], x, y));
        if (this.lonAccuracy == null) {
            gs.setLonAccuracyAvailable(false);
        } else {
            gs.setLonAccuracyAvailable(true);
            gs.setLonAccuracySeconds(NTV2SubGrid.interpolate(this.lonAccuracy[indexA], this.lonAccuracy[indexB], this.lonAccuracy[indexC], this.lonAccuracy[indexD], x, y));
        }
        if (this.latAccuracy == null) {
            gs.setLatAccuracyAvailable(false);
        } else {
            gs.setLatAccuracyAvailable(true);
            gs.setLatAccuracySeconds(NTV2SubGrid.interpolate(this.latAccuracy[indexA], this.latAccuracy[indexB], this.latAccuracy[indexC], this.latAccuracy[indexD], x, y));
        }
    }

    public String getParentSubGridName() {
        return this.parentSubGridName;
    }

    public String getSubGridName() {
        return this.subGridName;
    }

    public int getNodeCount() {
        return this.nodeCount;
    }

    public int getSubGridCount() {
        return this.subGrid == null ? 0 : this.subGrid.length;
    }

    public void setSubGridArray(NTV2SubGrid ... subGrid) {
        this.subGrid = Utils.copyArray(subGrid);
    }

    public String toString() {
        return this.subGridName;
    }

    public String getDetails() {
        return "Sub Grid : " + this.subGridName + "\nParent   : " + this.parentSubGridName + "\nCreated  : " + this.created + "\nUpdated  : " + this.updated + "\nMin Lat  : " + this.minLat + "\nMax Lat  : " + this.maxLat + "\nMin Lon  : " + this.minLon + "\nMax Lon  : " + this.maxLon + "\nLat Intvl: " + this.latInterval + "\nLon Intvl: " + this.lonInterval + "\nNode Cnt : " + this.nodeCount;
    }

    public double getMaxLat() {
        return this.maxLat;
    }

    public double getMaxLon() {
        return this.maxLon;
    }

    public double getMinLat() {
        return this.minLat;
    }

    public double getMinLon() {
        return this.minLon;
    }
}

