/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.services.health;

import io.smallrye.health.api.AsyncHealthCheck;
import io.smallrye.mutiny.Uni;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.connections.infinispan.InfinispanConnectionProviderFactory;
import org.keycloak.infinispan.util.InfinispanUtils;
import org.keycloak.quarkus.runtime.integration.QuarkusKeycloakSessionFactory;
import org.keycloak.quarkus.runtime.services.health.KeycloakReadyHealthCheck;

public class KeycloakClusterReadyHealthCheck
implements AsyncHealthCheck {
    private final AtomicReference<Instant> failingSince = new AtomicReference();

    public Uni<HealthCheckResponse> call() {
        HealthCheckResponseBuilder builder = HealthCheckResponse.named((String)"Keycloak cluster health check").up();
        if (InfinispanUtils.isRemoteInfinispan()) {
            return Uni.createFrom().item((Object)builder.build());
        }
        QuarkusKeycloakSessionFactory sessionFactory = QuarkusKeycloakSessionFactory.getInstance();
        InfinispanConnectionProviderFactory factory = (InfinispanConnectionProviderFactory)sessionFactory.getProviderFactory(InfinispanConnectionProvider.class);
        if (factory.isClusterHealthy()) {
            this.failingSince.set(null);
        } else {
            builder.down();
            Instant failingTime = this.failingSince.updateAndGet(KeycloakReadyHealthCheck::createInstanceIfNeeded);
            builder.withData("Failing since", KeycloakReadyHealthCheck.DATE_FORMATTER.format(failingTime));
        }
        return Uni.createFrom().item((Object)builder.build());
    }
}

