/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport.jgroups;

import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.infinispan.remoting.transport.jgroups.JGroupsChannelConfigurator;
import org.jgroups.ChannelListener;
import org.jgroups.JChannel;
import org.jgroups.stack.Protocol;
import org.jgroups.util.SocketFactory;

public abstract class AbstractJGroupsChannelConfigurator
implements JGroupsChannelConfigurator {
    private SocketFactory socketFactory;
    protected DataSource dataSource;
    protected List<ChannelListener> channelListeners = new ArrayList<ChannelListener>(2);

    @Override
    public void setSocketFactory(SocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    @Override
    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    protected JChannel amendChannel(JChannel channel) {
        if (this.socketFactory != null) {
            Protocol protocol = channel.getProtocolStack().getTopProtocol();
            protocol.setSocketFactory(this.socketFactory);
        }
        for (ChannelListener listener : this.channelListeners) {
            channel.addChannelListener(listener);
        }
        return channel;
    }

    @Override
    public void addChannelListener(ChannelListener channelListener) {
        this.channelListeners.add(channelListener);
    }
}

