/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.provider;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.internal.provider.AutomationResourceBundlesEventQueue;
import org.openhab.core.automation.internal.provider.Vendor;
import org.openhab.core.automation.parser.Parser;
import org.openhab.core.automation.parser.ParsingException;
import org.openhab.core.common.registry.Provider;
import org.openhab.core.common.registry.ProviderChangeListener;
import org.openhab.core.config.core.ConfigDescriptionParameter;
import org.openhab.core.config.core.i18n.ConfigI18nLocalizationService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public abstract class AbstractResourceBundleProvider<@NonNull E> {
    protected static final String ROOT_DIRECTORY = "OH-INF/automation";
    protected @Nullable ConfigI18nLocalizationService configI18nService;
    protected final Logger logger = LoggerFactory.getLogger(AbstractResourceBundleProvider.class);
    @NonNullByDefault(value={})
    protected BundleContext bundleContext;
    protected final String path;
    protected final Map<String, Parser<E>> parsers = new ConcurrentHashMap<String, Parser<E>>();
    protected final Map<String, E> providedObjectsHolder = new ConcurrentHashMap<String, E>();
    protected final Map<Vendor, List<String>> providerPortfolio = new ConcurrentHashMap<Vendor, List<String>>();
    protected final Map<Bundle, List<URL>> waitingProviders = new ConcurrentHashMap<Bundle, List<URL>>();
    protected final AutomationResourceBundlesEventQueue queue = new AutomationResourceBundlesEventQueue(this);
    protected final List<ProviderChangeListener<E>> listeners = new LinkedList<ProviderChangeListener<E>>();

    protected AbstractResourceBundleProvider(String path) {
        this.path = path;
    }

    protected void activate(@Nullable BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deactivate() {
        this.bundleContext = null;
        this.queue.stop();
        Object object = this.parsers;
        synchronized (object) {
            this.parsers.clear();
        }
        object = this.providedObjectsHolder;
        synchronized (object) {
            this.providedObjectsHolder.clear();
        }
        object = this.providerPortfolio;
        synchronized (object) {
            this.providerPortfolio.clear();
        }
        object = this.waitingProviders;
        synchronized (object) {
            this.waitingProviders.clear();
        }
        object = this.listeners;
        synchronized (object) {
            this.listeners.clear();
        }
    }

    protected AutomationResourceBundlesEventQueue getQueue() {
        return this.queue;
    }

    protected void addParser(Parser<E> parser, Map<String, String> properties) {
        String parserType = properties.get("format");
        parserType = parserType == null ? "json" : parserType;
        this.parsers.put(parserType, parser);
        for (Bundle bundle : this.waitingProviders.keySet()) {
            if (bundle.getState() == 1) continue;
            this.processAutomationProvider(bundle);
        }
    }

    protected void removeParser(Parser<E> parser, Map<String, String> properties) {
        String parserType = properties.get("format");
        parserType = parserType == null ? "json" : parserType;
        this.parsers.remove(parserType);
    }

    protected void processAutomationProvider(Bundle bundle) {
        String bsn;
        Enumeration urlEnum = null;
        try {
            if (bundle.getState() != 1) {
                urlEnum = bundle.findEntries(this.path, null, true);
            }
        }
        catch (IllegalStateException e) {
            this.logger.debug("Can't read from resource of bundle with ID {}. The bundle is uninstalled.", (Object)bundle.getBundleId(), (Object)e);
            this.processAutomationProviderUninstalled(bundle);
        }
        if ((bsn = bundle.getSymbolicName()) == null) {
            bsn = String.format("@bundleId@0x%x", bundle.getBundleId());
        }
        Vendor vendor = new Vendor(bsn, bundle.getVersion().toString());
        List<String> previousPortfolio = this.getPreviousPortfolio(vendor);
        LinkedList<String> newPortfolio = new LinkedList<String>();
        if (urlEnum != null) {
            while (urlEnum.hasMoreElements()) {
                Set<E> parsedObjects;
                URL url = (URL)urlEnum.nextElement();
                if (url.getPath().endsWith(File.separator)) continue;
                String parserType = this.getParserType(url);
                Parser<E> parser = this.parsers.get(parserType);
                this.updateWaitingProviders(parser, bundle, url);
                if (parser == null || (parsedObjects = this.parseData(parser, url, bundle)).isEmpty()) continue;
                this.addNewProvidedObjects(newPortfolio, previousPortfolio, parsedObjects);
            }
            this.putNewPortfolio(vendor, newPortfolio);
        }
        this.removeUninstalledObjects(previousPortfolio, newPortfolio);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeUninstalledObjects(List<String> previousPortfolio, List<String> newPortfolio) {
        for (String uid : previousPortfolio) {
            LinkedList<ProviderChangeListener<E>> snapshot;
            E removedObject;
            if (newPortfolio.contains(uid) || (removedObject = this.providedObjectsHolder.remove(uid)) == null) continue;
            List<ProviderChangeListener<E>> list = this.listeners;
            synchronized (list) {
                snapshot = new LinkedList<ProviderChangeListener<E>>(this.listeners);
            }
            for (ProviderChangeListener providerChangeListener : snapshot) {
                providerChangeListener.removed((Provider)this, removedObject);
            }
        }
    }

    protected List<String> getPreviousPortfolio(Vendor vendor) {
        List<String> portfolio = this.providerPortfolio.remove(vendor);
        if (portfolio == null) {
            for (Vendor v : this.providerPortfolio.keySet()) {
                if (!v.getVendorSymbolicName().equals(vendor.getVendorSymbolicName())) continue;
                List<String> vendorPortfolio = this.providerPortfolio.remove(v);
                return vendorPortfolio == null ? List.of() : vendorPortfolio;
            }
        }
        return portfolio == null ? List.of() : portfolio;
    }

    protected void putNewPortfolio(Vendor vendor, List<String> portfolio) {
        this.providerPortfolio.put(vendor, portfolio);
    }

    protected String getParserType(URL url) {
        String fileName = url.getPath();
        int index = fileName.lastIndexOf(".");
        String extension = index != -1 ? fileName.substring(index + 1) : "";
        return extension.isEmpty() || "txt".equals(extension) ? "json" : extension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processAutomationProviderUninstalled(Bundle bundle) {
        Vendor vendor;
        List<String> portfolio;
        this.waitingProviders.remove(bundle);
        String bsn = bundle.getSymbolicName();
        if (bsn == null) {
            bsn = String.format("@bundleId@0x%x", bundle.getBundleId());
        }
        if ((portfolio = this.providerPortfolio.remove(vendor = new Vendor(bsn, bundle.getVersion().toString()))) != null && !portfolio.isEmpty()) {
            for (String uid : portfolio) {
                LinkedList<ProviderChangeListener<E>> snapshot;
                @Nullable E removedObject = this.providedObjectsHolder.remove(uid);
                if (removedObject == null) continue;
                List<ProviderChangeListener<E>> list = this.listeners;
                synchronized (list) {
                    snapshot = new LinkedList<ProviderChangeListener<E>>(this.listeners);
                }
                for (ProviderChangeListener providerChangeListener : snapshot) {
                    providerChangeListener.removed((Provider)this, removedObject);
                }
            }
        }
    }

    protected @Nullable Bundle getBundle(String uid) {
        String symbolicName = null;
        for (Map.Entry<Vendor, List<String>> entry : this.providerPortfolio.entrySet()) {
            if (!entry.getValue().contains(uid)) continue;
            symbolicName = entry.getKey().getVendorSymbolicName();
            break;
        }
        if (symbolicName != null) {
            Bundle[] bundles;
            Bundle[] bundleArray = bundles = this.bundleContext.getBundles();
            int n = bundles.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle bundle = bundleArray[n2];
                if (symbolicName.equals(bundle.getSymbolicName())) {
                    return bundle;
                }
                ++n2;
            }
        }
        return null;
    }

    protected List<ConfigDescriptionParameter> getLocalizedConfigurationDescription(@Nullable List<ConfigDescriptionParameter> config, Bundle bundle, String uid, String prefix, @Nullable Locale locale) {
        ConfigI18nLocalizationService localConfigI18nService = this.configI18nService;
        if (config != null && localConfigI18nService != null) {
            try {
                URI uri = new URI(prefix + ":" + uid + ".name");
                return config.stream().map(p -> localConfigI18nService.getLocalizedConfigDescriptionParameter(bundle, uri, p, locale)).toList();
            }
            catch (URISyntaxException e) {
                this.logger.error("Constructed invalid uri '{}:{}.name'", new Object[]{prefix, uid, e});
                return config;
            }
        }
        return List.of();
    }

    protected Set<E> parseData(Parser<E> parser, URL url, Bundle bundle) {
        InputStreamReader reader = null;
        InputStream is = null;
        try {
            is = url.openStream();
            reader = new InputStreamReader(is, StandardCharsets.UTF_8);
            Set<E> set = parser.parse(reader);
            return set;
        }
        catch (ParsingException e) {
            this.logger.error("{}", (Object)e.getLocalizedMessage(), (Object)e);
        }
        catch (IOException e) {
            this.logger.error("Can't read from resource of bundle with ID {}", (Object)bundle.getBundleId(), (Object)e);
            this.processAutomationProviderUninstalled(bundle);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return Set.of();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addNewProvidedObjects(List<String> newPortfolio, List<String> previousPortfolio, Set<E> parsedObjects) {
        LinkedList<ProviderChangeListener<E>> snapshot;
        List<ProviderChangeListener<E>> list = this.listeners;
        synchronized (list) {
            snapshot = new LinkedList<ProviderChangeListener<E>>(this.listeners);
        }
        for (E parsedObject : parsedObjects) {
            String uid = this.getUID(parsedObject);
            @Nullable E oldElement = this.providedObjectsHolder.get(uid);
            if (oldElement != null && !previousPortfolio.contains(uid)) {
                this.logger.warn("{} with UID '{}' already exists! Failed to add a second with the same UID!", (Object)parsedObject.getClass().getName(), (Object)uid);
                continue;
            }
            newPortfolio.add(uid);
            this.providedObjectsHolder.put(uid, parsedObject);
            for (ProviderChangeListener providerChangeListener : snapshot) {
                if (oldElement == null) {
                    providerChangeListener.added((Provider)this, parsedObject);
                    continue;
                }
                providerChangeListener.updated((Provider)this, oldElement, parsedObject);
            }
        }
    }

    protected void updateWaitingProviders(@Nullable Parser<E> parser, Bundle bundle, URL url) {
        List<URL> urlList = this.waitingProviders.get(bundle);
        if (parser == null) {
            if (urlList == null) {
                urlList = new ArrayList<URL>();
            }
            urlList.add(url);
            this.waitingProviders.put(bundle, urlList);
            return;
        }
        if (urlList != null && urlList.remove(url) && urlList.isEmpty()) {
            this.waitingProviders.remove(bundle);
        }
    }

    protected abstract String getUID(E var1);
}

