"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = mlPlugin;
/*
 * SPDX-License-Identifier: Apache-2.0
 */

function mlPlugin(Client, config, components) {
  const ca = components.clientAction.factory;
  Client.prototype.ml = components.clientAction.namespaceFactory();
  const ml = Client.prototype.ml.prototype;
  ml.executeAgent = ca({
    url: {
      fmt: `/_plugins/_ml/agents/<%=agentId%>/_execute?async=<%=async%>`,
      req: {
        agentId: {
          type: 'string',
          required: true
        },
        async: {
          type: 'boolean',
          required: false
        }
      }
    },
    needBody: true,
    method: 'POST'
  });
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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