"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomalyDetectionOpenSearchDashboardsPlugin = void 0;
var _constants = require("../utils/constants");
var _operators = require("rxjs/operators");
var _router = _interopRequireDefault(require("./router"));
var _adPlugin = _interopRequireDefault(require("./cluster/ad/adPlugin"));
var _alertingPlugin = _interopRequireDefault(require("./cluster/ad/alertingPlugin"));
var _mlPlugin = _interopRequireDefault(require("./cluster/ad/mlPlugin"));
var _forecastFeature = _interopRequireDefault(require("./cluster/ad/forecastFeature"));
var _ad = _interopRequireWildcard(require("./routes/ad"));
var _alerting = _interopRequireWildcard(require("./routes/alerting"));
var _ml = _interopRequireWildcard(require("./routes/ml"));
var _opensearch = _interopRequireWildcard(require("./routes/opensearch"));
var _sampleData = _interopRequireWildcard(require("./routes/sampleData"));
var _constants2 = require("./utils/constants");
var _forecast = _interopRequireWildcard(require("./routes/forecast"));
var _ui_settings = require("./ui_settings");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          *
                                                                                                                                                                                                                                                                                                                          * The OpenSearch Contributors require contributions made to
                                                                                                                                                                                                                                                                                                                          * this file be licensed under the Apache-2.0 license or a
                                                                                                                                                                                                                                                                                                                          * compatible open source license.
                                                                                                                                                                                                                                                                                                                          *
                                                                                                                                                                                                                                                                                                                          * Modifications Copyright OpenSearch Contributors. See
                                                                                                                                                                                                                                                                                                                          * GitHub history for details.
                                                                                                                                                                                                                                                                                                                          */
class AnomalyDetectionOpenSearchDashboardsPlugin {
  constructor(initializerContext) {
    this.initializerContext = initializerContext;
    _defineProperty(this, "logger", void 0);
    _defineProperty(this, "globalConfig$", void 0);
    this.logger = initializerContext.logger.get();
    this.globalConfig$ = initializerContext.config.legacy.globalConfig$;
  }
  async setup(core, {
    dataSource
  }) {
    // Register UI settings
    core.uiSettings.register((0, _ui_settings.getAnomalyDetectionUiSettings)());

    // Get any custom/overridden headers
    const globalConfig = await this.globalConfig$.pipe((0, _operators.first)()).toPromise();
    const {
      customHeaders,
      ...rest
    } = globalConfig.opensearch;

    // Create OpenSearch client w/ relevant plugins and headers
    const client = core.opensearch.legacy.createClient('anomaly_detection', {
      // forecastFeature is still inside adPlugin, but totally independent from adPlugin
      plugins: [_adPlugin.default, _alertingPlugin.default, _forecastFeature.default, _mlPlugin.default],
      customHeaders: {
        ...customHeaders,
        ..._constants2.DEFAULT_HEADERS
      },
      ...rest
    });
    const dataSourceEnabled = !!dataSource;
    if (dataSourceEnabled) {
      dataSource.registerCustomApiSchema(_adPlugin.default);
      dataSource.registerCustomApiSchema(_alertingPlugin.default);
      dataSource.registerCustomApiSchema(_forecastFeature.default);
      dataSource.registerCustomApiSchema(_mlPlugin.default);
    }

    // Create router
    const apiRouter = (0, _router.default)(core.http.createRouter(), _constants.BASE_NODE_API_PATH);
    const mlApiRouter = (0, _router.default)(core.http.createRouter(), '/api/ml');
    const forecastApiRouter = (0, _router.default)(core.http.createRouter(), _constants.FORECAST_BASE_NODE_API_PATH);

    // Create services & register with OpenSearch client
    const adService = new _ad.default(client, dataSourceEnabled);
    const alertingService = new _alerting.default(client, dataSourceEnabled);
    const mlService = new _ml.default(client, dataSourceEnabled);
    const opensearchService = new _opensearch.default(client, dataSourceEnabled);
    const sampleDataService = new _sampleData.default(client, dataSourceEnabled);
    const forecastService = new _forecast.default(client, dataSourceEnabled);

    // Register server routes with the service
    (0, _ad.registerADRoutes)(apiRouter, adService);
    (0, _alerting.registerAlertingRoutes)(apiRouter, alertingService);
    (0, _ml.registerMLRoutes)(mlApiRouter, mlService);
    (0, _opensearch.registerOpenSearchRoutes)(apiRouter, opensearchService);
    (0, _sampleData.registerSampleDataRoutes)(apiRouter, sampleDataService);
    (0, _forecast.registerForecastRoutes)(forecastApiRouter, forecastService);
    return {};
  }
  async start(core) {
    return {};
  }
}
exports.AnomalyDetectionOpenSearchDashboardsPlugin = AnomalyDetectionOpenSearchDashboardsPlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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