"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JSONLINES_LINK = exports.INVALID_DATASOURCE_MSG = exports.INSPECTOR_TAB_ID = exports.INSPECTOR_TABS = exports.INPUT_TRANSFORM_OPTIONS = exports.INGEST_PIPELINE_NODE_API_PATH = exports.INGEST_NODE_API_PATH = exports.INDEX_NOT_FOUND_EXCEPTION = exports.INDEX_NAME_REGEXP = exports.IMAGE_FIELD_PATTERN = exports.HYBRID_SEARCH_QUERY_MATCH_TERM = exports.HYBRID_SEARCH_QUERY_MATCH_NEURAL = exports.HYBRID_SEARCH_QUERY_MATCH_KNN = exports.GITHUB_FEEDBACK_LINK = exports.GET_WORKFLOW_STATE_NODE_API_PATH = exports.GET_WORKFLOW_NODE_API_PATH = exports.GET_SEARCH_TEMPLATES_NODE_API_PATH = exports.GET_PRESET_WORKFLOWS_NODE_API_PATH = exports.GET_MAPPINGS_NODE_API_PATH = exports.GET_INDEX_NODE_API_PATH = exports.GET_AGENT_NODE_API_PATH = exports.GENERAL_TEXT_GENERATION_PROMPT = exports.GENERAL_SUMMARIZE_PROMPT = exports.GENERAL_QA_WITH_CONTEXT_PROMPT = exports.GENERAL_QA_NO_CONTEXT_PROMPT = exports.FUZZY_QUERY_TEXT = exports.FLOW_FRAMEWORK_WORKFLOW_ROUTE_PREFIX = exports.FLOW_FRAMEWORK_SEARCH_WORKFLOW_STATE_ROUTE = exports.FLOW_FRAMEWORK_SEARCH_WORKFLOWS_ROUTE = exports.FLOW_FRAMEWORK_API_ROUTE_PREFIX = exports.FIXED_TOKEN_LENGTH_OPTIONAL_FIELDS = exports.FETCH_ALL_QUERY_LARGE = exports.FETCH_ALL_QUERY = exports.EXPANDED_FORM_QUERY_ISSUE = exports.EXISTS_QUERY_TEXT = exports.EXAMPLE_PUT_AGENTIC_SEARCH_PIPELINE = exports.EXAMPLE_AGENTIC_SEARCH_QUERY = exports.ERROR_GETTING_WORKFLOW_MSG = exports.EMPTY_OUTPUT_MAP_ENTRY = exports.EMPTY_MAP_ENTRY = exports.EMPTY_INPUT_MAP_ENTRY = exports.EMPTY_FIELD_STRING = exports.EMPTY_AGENT = exports.DEPROVISION_WORKFLOW_NODE_API_PATH = exports.DELIMITER_OPTIONAL_FIELDS = exports.DELETE_WORKFLOW_NODE_API_PATH = exports.DEFAULT_VECTOR_FIELD = exports.DEFAULT_TEXT_FIELD = exports.DEFAULT_PROMPT_TEXT_CATEGORY_FIELD = exports.DEFAULT_PROMPT_ROLE_FIELD = exports.DEFAULT_PROMPT_RESULTS_FIELD = exports.DEFAULT_PROMPT_QUESTION_FIELD = exports.DEFAULT_NEW_WORKFLOW_STATE_TYPE = exports.DEFAULT_NEW_WORKFLOW_NAME = exports.DEFAULT_NEW_WORKFLOW_DESCRIPTION = exports.DEFAULT_MCP_SERVER = exports.DEFAULT_LLM_RESPONSE_FIELD = exports.DEFAULT_K = exports.DEFAULT_IMAGE_FIELD = exports.DEFAULT_FETCH_SIZE = exports.DEFAULT_AGENT = exports.DEEPSEEK_CHAT_DOCS_LINK = exports.DATE_FORMAT_PATTERN = exports.CREATE_WORKFLOW_NODE_API_PATH = exports.CREATE_WORKFLOW_LINK = exports.CONNECTOR_PROTOCOL = exports.CONFIG_STEP = exports.COMPONENT_ID = exports.COMPONENT_CLASS = exports.COMPONENT_CATEGORY = exports.COHERE_EMBEDDING_MODEL_DOCS_LINK = exports.COHERE_CONFIGS = exports.CLAUDE_SUMMARIZE_PROMPT = exports.CLAUDE_QA_WITH_CONTEXT_PROMPT = exports.CAT_INDICES_NODE_API_PATH = exports.BULK_NODE_API_PATH = exports.BULK_API_DOCS_LINK = exports.BEDROCK_TITAN_EMBEDDING_DOCS_LINK = exports.BEDROCK_CONFIGS = exports.BEDROCK_CLAUDE_3_SONNET_DOCS_LINK = exports.BASE_WORKFLOW_NODE_API_PATH = exports.BASE_OPENSEARCH_NODE_API_PATH = exports.BASE_NODE_API_PATH = exports.BASE_MODEL_NODE_API_PATH = exports.BASE_CONNECTOR_NODE_API_PATH = exports.BASE_AGENT_NODE_API_PATH = exports.AGENT_TYPE = exports.AGENT_MEMORY_TYPE = exports.AGENT_MAIN_DOCS_LINK = exports.AGENT_LLM_INTERFACE_TYPE = exports.AGENT_ID_PATTERN = exports.AGENT_ID_PATH = exports.AGENT_FIELDS_DOCS_LINK = exports.AGENTIC_SEARCH_QUERY = exports.AGENTIC_SEARCH_MODELS_DOCS_LINK = exports.AGENTIC_SEARCH_MCP_DOCS_LINK = exports.AGENTIC_SEARCH_DOCS_LINK = exports.AGENTIC_SEARCH_AGENTS_DOCS_LINK = exports.AGENTIC_QUERY_DSL_DOCS_LINK = exports.ABORT_SEARCH_ERROR_MESSAGE = void 0;
exports.TEXT_FIELD_PATTERN = exports.TEXT_CHUNKING_PROCESSOR_LINK = exports.TEXT_CHUNKING_ALGORITHM = exports.TERM_QUERY_TEXT = exports.SOURCE_OPTIONS = exports.SORT_ORDER = exports.SIMULATE_PIPELINE_NODE_API_PATH = exports.SHARED_OPTIONAL_FIELDS = exports.SEMANTIC_SEARCH_TEMPLATE_QUERY = exports.SEMANTIC_SEARCH_QUERY_NEURAL = exports.SEARCH_WORKFLOWS_NODE_API_PATH = exports.SEARCH_TEMPLATES_DOCS_LINK = exports.SEARCH_PIPELINE_ROUTE = exports.SEARCH_PIPELINE_NODE_API_PATH = exports.SEARCH_PIPELINE_DOCS_LINK = exports.SEARCH_MODELS_NODE_API_PATH = exports.SEARCH_INDEX_NODE_API_PATH = exports.SEARCH_CONNECTORS_NODE_API_PATH = exports.SEARCH_AGENTS_NODE_API_PATH = exports.SAGEMAKER_SPARSE_DEPLOY_LINK = exports.RESPONSE_FILTER_TYPE = exports.REQUEST_PREFIX_WITH_JSONPATH_ROOT_SELECTOR = exports.REQUEST_PREFIX = exports.REGISTER_AGENT_NODE_API_PATH = exports.QUERY_TEXT_PATTERN = exports.QUERY_STRING_QUERY_TEXT = exports.QUERY_PRESETS = exports.QUERY_PLANNING_TOOL_DOCS_LINK = exports.QUERY_PLANNING_MODEL_DOCS_LINK = exports.QUERY_IMAGE_PATTERN = exports.PROVISION_WORKFLOW_NODE_API_PATH = exports.PROVISION_TIMEOUT = exports.PROMPT_PRESETS = exports.PROCESSOR_TYPE = exports.PROCESSOR_CONTEXT = exports.PREFIX_QUERY_TEXT = exports.PLUGIN_NAME = exports.PLUGIN_ID = exports.OUTPUT_TRANSFORM_OPTIONS = exports.OPENSEARCH_NEURAL_SPARSE_DOCS_LINK = exports.OPENAI_GPT35_DOCS_LINK = exports.OPENAI_CONFIGS = exports.OMIT_SYSTEM_INDEX_PATTERN = exports.NO_TRANSFORMATION = exports.NO_TEMPLATES_FOUND_MSG = exports.NO_MODIFICATIONS_FOUND_TEXT = exports.NORMALIZATION_PROCESSOR_LINK = exports.NODE_CATEGORY = exports.NEW_AGENT_PLACEHOLDER = exports.NEW_AGENT_ID_PLACEHOLDER = exports.NEURAL_SPARSE_SEARCH_QUERY = exports.NEURAL_SPARSE_CONFIGS = exports.MULTIMODAL_SEARCH_QUERY_NEURAL = exports.MULTIMODAL_SEARCH_QUERY_BOOL = exports.MODEL_TYPE = exports.MODEL_OUTPUT_SCHEMA_NESTED_PATH = exports.MODEL_OUTPUT_SCHEMA_FULL_PATH = exports.MODEL_ID_PATTERN = exports.MODEL_CATEGORY = exports.ML_SEARCH_MODELS_ROUTE = exports.ML_SEARCH_CONNECTORS_ROUTE = exports.ML_SEARCH_AGENTS_ROUTE = exports.ML_RESPONSE_PROCESSOR_EXAMPLE_DOCS_LINK = exports.ML_REMOTE_MODEL_LINK = exports.ML_REGISTER_AGENT_ROUTE = exports.ML_MODEL_ROUTE_PREFIX = exports.ML_MODELS_SETUP_DOCS_LINK = exports.ML_INTERFACE_LINK = exports.ML_INFERENCE_RESPONSE_DOCS_LINK = exports.ML_INFERENCE_DOCS_LINK = exports.ML_GET_AGENT_ROUTE = exports.ML_CONNECTOR_ROUTE_PREFIX = exports.ML_API_ROUTE_PREFIX = exports.ML_AGENT_ROUTE_PREFIX = exports.MIN_SUPPORTED_VERSION = exports.MINIMUM_FULL_SUPPORTED_VERSION = exports.MINIMUM_AGENTIC_SEARCH_VERSION = exports.MEMORY_DOCS_LINK = exports.MCP_CONNECTOR_DOCS_LINK = exports.MCP_AGENT_CONFIG_DOCS_LINK = exports.MAX_WORKFLOW_NAME_TO_DISPLAY = exports.MAX_TEMPLATE_STRING_LENGTH = exports.MAX_STRING_LENGTH = exports.MAX_JSON_STRING_LENGTH = exports.MAX_DOCS_TO_IMPORT = exports.MAX_DOCS = exports.MAX_DESCRIPTION_LENGTH = exports.MAX_BYTES_FORMATTED = exports.MAX_BYTES = exports.MATCH_QUERY_TEXT = exports.MATCH_PHRASE_QUERY_TEXT = exports.MATCH_PHRASE_PREFIX_QUERY_TEXT = exports.MATCH_BOOLEAN_QUERY_TEXT = exports.MAIN_PLUGIN_DOC_LINK = exports.LEFT_NAV_SELECTED_STYLE = exports.LABEL_FIELD_PATTERN = exports.KNN_VECTOR_DOCS_LINK = exports.KNN_QUERY = exports.JSONPATH_ROOT_SELECTOR = exports.JSONPATH_DOCS_LINK = void 0;
exports.WORKFLOW_TYPE_LEGACY = exports.WORKFLOW_TYPE = exports.WORKFLOW_TUTORIAL_LINK = exports.WORKFLOW_NAME_RESTRICTIONS = exports.WORKFLOW_NAME_REGEXP = exports.WILDCARD_QUERY_TEXT = exports.WEB_SEARCH_TOOL_DOCS_LINK = exports.VECTOR_TEMPLATE_PLACEHOLDER = exports.VECTOR_PATTERN = exports.VECTOR_FIELD_PATTERN = exports.VECTOR = exports.UPDATE_WORKFLOW_NODE_API_PATH = exports.UPDATE_MODEL_DOCS_LINK = exports.UPDATE_AGENT_NODE_API_PATH = exports.UI_METADATA_SCHEMA_VERSION = exports.TRANSFORM_TYPE = exports.TRANSFORM_CONTEXT = exports.TOOL_TYPE = exports.TOOL_DESCRIPTION = exports.TOOLS_DOCS_LINK = void 0;
var _utils = require("./utils");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const PLUGIN_ID = exports.PLUGIN_ID = 'opensearch-flow';
const PLUGIN_NAME = exports.PLUGIN_NAME = 'AI Search Flows'; // visible plugin name in the context of OSD

/**
 * BACKEND FLOW FRAMEWORK APIs
 */
const FLOW_FRAMEWORK_API_ROUTE_PREFIX = exports.FLOW_FRAMEWORK_API_ROUTE_PREFIX = '/_plugins/_flow_framework';
const FLOW_FRAMEWORK_WORKFLOW_ROUTE_PREFIX = exports.FLOW_FRAMEWORK_WORKFLOW_ROUTE_PREFIX = `${FLOW_FRAMEWORK_API_ROUTE_PREFIX}/workflow`;
const FLOW_FRAMEWORK_SEARCH_WORKFLOWS_ROUTE = exports.FLOW_FRAMEWORK_SEARCH_WORKFLOWS_ROUTE = `${FLOW_FRAMEWORK_WORKFLOW_ROUTE_PREFIX}/_search`;
const FLOW_FRAMEWORK_SEARCH_WORKFLOW_STATE_ROUTE = exports.FLOW_FRAMEWORK_SEARCH_WORKFLOW_STATE_ROUTE = `${FLOW_FRAMEWORK_WORKFLOW_ROUTE_PREFIX}/state/_search`;

/**
 * BACKEND ML PLUGIN APIs
 */
const ML_API_ROUTE_PREFIX = exports.ML_API_ROUTE_PREFIX = '/_plugins/_ml';
const ML_MODEL_ROUTE_PREFIX = exports.ML_MODEL_ROUTE_PREFIX = `${ML_API_ROUTE_PREFIX}/models`;
const ML_CONNECTOR_ROUTE_PREFIX = exports.ML_CONNECTOR_ROUTE_PREFIX = `${ML_API_ROUTE_PREFIX}/connectors`;
const ML_AGENT_ROUTE_PREFIX = exports.ML_AGENT_ROUTE_PREFIX = `${ML_API_ROUTE_PREFIX}/agents`;
const ML_SEARCH_MODELS_ROUTE = exports.ML_SEARCH_MODELS_ROUTE = `${ML_MODEL_ROUTE_PREFIX}/_search`;
const ML_SEARCH_CONNECTORS_ROUTE = exports.ML_SEARCH_CONNECTORS_ROUTE = `${ML_CONNECTOR_ROUTE_PREFIX}/_search`;
const ML_REGISTER_AGENT_ROUTE = exports.ML_REGISTER_AGENT_ROUTE = `${ML_AGENT_ROUTE_PREFIX}/_register`;
const ML_SEARCH_AGENTS_ROUTE = exports.ML_SEARCH_AGENTS_ROUTE = `${ML_AGENT_ROUTE_PREFIX}/_search`;
const ML_GET_AGENT_ROUTE = exports.ML_GET_AGENT_ROUTE = `${ML_AGENT_ROUTE_PREFIX}/{agentId}`;

/**
 * OpenSearch APIs
 */
const SEARCH_PIPELINE_ROUTE = exports.SEARCH_PIPELINE_ROUTE = '/_search/pipeline';

/**
 * NODE APIs
 */
const BASE_NODE_API_PATH = exports.BASE_NODE_API_PATH = '/api/flow_framework';

// OpenSearch node APIs
const BASE_OPENSEARCH_NODE_API_PATH = exports.BASE_OPENSEARCH_NODE_API_PATH = `${BASE_NODE_API_PATH}/opensearch`;
const CAT_INDICES_NODE_API_PATH = exports.CAT_INDICES_NODE_API_PATH = `${BASE_OPENSEARCH_NODE_API_PATH}/catIndices`;
const GET_MAPPINGS_NODE_API_PATH = exports.GET_MAPPINGS_NODE_API_PATH = `${BASE_OPENSEARCH_NODE_API_PATH}/mappings`;
const GET_INDEX_NODE_API_PATH = exports.GET_INDEX_NODE_API_PATH = `${BASE_OPENSEARCH_NODE_API_PATH}/getIndex`;
const SEARCH_INDEX_NODE_API_PATH = exports.SEARCH_INDEX_NODE_API_PATH = `${BASE_OPENSEARCH_NODE_API_PATH}/search`;
const INGEST_NODE_API_PATH = exports.INGEST_NODE_API_PATH = `${BASE_OPENSEARCH_NODE_API_PATH}/ingest`;
const BULK_NODE_API_PATH = exports.BULK_NODE_API_PATH = `${BASE_OPENSEARCH_NODE_API_PATH}/bulk`;
const SIMULATE_PIPELINE_NODE_API_PATH = exports.SIMULATE_PIPELINE_NODE_API_PATH = `${BASE_OPENSEARCH_NODE_API_PATH}/simulatePipeline`;
const INGEST_PIPELINE_NODE_API_PATH = exports.INGEST_PIPELINE_NODE_API_PATH = `${BASE_OPENSEARCH_NODE_API_PATH}/getIngestPipeline`;
const SEARCH_PIPELINE_NODE_API_PATH = exports.SEARCH_PIPELINE_NODE_API_PATH = `${BASE_OPENSEARCH_NODE_API_PATH}/getSearchPipeline`;
const GET_SEARCH_TEMPLATES_NODE_API_PATH = exports.GET_SEARCH_TEMPLATES_NODE_API_PATH = `${BASE_OPENSEARCH_NODE_API_PATH}/getSearchTemplates`;

// Flow Framework node APIs
const BASE_WORKFLOW_NODE_API_PATH = exports.BASE_WORKFLOW_NODE_API_PATH = `${BASE_NODE_API_PATH}/workflow`;
const GET_WORKFLOW_NODE_API_PATH = exports.GET_WORKFLOW_NODE_API_PATH = `${BASE_WORKFLOW_NODE_API_PATH}`;
const SEARCH_WORKFLOWS_NODE_API_PATH = exports.SEARCH_WORKFLOWS_NODE_API_PATH = `${BASE_WORKFLOW_NODE_API_PATH}/search`;
const GET_WORKFLOW_STATE_NODE_API_PATH = exports.GET_WORKFLOW_STATE_NODE_API_PATH = `${BASE_WORKFLOW_NODE_API_PATH}/state`;
const CREATE_WORKFLOW_NODE_API_PATH = exports.CREATE_WORKFLOW_NODE_API_PATH = `${BASE_WORKFLOW_NODE_API_PATH}/create`;
const UPDATE_WORKFLOW_NODE_API_PATH = exports.UPDATE_WORKFLOW_NODE_API_PATH = `${BASE_WORKFLOW_NODE_API_PATH}/update`;
const PROVISION_WORKFLOW_NODE_API_PATH = exports.PROVISION_WORKFLOW_NODE_API_PATH = `${BASE_WORKFLOW_NODE_API_PATH}/provision`;
const DEPROVISION_WORKFLOW_NODE_API_PATH = exports.DEPROVISION_WORKFLOW_NODE_API_PATH = `${BASE_WORKFLOW_NODE_API_PATH}/deprovision`;
const DELETE_WORKFLOW_NODE_API_PATH = exports.DELETE_WORKFLOW_NODE_API_PATH = `${BASE_WORKFLOW_NODE_API_PATH}/delete`;
const GET_PRESET_WORKFLOWS_NODE_API_PATH = exports.GET_PRESET_WORKFLOWS_NODE_API_PATH = `${BASE_WORKFLOW_NODE_API_PATH}/presets`;

// ML Plugin node APIs
const BASE_MODEL_NODE_API_PATH = exports.BASE_MODEL_NODE_API_PATH = `${BASE_NODE_API_PATH}/model`;
const BASE_CONNECTOR_NODE_API_PATH = exports.BASE_CONNECTOR_NODE_API_PATH = `${BASE_NODE_API_PATH}/connector`;
const BASE_AGENT_NODE_API_PATH = exports.BASE_AGENT_NODE_API_PATH = `${BASE_NODE_API_PATH}/agent`;
const SEARCH_MODELS_NODE_API_PATH = exports.SEARCH_MODELS_NODE_API_PATH = `${BASE_MODEL_NODE_API_PATH}/search`;
const SEARCH_CONNECTORS_NODE_API_PATH = exports.SEARCH_CONNECTORS_NODE_API_PATH = `${BASE_CONNECTOR_NODE_API_PATH}/search`;
const REGISTER_AGENT_NODE_API_PATH = exports.REGISTER_AGENT_NODE_API_PATH = `${BASE_AGENT_NODE_API_PATH}/register`;
const UPDATE_AGENT_NODE_API_PATH = exports.UPDATE_AGENT_NODE_API_PATH = `${BASE_AGENT_NODE_API_PATH}/update`;
const SEARCH_AGENTS_NODE_API_PATH = exports.SEARCH_AGENTS_NODE_API_PATH = `${BASE_AGENT_NODE_API_PATH}/search`;
const GET_AGENT_NODE_API_PATH = exports.GET_AGENT_NODE_API_PATH = `${BASE_AGENT_NODE_API_PATH}`;

/**
 * Remote model dimensions. Used for attempting to pre-fill dimension size
 * based on the specified remote model from a remote service, if found
 */

// Amazon BedRock
const BEDROCK_CONFIGS = exports.BEDROCK_CONFIGS = {
  [`amazon.titan-embed-text-v1`]: {
    dimension: 1536,
    fieldName: 'embedding'
  },
  [`amazon.titan-embed-text-v2`]: {
    dimension: 1024,
    fieldName: 'embedding'
  },
  [`amazon.titan-embed-image-v1`]: {
    dimension: 1024,
    fieldName: 'embedding'
  },
  [`cohere.embed-english-v3`]: {
    dimension: 1024,
    fieldName: 'embeddings'
  },
  [`cohere.embed-multilingual-v3`]: {
    dimension: 1024,
    fieldName: 'embeddings'
  }
};

// Cohere
const COHERE_CONFIGS = exports.COHERE_CONFIGS = {
  [`embed-english-v3.0`]: {
    dimension: 1024,
    fieldName: 'embeddings'
  },
  [`embed-english-light-v3.0`]: {
    dimension: 384,
    fieldName: 'embeddings'
  },
  [`embed-multilingual-v3.0`]: {
    dimension: 1024,
    fieldName: 'embeddings'
  },
  [`embed-multilingual-light-v3.0`]: {
    dimension: 384,
    fieldName: 'embeddings'
  },
  [`embed-english-v2.0`]: {
    dimension: 4096,
    fieldName: 'embeddings'
  },
  [`embed-english-light-v2.0`]: {
    dimension: 1024,
    fieldName: 'embeddings'
  },
  [`embed-multilingual-v2.0`]: {
    dimension: 768,
    fieldName: 'embeddings'
  }
};

// OpenAI
const OPENAI_CONFIGS = exports.OPENAI_CONFIGS = {
  [`text-embedding-3-small`]: {
    dimension: 1536,
    fieldName: 'embedding'
  },
  [`text-embedding-3-large`]: {
    dimension: 3072,
    fieldName: 'embedding'
  },
  [`text-embedding-ada-002`]: {
    dimension: 1536,
    fieldName: 'embedding'
  }
};

// Neural Sparse
const NEURAL_SPARSE_CONFIGS = exports.NEURAL_SPARSE_CONFIGS = {
  [`opensearch-neural-sparse-encoding-v2-distill`]: {
    dimension: 30522,
    fieldName: 'passage_embedding'
  },
  [`opensearch-neural-sparse-encoding-v1`]: {
    dimension: 30522,
    fieldName: 'passage_embedding'
  },
  [`opensearch-neural-sparse-encoding-multilingual-v1`]: {
    dimension: 105879,
    fieldName: 'passage_embedding'
  },
  [`opensearch-neural-sparse-encoding-doc-v2-mini`]: {
    dimension: 30522,
    fieldName: 'passage_embedding'
  },
  [`opensearch-neural-sparse-encoding-doc-v3-distill`]: {
    dimension: 30522,
    fieldName: 'passage_embedding'
  },
  [`opensearch-neural-sparse-encoding-doc-v1`]: {
    dimension: 30522,
    fieldName: 'passage_embedding'
  },
  [`opensearch-neural-sparse-encoding-doc-v2-distill`]: {
    dimension: 30522,
    fieldName: 'passage_embedding'
  }
};

/**
 * Various constants pertaining to Workflow configs
 */

/**
 * Schema versioning for tracking all changes made to the config fields within ui_metadata. Used for BWC and debugging.
 * Version 1: Initial release
 * Version 2: Updates ML search response processor to have an additional "ext_output" field. https://github.com/opensearch-project/dashboards-flow-framework/pull/699
 */
const UI_METADATA_SCHEMA_VERSION = exports.UI_METADATA_SCHEMA_VERSION = 2;

// frontend-specific workflow types, derived from the available preset templates
let WORKFLOW_TYPE = exports.WORKFLOW_TYPE = /*#__PURE__*/function (WORKFLOW_TYPE) {
  WORKFLOW_TYPE["SEMANTIC_SEARCH"] = "Semantic Search";
  WORKFLOW_TYPE["MULTIMODAL_SEARCH"] = "Multimodal Search";
  WORKFLOW_TYPE["HYBRID_SEARCH"] = "Hybrid Search";
  WORKFLOW_TYPE["VECTOR_SEARCH_WITH_RAG"] = "RAG with Vector Retrieval";
  WORKFLOW_TYPE["HYBRID_SEARCH_WITH_RAG"] = "RAG with Hybrid Search";
  WORKFLOW_TYPE["SEMANTIC_SEARCH_USING_SPARSE_ENCODERS"] = "Semantic Search using Sparse Encoders";
  WORKFLOW_TYPE["AGENTIC_SEARCH"] = "Agentic Search";
  WORKFLOW_TYPE["CUSTOM"] = "Custom Search";
  WORKFLOW_TYPE["UNKNOWN"] = "Unknown";
  return WORKFLOW_TYPE;
}({});
let WORKFLOW_TYPE_LEGACY = exports.WORKFLOW_TYPE_LEGACY = /*#__PURE__*/function (WORKFLOW_TYPE_LEGACY) {
  WORKFLOW_TYPE_LEGACY["SEMANTIC_SEARCH"] = "Semantic Search";
  WORKFLOW_TYPE_LEGACY["MULTIMODAL_SEARCH"] = "Multimodal Search";
  WORKFLOW_TYPE_LEGACY["HYBRID_SEARCH"] = "Hybrid Search";
  WORKFLOW_TYPE_LEGACY["CUSTOM"] = "Custom Search";
  WORKFLOW_TYPE_LEGACY["UNKNOWN"] = "Unknown";
  return WORKFLOW_TYPE_LEGACY;
}({}); // If no datasource version is found, we default to 2.17.0
const MIN_SUPPORTED_VERSION = exports.MIN_SUPPORTED_VERSION = '2.17.0';
// Min version to support ML processors
const MINIMUM_FULL_SUPPORTED_VERSION = exports.MINIMUM_FULL_SUPPORTED_VERSION = '2.19.0';
// Min version to support agentic search
const MINIMUM_AGENTIC_SEARCH_VERSION = exports.MINIMUM_AGENTIC_SEARCH_VERSION = '3.3.0';

// the names should be consistent with the underlying implementation. used when generating the
// final ingest/search pipeline configurations.
let PROCESSOR_TYPE = exports.PROCESSOR_TYPE = /*#__PURE__*/function (PROCESSOR_TYPE) {
  PROCESSOR_TYPE["ML"] = "ml_inference";
  PROCESSOR_TYPE["SPLIT"] = "split";
  PROCESSOR_TYPE["SORT"] = "sort";
  PROCESSOR_TYPE["TEXT_CHUNKING"] = "text_chunking";
  PROCESSOR_TYPE["NORMALIZATION"] = "normalization-processor";
  PROCESSOR_TYPE["COLLAPSE"] = "collapse";
  PROCESSOR_TYPE["RERANK"] = "rerank";
  PROCESSOR_TYPE["TEXT_EMBEDDING"] = "text_embedding";
  PROCESSOR_TYPE["TEXT_IMAGE_EMBEDDING"] = "text_image_embedding";
  PROCESSOR_TYPE["COPY"] = "copy";
  PROCESSOR_TYPE["AGENTIC_QUERY_TRANSLATOR"] = "agentic_query_translator";
  PROCESSOR_TYPE["AGENTIC_CONTEXT"] = "agentic_context";
  return PROCESSOR_TYPE;
}({});
let MODEL_TYPE = exports.MODEL_TYPE = /*#__PURE__*/function (MODEL_TYPE) {
  MODEL_TYPE["TEXT_EMBEDDING"] = "text_embedding";
  MODEL_TYPE["SPARSE_ENCODER"] = "sparse_encoder";
  return MODEL_TYPE;
}({});
let MODEL_CATEGORY = exports.MODEL_CATEGORY = /*#__PURE__*/function (MODEL_CATEGORY) {
  MODEL_CATEGORY["EMBEDDING"] = "EMBEDDING";
  MODEL_CATEGORY["LLM"] = "LLM";
  MODEL_CATEGORY["SPARSE_ENCODER"] = "SPARSE_ENCODER";
  return MODEL_CATEGORY;
}({});
/**
 * Various constants pertaining to the drag-and-drop UI components
 */
let COMPONENT_CATEGORY = exports.COMPONENT_CATEGORY = /*#__PURE__*/function (COMPONENT_CATEGORY) {
  COMPONENT_CATEGORY["INGEST"] = "Ingest";
  COMPONENT_CATEGORY["SEARCH"] = "Search";
  return COMPONENT_CATEGORY;
}({});
let NODE_CATEGORY = exports.NODE_CATEGORY = /*#__PURE__*/function (NODE_CATEGORY) {
  NODE_CATEGORY["CUSTOM"] = "custom";
  NODE_CATEGORY["INGEST_GROUP"] = "ingestGroup";
  NODE_CATEGORY["SEARCH_GROUP"] = "searchGroup";
  return NODE_CATEGORY;
}({});
/**
 * A base set of component classes / types.
 */
let COMPONENT_CLASS = exports.COMPONENT_CLASS = /*#__PURE__*/function (COMPONENT_CLASS) {
  COMPONENT_CLASS["INDEX"] = "index";
  COMPONENT_CLASS["KNN_INDEX"] = "knn_index";
  COMPONENT_CLASS["TRANSFORMER"] = "transformer";
  COMPONENT_CLASS["ML_TRANSFORMER"] = "ml_transformer";
  COMPONENT_CLASS["SEARCH_REQUEST"] = "search_request";
  COMPONENT_CLASS["DOCUMENT"] = "document";
  COMPONENT_CLASS["SEARCH_RESPONSE"] = "search_response";
  return COMPONENT_CLASS;
}({});
/**
 * LINKS
 */
const ML_INFERENCE_DOCS_LINK = exports.ML_INFERENCE_DOCS_LINK = 'https://opensearch.org/docs/latest/ingest-pipelines/processors/ml-inference/#configuration-parameters';
const ML_INFERENCE_RESPONSE_DOCS_LINK = exports.ML_INFERENCE_RESPONSE_DOCS_LINK = 'https://opensearch.org/docs/latest/search-plugins/search-pipelines/ml-inference-search-response/#request-fields';
const ML_REMOTE_MODEL_LINK = exports.ML_REMOTE_MODEL_LINK = 'https://docs.opensearch.org/docs/latest/ml-commons-plugin/remote-models/supported-connectors/';
const ML_INTERFACE_LINK = exports.ML_INTERFACE_LINK = 'https://docs.opensearch.org/docs/latest/ml-commons-plugin/api/model-apis/register-model/#the-interface-parameter';
const TEXT_CHUNKING_PROCESSOR_LINK = exports.TEXT_CHUNKING_PROCESSOR_LINK = 'https://opensearch.org/docs/latest/ingest-pipelines/processors/text-chunking/';
const CREATE_WORKFLOW_LINK = exports.CREATE_WORKFLOW_LINK = 'https://opensearch.org/docs/latest/automating-configurations/api/create-workflow/';
const WORKFLOW_TUTORIAL_LINK = exports.WORKFLOW_TUTORIAL_LINK = 'https://opensearch.org/docs/latest/automating-configurations/workflow-tutorial/';
const MAIN_PLUGIN_DOC_LINK = exports.MAIN_PLUGIN_DOC_LINK = 'https://docs.opensearch.org/latest/vector-search/ai-search/workflow-builder/';
const NORMALIZATION_PROCESSOR_LINK = exports.NORMALIZATION_PROCESSOR_LINK = 'https://opensearch.org/docs/latest/search-plugins/search-pipelines/normalization-processor/';
const GITHUB_FEEDBACK_LINK = exports.GITHUB_FEEDBACK_LINK = 'https://github.com/opensearch-project/dashboards-flow-framework/issues/new/choose';
const JSONPATH_DOCS_LINK = exports.JSONPATH_DOCS_LINK = 'https://www.npmjs.com/package/jsonpath-plus';
const KNN_VECTOR_DOCS_LINK = exports.KNN_VECTOR_DOCS_LINK = 'https://opensearch.org/docs/latest/field-types/supported-field-types/knn-vector/';
const BULK_API_DOCS_LINK = exports.BULK_API_DOCS_LINK = 'https://opensearch.org/docs/latest/api-reference/document-apis/bulk/';
const SEARCH_PIPELINE_DOCS_LINK = exports.SEARCH_PIPELINE_DOCS_LINK = 'https://opensearch.org/docs/latest/search-plugins/search-pipelines/using-search-pipeline/';
const ML_RESPONSE_PROCESSOR_EXAMPLE_DOCS_LINK = exports.ML_RESPONSE_PROCESSOR_EXAMPLE_DOCS_LINK = 'https://opensearch.org/docs/latest/search-plugins/search-pipelines/ml-inference-search-response/#example-externally-hosted-text-embedding-model';
const UPDATE_MODEL_DOCS_LINK = exports.UPDATE_MODEL_DOCS_LINK = 'https://opensearch.org/docs/latest/ml-commons-plugin/api/model-apis/update-model/';
const JSONLINES_LINK = exports.JSONLINES_LINK = 'https://jsonlines.org/';
const EXPANDED_FORM_QUERY_ISSUE = exports.EXPANDED_FORM_QUERY_ISSUE = 'https://github.com/opensearch-project/OpenSearch/issues/17358';
const AGENT_MAIN_DOCS_LINK = exports.AGENT_MAIN_DOCS_LINK = 'https://docs.opensearch.org/latest/ml-commons-plugin/agents-tools/agents/index/';
const AGENTIC_SEARCH_DOCS_LINK = exports.AGENTIC_SEARCH_DOCS_LINK = 'https://docs.opensearch.org/latest/vector-search/ai-search/agentic-search/';
const AGENTIC_SEARCH_MODELS_DOCS_LINK = exports.AGENTIC_SEARCH_MODELS_DOCS_LINK = 'https://docs.opensearch.org/latest/vector-search/ai-search/agentic-search/agent-customization/#model-configuration';
const AGENTIC_SEARCH_AGENTS_DOCS_LINK = exports.AGENTIC_SEARCH_AGENTS_DOCS_LINK = 'https://docs.opensearch.org/latest/vector-search/ai-search/agentic-search/agent-customization/';
const AGENTIC_SEARCH_MCP_DOCS_LINK = exports.AGENTIC_SEARCH_MCP_DOCS_LINK = 'https://docs.opensearch.org/latest/vector-search/ai-search/agentic-search/mcp-server/';
const AGENTIC_QUERY_DSL_DOCS_LINK = exports.AGENTIC_QUERY_DSL_DOCS_LINK = 'https://docs.opensearch.org/latest/query-dsl/specialized/agentic/';
const MCP_CONNECTOR_DOCS_LINK = exports.MCP_CONNECTOR_DOCS_LINK = 'https://docs.opensearch.org/latest/ml-commons-plugin/agents-tools/mcp/mcp-connector';
const MCP_AGENT_CONFIG_DOCS_LINK = exports.MCP_AGENT_CONFIG_DOCS_LINK = 'https://docs.opensearch.org/latest/ml-commons-plugin/agents-tools/mcp/mcp-connector#step-3-register-an-agent-for-accessing-mcp-tools';
const AGENT_FIELDS_DOCS_LINK = exports.AGENT_FIELDS_DOCS_LINK = 'https://docs.opensearch.org/latest/ml-commons-plugin/api/agent-apis/register-agent/#request-body-fields';
const TOOLS_DOCS_LINK = exports.TOOLS_DOCS_LINK = 'https://docs.opensearch.org/latest/ml-commons-plugin/agents-tools/tools/index/';
const MEMORY_DOCS_LINK = exports.MEMORY_DOCS_LINK = 'https://docs.opensearch.org/latest/ml-commons-plugin/api/memory-apis/index/';
const QUERY_PLANNING_TOOL_DOCS_LINK = exports.QUERY_PLANNING_TOOL_DOCS_LINK = 'https://docs.opensearch.org/latest/ml-commons-plugin/agents-tools/tools/query-planning-tool#register-parameters';
const QUERY_PLANNING_MODEL_DOCS_LINK = exports.QUERY_PLANNING_MODEL_DOCS_LINK = 'https://docs.opensearch.org/latest/ml-commons-plugin/agents-tools/tools/query-planning-tool/#step-2-register-and-deploy-a-model';
const WEB_SEARCH_TOOL_DOCS_LINK = exports.WEB_SEARCH_TOOL_DOCS_LINK = 'https://docs.opensearch.org/latest/ml-commons-plugin/agents-tools/tools/web-search-tool/#register-parameters';
const SEARCH_TEMPLATES_DOCS_LINK = exports.SEARCH_TEMPLATES_DOCS_LINK = 'https://docs.opensearch.org/latest/api-reference/search-apis/search-template/index/';

// Large Language Models Documentation Links
const BEDROCK_CLAUDE_3_SONNET_DOCS_LINK = exports.BEDROCK_CLAUDE_3_SONNET_DOCS_LINK = 'https://github.com/opensearch-project/dashboards-flow-framework/blob/main/documentation/models.md#claude-3-sonnet-hosted-on-amazon-bedrock';
const OPENAI_GPT35_DOCS_LINK = exports.OPENAI_GPT35_DOCS_LINK = 'https://github.com/opensearch-project/dashboards-flow-framework/blob/main/documentation/models.md#openai-gpt-35';
const DEEPSEEK_CHAT_DOCS_LINK = exports.DEEPSEEK_CHAT_DOCS_LINK = 'https://github.com/opensearch-project/dashboards-flow-framework/blob/main/documentation/models.md#deepseek-chat';

// Embedding Models Documentation Links
const COHERE_EMBEDDING_MODEL_DOCS_LINK = exports.COHERE_EMBEDDING_MODEL_DOCS_LINK = 'https://github.com/opensearch-project/dashboards-flow-framework/blob/main/documentation/models.md#cohere-embed';
const BEDROCK_TITAN_EMBEDDING_DOCS_LINK = exports.BEDROCK_TITAN_EMBEDDING_DOCS_LINK = 'https://github.com/opensearch-project/dashboards-flow-framework/blob/main/documentation/models.md#amazon-bedrock-titan-text-embedding';

// Sparse Encoder Models Documentation Links
const OPENSEARCH_NEURAL_SPARSE_DOCS_LINK = exports.OPENSEARCH_NEURAL_SPARSE_DOCS_LINK = 'https://huggingface.co/opensearch-project/opensearch-neural-sparse-encoding-v2-distill';

// TODO: Update this with the official OpenSearch documentation URL when it's available
const SAGEMAKER_SPARSE_DEPLOY_LINK = exports.SAGEMAKER_SPARSE_DEPLOY_LINK = 'https://github.com/zhichao-aws/opensearch-neural-sparse-sample/tree/main/examples/deploy_on_sagemaker';

// ML Models setup Documentation Link
const ML_MODELS_SETUP_DOCS_LINK = exports.ML_MODELS_SETUP_DOCS_LINK = 'https://github.com/opensearch-project/dashboards-flow-framework/blob/main/documentation/models.md';

/**
 * Text chunking algorithm constants
 */
let TEXT_CHUNKING_ALGORITHM = exports.TEXT_CHUNKING_ALGORITHM = /*#__PURE__*/function (TEXT_CHUNKING_ALGORITHM) {
  TEXT_CHUNKING_ALGORITHM["FIXED_TOKEN_LENGTH"] = "fixed_token_length";
  TEXT_CHUNKING_ALGORITHM["DELIMITER"] = "delimiter";
  return TEXT_CHUNKING_ALGORITHM;
}({});
const FIXED_TOKEN_LENGTH_OPTIONAL_FIELDS = exports.FIXED_TOKEN_LENGTH_OPTIONAL_FIELDS = ['token_limit', 'tokenizer', 'overlap_rate'];
const DELIMITER_OPTIONAL_FIELDS = exports.DELIMITER_OPTIONAL_FIELDS = ['delimiter'];
const SHARED_OPTIONAL_FIELDS = exports.SHARED_OPTIONAL_FIELDS = ['max_chunk_limit', 'description', 'tag'];

/**
 * DEFAULT FIELD VALUES
 */
const DEFAULT_TEXT_FIELD = exports.DEFAULT_TEXT_FIELD = 'my_text';
const DEFAULT_VECTOR_FIELD = exports.DEFAULT_VECTOR_FIELD = 'my_embedding';
const DEFAULT_IMAGE_FIELD = exports.DEFAULT_IMAGE_FIELD = 'my_image';
const DEFAULT_LLM_RESPONSE_FIELD = exports.DEFAULT_LLM_RESPONSE_FIELD = 'llm_response';

/**
 * QUERY PRESETS
 */
const VECTOR_FIELD_PATTERN = exports.VECTOR_FIELD_PATTERN = `{{vector_field}}`;
const TEXT_FIELD_PATTERN = exports.TEXT_FIELD_PATTERN = `{{text_field}}`;
const IMAGE_FIELD_PATTERN = exports.IMAGE_FIELD_PATTERN = `{{image_field}}`;
const LABEL_FIELD_PATTERN = exports.LABEL_FIELD_PATTERN = `{{label_field}}`;
const QUERY_TEXT_PATTERN = exports.QUERY_TEXT_PATTERN = `{{query_text}}`;
const QUERY_IMAGE_PATTERN = exports.QUERY_IMAGE_PATTERN = `{{query_image}}`;
const MODEL_ID_PATTERN = exports.MODEL_ID_PATTERN = `{{model_id}}`;
const AGENT_ID_PATTERN = exports.AGENT_ID_PATTERN = `{{agent_id}}`;
const VECTOR = exports.VECTOR = 'vector';
const VECTOR_PATTERN = exports.VECTOR_PATTERN = `{{${VECTOR}}}`;
const VECTOR_TEMPLATE_PLACEHOLDER = exports.VECTOR_TEMPLATE_PLACEHOLDER = `\$\{${VECTOR}\}`;
const DEFAULT_K = exports.DEFAULT_K = 10;
const DEFAULT_FETCH_SIZE = exports.DEFAULT_FETCH_SIZE = 10;

// term-level queries
const TERM_QUERY_TEXT = exports.TERM_QUERY_TEXT = {
  query: {
    term: {
      [TEXT_FIELD_PATTERN]: {
        value: QUERY_TEXT_PATTERN
      }
    }
  }
};
const EXISTS_QUERY_TEXT = exports.EXISTS_QUERY_TEXT = {
  query: {
    exists: {
      field: TEXT_FIELD_PATTERN
    }
  }
};
const FUZZY_QUERY_TEXT = exports.FUZZY_QUERY_TEXT = {
  query: {
    fuzzy: {
      [TEXT_FIELD_PATTERN]: {
        value: QUERY_TEXT_PATTERN
      }
    }
  }
};
const WILDCARD_QUERY_TEXT = exports.WILDCARD_QUERY_TEXT = {
  query: {
    wildcard: {
      [TEXT_FIELD_PATTERN]: {
        wildcard: QUERY_TEXT_PATTERN,
        case_insensitive: false
      }
    }
  }
};
const PREFIX_QUERY_TEXT = exports.PREFIX_QUERY_TEXT = {
  query: {
    prefix: {
      [TEXT_FIELD_PATTERN]: {
        value: QUERY_TEXT_PATTERN
      }
    }
  }
};
// full-text queries
const MATCH_QUERY_TEXT = exports.MATCH_QUERY_TEXT = {
  query: {
    match: {
      [TEXT_FIELD_PATTERN]: {
        query: QUERY_TEXT_PATTERN
      }
    }
  }
};
const MATCH_BOOLEAN_QUERY_TEXT = exports.MATCH_BOOLEAN_QUERY_TEXT = {
  query: {
    match_bool_prefix: {
      [TEXT_FIELD_PATTERN]: {
        query: QUERY_TEXT_PATTERN
      }
    }
  }
};
const MATCH_PHRASE_QUERY_TEXT = exports.MATCH_PHRASE_QUERY_TEXT = {
  query: {
    match_phrase: {
      [TEXT_FIELD_PATTERN]: {
        query: QUERY_TEXT_PATTERN
      }
    }
  }
};
const MATCH_PHRASE_PREFIX_QUERY_TEXT = exports.MATCH_PHRASE_PREFIX_QUERY_TEXT = {
  query: {
    match_phrase_prefix: {
      [TEXT_FIELD_PATTERN]: {
        query: QUERY_TEXT_PATTERN
      }
    }
  }
};
const QUERY_STRING_QUERY_TEXT = exports.QUERY_STRING_QUERY_TEXT = {
  query: {
    query_string: {
      query: QUERY_TEXT_PATTERN
    }
  }
};
// misc / other queries
const FETCH_ALL_QUERY = exports.FETCH_ALL_QUERY = {
  query: {
    match_all: {}
  },
  size: DEFAULT_FETCH_SIZE
};
const FETCH_ALL_QUERY_LARGE = exports.FETCH_ALL_QUERY_LARGE = {
  query: {
    match_all: {}
  },
  size: 1000
};
const KNN_QUERY = exports.KNN_QUERY = {
  _source: {
    excludes: [VECTOR_FIELD_PATTERN]
  },
  query: {
    knn: {
      [VECTOR_FIELD_PATTERN]: {
        vector: VECTOR_PATTERN,
        k: DEFAULT_K
      }
    }
  },
  size: 10
};
const SEMANTIC_SEARCH_QUERY_NEURAL = exports.SEMANTIC_SEARCH_QUERY_NEURAL = {
  _source: {
    excludes: [VECTOR_FIELD_PATTERN]
  },
  query: {
    neural: {
      [VECTOR_FIELD_PATTERN]: {
        query_text: QUERY_TEXT_PATTERN,
        model_id: MODEL_ID_PATTERN,
        k: DEFAULT_K
      }
    }
  }
};
const SEMANTIC_SEARCH_TEMPLATE_QUERY = exports.SEMANTIC_SEARCH_TEMPLATE_QUERY = {
  query: {
    template: {
      knn: {
        [VECTOR_FIELD_PATTERN]: {
          vector: VECTOR_PATTERN,
          k: 2
        }
      }
    }
  },
  ext: {
    ml_inference: {
      text: QUERY_TEXT_PATTERN
    }
  }
};
const MULTIMODAL_SEARCH_QUERY_NEURAL = exports.MULTIMODAL_SEARCH_QUERY_NEURAL = {
  _source: {
    excludes: [VECTOR_FIELD_PATTERN]
  },
  query: {
    neural: {
      [VECTOR_FIELD_PATTERN]: {
        query_text: QUERY_TEXT_PATTERN,
        query_image: QUERY_IMAGE_PATTERN,
        model_id: MODEL_ID_PATTERN,
        k: DEFAULT_K
      }
    }
  }
};
const MULTIMODAL_SEARCH_QUERY_BOOL = exports.MULTIMODAL_SEARCH_QUERY_BOOL = {
  query: {
    bool: {
      must: [{
        match: {
          [TEXT_FIELD_PATTERN]: QUERY_TEXT_PATTERN
        }
      }, {
        match: {
          [IMAGE_FIELD_PATTERN]: QUERY_IMAGE_PATTERN
        }
      }]
    }
  }
};
const HYBRID_SEARCH_QUERY_MATCH_KNN = exports.HYBRID_SEARCH_QUERY_MATCH_KNN = {
  _source: {
    excludes: [VECTOR_FIELD_PATTERN]
  },
  query: {
    hybrid: {
      queries: [{
        match: {
          [TEXT_FIELD_PATTERN]: {
            query: QUERY_TEXT_PATTERN
          }
        }
      }, {
        knn: {
          [VECTOR_FIELD_PATTERN]: {
            vector: VECTOR_PATTERN,
            k: DEFAULT_K
          }
        }
      }]
    }
  }
};
const HYBRID_SEARCH_QUERY_MATCH_NEURAL = exports.HYBRID_SEARCH_QUERY_MATCH_NEURAL = {
  _source: {
    excludes: [VECTOR_FIELD_PATTERN]
  },
  query: {
    hybrid: {
      queries: [{
        match: {
          [TEXT_FIELD_PATTERN]: {
            query: QUERY_TEXT_PATTERN
          }
        }
      }, {
        neural: {
          [VECTOR_FIELD_PATTERN]: {
            query_text: QUERY_TEXT_PATTERN,
            model_id: MODEL_ID_PATTERN,
            k: DEFAULT_K
          }
        }
      }]
    }
  }
};
const HYBRID_SEARCH_QUERY_MATCH_TERM = exports.HYBRID_SEARCH_QUERY_MATCH_TERM = {
  _source: {
    excludes: [VECTOR_FIELD_PATTERN]
  },
  query: {
    hybrid: {
      queries: [{
        match: {
          [TEXT_FIELD_PATTERN]: {
            query: QUERY_TEXT_PATTERN
          }
        }
      }, {
        term: {
          [TEXT_FIELD_PATTERN]: {
            value: QUERY_TEXT_PATTERN
          }
        }
      }]
    }
  }
};
const NEURAL_SPARSE_SEARCH_QUERY = exports.NEURAL_SPARSE_SEARCH_QUERY = {
  _source: {
    excludes: [VECTOR_FIELD_PATTERN]
  },
  query: {
    neural_sparse: {
      [VECTOR_FIELD_PATTERN]: {
        query_tokens: VECTOR_PATTERN
      }
    }
  }
};
const AGENTIC_SEARCH_QUERY = exports.AGENTIC_SEARCH_QUERY = {
  query: {
    agentic: {
      query_text: '',
      query_fields: []
    }
  }
};
const QUERY_PRESETS = exports.QUERY_PRESETS = [{
  name: 'Fetch all',
  query: (0, _utils.customStringify)(FETCH_ALL_QUERY)
}, {
  name: 'Term',
  query: (0, _utils.customStringify)(TERM_QUERY_TEXT)
}, {
  name: 'Match',
  query: (0, _utils.customStringify)(MATCH_QUERY_TEXT)
}, {
  name: 'Exists',
  query: (0, _utils.customStringify)(EXISTS_QUERY_TEXT)
}, {
  name: 'Fuzzy',
  query: (0, _utils.customStringify)(FUZZY_QUERY_TEXT)
}, {
  name: 'Wildcard',
  query: (0, _utils.customStringify)(WILDCARD_QUERY_TEXT)
}, {
  name: 'Prefix',
  query: (0, _utils.customStringify)(PREFIX_QUERY_TEXT)
}, {
  name: 'Match boolean',
  query: (0, _utils.customStringify)(MATCH_BOOLEAN_QUERY_TEXT)
}, {
  name: 'Match phrase',
  query: (0, _utils.customStringify)(MATCH_PHRASE_QUERY_TEXT)
}, {
  name: 'Match phrase prefix',
  query: (0, _utils.customStringify)(MATCH_PHRASE_PREFIX_QUERY_TEXT)
}, {
  name: 'Query string',
  query: (0, _utils.customStringify)(QUERY_STRING_QUERY_TEXT)
}, {
  name: 'Basic k-NN',
  query: (0, _utils.customStringify)(KNN_QUERY)
}, {
  name: WORKFLOW_TYPE.MULTIMODAL_SEARCH,
  query: (0, _utils.customStringify)(MULTIMODAL_SEARCH_QUERY_BOOL)
}, {
  name: 'Neural Sparse Search Query',
  query: (0, _utils.customStringify)(NEURAL_SPARSE_SEARCH_QUERY)
}, {
  name: 'Semantic search (neural query)',
  query: (0, _utils.customStringify)(SEMANTIC_SEARCH_QUERY_NEURAL)
}, {
  name: 'Semantic search (template query)',
  query: (0, _utils.customStringify)(SEMANTIC_SEARCH_TEMPLATE_QUERY)
}, {
  name: `Hybrid search (match & k-NN queries)`,
  query: (0, _utils.customStringify)(HYBRID_SEARCH_QUERY_MATCH_KNN)
}, {
  name: `Hybrid search (match & term queries)`,
  query: (0, _utils.customStringify)(HYBRID_SEARCH_QUERY_MATCH_TERM)
}, {
  name: 'Agentic search',
  query: (0, _utils.customStringify)(AGENTIC_SEARCH_QUERY)
}];

/**
 * DEFAULT TEMPLATE VAR NAMES
 */
const DEFAULT_PROMPT_RESULTS_FIELD = exports.DEFAULT_PROMPT_RESULTS_FIELD = 'results';
const DEFAULT_PROMPT_QUESTION_FIELD = exports.DEFAULT_PROMPT_QUESTION_FIELD = 'question';
const DEFAULT_PROMPT_TEXT_CATEGORY_FIELD = exports.DEFAULT_PROMPT_TEXT_CATEGORY_FIELD = 'textCategory';
const DEFAULT_PROMPT_ROLE_FIELD = exports.DEFAULT_PROMPT_ROLE_FIELD = 'role';

/**
 * PROMPT PRESETS. Based off of https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-templates-and-examples.html
 */
const GENERAL_SUMMARIZE_PROMPT = exports.GENERAL_SUMMARIZE_PROMPT = 'Read the following text: \
\n\n${parameters.' + DEFAULT_PROMPT_RESULTS_FIELD + '.toString()} \
\n\nSummarize the text in one sentence.';
const GENERAL_QA_WITH_CONTEXT_PROMPT = exports.GENERAL_QA_WITH_CONTEXT_PROMPT = 'Read the following text, and answer the question at the end: \
\n\n${parameters.' + DEFAULT_PROMPT_RESULTS_FIELD + '.toString()} \
\n\n${parameters.' + DEFAULT_PROMPT_QUESTION_FIELD + '.toString()}';
const GENERAL_QA_NO_CONTEXT_PROMPT = exports.GENERAL_QA_NO_CONTEXT_PROMPT = 'Answer the following question: \
${parameters.' + DEFAULT_PROMPT_QUESTION_FIELD + '.toString()}';
const GENERAL_TEXT_GENERATION_PROMPT = exports.GENERAL_TEXT_GENERATION_PROMPT = 'Please write a ${parameters.' + DEFAULT_PROMPT_TEXT_CATEGORY_FIELD + '.toString()} in the voice of ${parameters.' + DEFAULT_PROMPT_ROLE_FIELD + '.toString()}';
const CLAUDE_SUMMARIZE_PROMPT = exports.CLAUDE_SUMMARIZE_PROMPT = 'Human: read the following results inside the <text></text> XML tags:\n\n<text>\n\
${parameters.' + DEFAULT_PROMPT_RESULTS_FIELD + ".toString()}\n</text>\n\n\
Summarize the above results in one sentence. If you don't know the answer, just \
say I don't know.\
\n\nAssistant:";
const CLAUDE_QA_WITH_CONTEXT_PROMPT = exports.CLAUDE_QA_WITH_CONTEXT_PROMPT = 'Human: read the following results inside the <text></text> XML tags, and then answer the question:\
\n\n<text>\n\
${parameters.' + DEFAULT_PROMPT_RESULTS_FIELD + '.toString()}\n\
</text>\n\n' + '${parameters.' + DEFAULT_PROMPT_QUESTION_FIELD + '.toString()}\n\nAssistant:';
const PROMPT_PRESETS = exports.PROMPT_PRESETS = [{
  name: 'Summarize text',
  prompt: GENERAL_SUMMARIZE_PROMPT
}, {
  name: 'Question-answer, with context',
  prompt: GENERAL_QA_WITH_CONTEXT_PROMPT
}, {
  name: 'Question-answer, without context',
  prompt: GENERAL_QA_NO_CONTEXT_PROMPT
}, {
  name: 'Text generation',
  prompt: GENERAL_TEXT_GENERATION_PROMPT
}, {
  name: 'Summarize text (Claude)',
  prompt: CLAUDE_SUMMARIZE_PROMPT
}, {
  name: 'Question-answer, with context (Claude)',
  prompt: CLAUDE_QA_WITH_CONTEXT_PROMPT
}];

/**
 * MISCELLANEOUS
 */
let PROCESSOR_CONTEXT = exports.PROCESSOR_CONTEXT = /*#__PURE__*/function (PROCESSOR_CONTEXT) {
  PROCESSOR_CONTEXT["INGEST"] = "ingest";
  PROCESSOR_CONTEXT["SEARCH_REQUEST"] = "search_request";
  PROCESSOR_CONTEXT["SEARCH_RESPONSE"] = "search_response";
  return PROCESSOR_CONTEXT;
}({});
const NO_TRANSFORMATION = exports.NO_TRANSFORMATION = 'No transformation';
let TRANSFORM_CONTEXT = exports.TRANSFORM_CONTEXT = /*#__PURE__*/function (TRANSFORM_CONTEXT) {
  TRANSFORM_CONTEXT["INPUT"] = "input";
  TRANSFORM_CONTEXT["OUTPUT"] = "output";
  return TRANSFORM_CONTEXT;
}({});
let TRANSFORM_TYPE = exports.TRANSFORM_TYPE = /*#__PURE__*/function (TRANSFORM_TYPE) {
  TRANSFORM_TYPE["STRING"] = "Custom string";
  TRANSFORM_TYPE["FIELD"] = "Data field";
  TRANSFORM_TYPE["EXPRESSION"] = "JSONPath expression";
  TRANSFORM_TYPE["TEMPLATE"] = "Prompt";
  return TRANSFORM_TYPE;
}({});
const INPUT_TRANSFORM_OPTIONS = exports.INPUT_TRANSFORM_OPTIONS = [{
  id: TRANSFORM_TYPE.FIELD,
  description: 'Use an existing field from your data as the model input field.'
}, {
  id: TRANSFORM_TYPE.EXPRESSION,
  description: 'Extract data from a JSON structure and map the extracted data to the model input field.'
}, {
  id: TRANSFORM_TYPE.TEMPLATE,
  description: 'Configure a prompt to map data to the model input field.'
}, {
  id: TRANSFORM_TYPE.STRING,
  description: 'Use a custom string in the model input field.'
}];
const OUTPUT_TRANSFORM_OPTIONS = exports.OUTPUT_TRANSFORM_OPTIONS = [{
  id: NO_TRANSFORMATION,
  description: ''
}, {
  id: TRANSFORM_TYPE.FIELD,
  description: 'Copy the model output into a new document field.'
}, {
  id: TRANSFORM_TYPE.EXPRESSION,
  description: 'Extract data from a JSON structure and map the extracted data to a new document field.'
}];
const ABORT_SEARCH_ERROR_MESSAGE = exports.ABORT_SEARCH_ERROR_MESSAGE = 'Error searching index: signal is aborted without reason';
const DEFAULT_NEW_WORKFLOW_NAME = exports.DEFAULT_NEW_WORKFLOW_NAME = 'new_workflow';
const DEFAULT_NEW_WORKFLOW_DESCRIPTION = exports.DEFAULT_NEW_WORKFLOW_DESCRIPTION = 'My new workflow';
const DEFAULT_NEW_WORKFLOW_STATE_TYPE = exports.DEFAULT_NEW_WORKFLOW_STATE_TYPE = 'NOT_STARTED';
const DATE_FORMAT_PATTERN = exports.DATE_FORMAT_PATTERN = 'MM/DD/YY hh:mm A';
const EMPTY_FIELD_STRING = exports.EMPTY_FIELD_STRING = '--';
const OMIT_SYSTEM_INDEX_PATTERN = exports.OMIT_SYSTEM_INDEX_PATTERN = '*,-.*';
const INDEX_NOT_FOUND_EXCEPTION = exports.INDEX_NOT_FOUND_EXCEPTION = 'index_not_found_exception';
const ERROR_GETTING_WORKFLOW_MSG = exports.ERROR_GETTING_WORKFLOW_MSG = 'Failed to retrieve template';
const INVALID_DATASOURCE_MSG = exports.INVALID_DATASOURCE_MSG = 'No Living connections';
const NO_TEMPLATES_FOUND_MSG = exports.NO_TEMPLATES_FOUND_MSG = 'There are no templates';
const NO_MODIFICATIONS_FOUND_TEXT = exports.NO_MODIFICATIONS_FOUND_TEXT = 'Template does not contain any modifications';
const JSONPATH_ROOT_SELECTOR = exports.JSONPATH_ROOT_SELECTOR = '$';
const REQUEST_PREFIX = exports.REQUEST_PREFIX = '_request.';
const REQUEST_PREFIX_WITH_JSONPATH_ROOT_SELECTOR = exports.REQUEST_PREFIX_WITH_JSONPATH_ROOT_SELECTOR = '$._request.';
const WORKFLOW_NAME_RESTRICTIONS = exports.WORKFLOW_NAME_RESTRICTIONS = 'Invalid workflow name. Valid characters are a-z, A-Z, 0-9, -(hyphen), _(underscore).';
let SORT_ORDER = exports.SORT_ORDER = /*#__PURE__*/function (SORT_ORDER) {
  SORT_ORDER["ASC"] = "asc";
  SORT_ORDER["DESC"] = "desc";
  return SORT_ORDER;
}({});
const MAX_DOCS = exports.MAX_DOCS = 1000;
const MAX_DOCS_TO_IMPORT = exports.MAX_DOCS_TO_IMPORT = 100;
const MAX_STRING_LENGTH = exports.MAX_STRING_LENGTH = 100;
const MAX_DESCRIPTION_LENGTH = exports.MAX_DESCRIPTION_LENGTH = 1000;
const MAX_JSON_STRING_LENGTH = exports.MAX_JSON_STRING_LENGTH = 10000;
const MAX_TEMPLATE_STRING_LENGTH = exports.MAX_TEMPLATE_STRING_LENGTH = 10000;
const MAX_BYTES = exports.MAX_BYTES = 1048576; // OSD REST request payload size limit
const MAX_BYTES_FORMATTED = exports.MAX_BYTES_FORMATTED = '1,048,576';
const MAX_WORKFLOW_NAME_TO_DISPLAY = exports.MAX_WORKFLOW_NAME_TO_DISPLAY = 40;
const WORKFLOW_NAME_REGEXP = exports.WORKFLOW_NAME_REGEXP = RegExp('^[a-zA-Z0-9_-]*$');
const INDEX_NAME_REGEXP = exports.INDEX_NAME_REGEXP = WORKFLOW_NAME_REGEXP;
const PROVISION_TIMEOUT = exports.PROVISION_TIMEOUT = '10s'; // the timeout config for synchronous provisioning. https://github.com/opensearch-project/flow-framework/pull/990
const EMPTY_MAP_ENTRY = exports.EMPTY_MAP_ENTRY = {
  key: '',
  value: ''
};
const EMPTY_INPUT_MAP_ENTRY = exports.EMPTY_INPUT_MAP_ENTRY = {
  key: '',
  value: {
    transformType: TRANSFORM_TYPE.FIELD,
    value: ''
  }
};
const EMPTY_OUTPUT_MAP_ENTRY = exports.EMPTY_OUTPUT_MAP_ENTRY = {
  ...EMPTY_INPUT_MAP_ENTRY,
  value: {
    ...EMPTY_INPUT_MAP_ENTRY.value,
    transformType: NO_TRANSFORMATION
  }
};
const MODEL_OUTPUT_SCHEMA_NESTED_PATH = exports.MODEL_OUTPUT_SCHEMA_NESTED_PATH = 'output.properties.inference_results.items.properties.output.items.properties.dataAsMap.properties';
const MODEL_OUTPUT_SCHEMA_FULL_PATH = exports.MODEL_OUTPUT_SCHEMA_FULL_PATH = 'output.properties';
let CONFIG_STEP = exports.CONFIG_STEP = /*#__PURE__*/function (CONFIG_STEP) {
  CONFIG_STEP["INGEST"] = "Ingest pipeline";
  CONFIG_STEP["SEARCH"] = "Search pipeline";
  return CONFIG_STEP;
}({});
let SOURCE_OPTIONS = exports.SOURCE_OPTIONS = /*#__PURE__*/function (SOURCE_OPTIONS) {
  SOURCE_OPTIONS["MANUAL"] = "manual";
  SOURCE_OPTIONS["UPLOAD"] = "upload";
  SOURCE_OPTIONS["EXISTING_INDEX"] = "existing_index";
  return SOURCE_OPTIONS;
}({});
let INSPECTOR_TAB_ID = exports.INSPECTOR_TAB_ID = /*#__PURE__*/function (INSPECTOR_TAB_ID) {
  INSPECTOR_TAB_ID["TEST"] = "test";
  INSPECTOR_TAB_ID["INGEST"] = "ingest";
  INSPECTOR_TAB_ID["ERRORS"] = "errors";
  INSPECTOR_TAB_ID["RESOURCES"] = "resources";
  INSPECTOR_TAB_ID["PREVIEW"] = "preview";
  return INSPECTOR_TAB_ID;
}({});
const INSPECTOR_TABS = exports.INSPECTOR_TABS = [{
  id: INSPECTOR_TAB_ID.TEST,
  name: 'Agentic search',
  disabled: false
}, {
  id: INSPECTOR_TAB_ID.INGEST,
  name: 'Ingest response',
  disabled: false
}, {
  id: INSPECTOR_TAB_ID.ERRORS,
  name: 'Errors',
  disabled: false
}, {
  id: INSPECTOR_TAB_ID.RESOURCES,
  name: 'Resources',
  disabled: false
}, {
  id: INSPECTOR_TAB_ID.PREVIEW,
  name: 'Preview',
  disabled: false
}];

// component IDs for each left nav component. Some may be tied
// to the lower-level form, others are for visual flow purposes only,
// like 'retrieveFromDataSource' and 'searchResults'
let COMPONENT_ID = exports.COMPONENT_ID = /*#__PURE__*/function (COMPONENT_ID) {
  COMPONENT_ID["SOURCE_DATA"] = "ingest.docs";
  COMPONENT_ID["ENRICH_DATA"] = "ingest.enrich";
  COMPONENT_ID["INGEST_DATA"] = "ingest.index";
  COMPONENT_ID["SEARCH_REQUEST"] = "search.request";
  COMPONENT_ID["ENRICH_SEARCH_REQUEST"] = "search.enrichRequest";
  COMPONENT_ID["RUN_QUERY"] = "runQuery";
  COMPONENT_ID["ENRICH_SEARCH_RESPONSE"] = "search.enrichResponse";
  COMPONENT_ID["SEARCH_RESULTS"] = "searchResults";
  return COMPONENT_ID;
}({}); // We have to persist a standalone string to override 'style' component, as setting className does
// not override the default styles from the EuiCard component.
const LEFT_NAV_SELECTED_STYLE = exports.LEFT_NAV_SELECTED_STYLE = '2px solid rgba(128, 128, 128, 0.8)';

/**
 * Agents / tools constants
 */

// Derived from https://docs.opensearch.org/latest/ml-commons-plugin/agents-tools/agents/index/
let AGENT_TYPE = exports.AGENT_TYPE = /*#__PURE__*/function (AGENT_TYPE) {
  AGENT_TYPE["FLOW"] = "flow";
  AGENT_TYPE["CONVERSATIONAL"] = "conversational";
  return AGENT_TYPE;
}({}); // TODO: add back PER when there is concrete examples / models to give to users as reference
// PLAN_EXECUTE_REFLECT = 'plan_execute_and_reflect',
// Tool types supported by agents.
// Derived from https://docs.opensearch.org/latest/ml-commons-plugin/agents-tools/tools/index/
let TOOL_TYPE = exports.TOOL_TYPE = /*#__PURE__*/function (TOOL_TYPE) {
  TOOL_TYPE["QUERY_PLANNING"] = "QueryPlanningTool";
  TOOL_TYPE["SEARCH_INDEX"] = "SearchIndexTool";
  TOOL_TYPE["LIST_INDEX"] = "ListIndexTool";
  TOOL_TYPE["INDEX_MAPPING"] = "IndexMappingTool";
  TOOL_TYPE["WEB_SEARCH"] = "WebSearchTool";
  return TOOL_TYPE;
}({});
let TOOL_DESCRIPTION = exports.TOOL_DESCRIPTION = /*#__PURE__*/function (TOOL_DESCRIPTION) {
  TOOL_DESCRIPTION["QUERY_PLANNING"] = "Generates an OpenSearch query domain-specific language (DSL) query from a natural language question";
  TOOL_DESCRIPTION["SEARCH_INDEX"] = "Searches an index using a query written in query domain-specific language (DSL)";
  TOOL_DESCRIPTION["LIST_INDEX"] = "Retrieves index information for the OpenSearch cluster";
  TOOL_DESCRIPTION["INDEX_MAPPING"] = "Retrieves index mapping and setting information for an index";
  TOOL_DESCRIPTION["WEB_SEARCH"] = "Answers a user\u2019s question using a web search";
  return TOOL_DESCRIPTION;
}({}); // Memory types supported by agents.
// Derived from https://docs.opensearch.org/latest/ml-commons-plugin/api/agent-apis/register-agent/
let AGENT_MEMORY_TYPE = exports.AGENT_MEMORY_TYPE = /*#__PURE__*/function (AGENT_MEMORY_TYPE) {
  AGENT_MEMORY_TYPE["CONVERSATION_INDEX"] = "conversation_index";
  return AGENT_MEMORY_TYPE;
}({});
let CONNECTOR_PROTOCOL = exports.CONNECTOR_PROTOCOL = /*#__PURE__*/function (CONNECTOR_PROTOCOL) {
  CONNECTOR_PROTOCOL["AWS_SIGV4"] = "aws_sigv4";
  CONNECTOR_PROTOCOL["HTTP"] = "http";
  CONNECTOR_PROTOCOL["MCP_SSE"] = "mcp_sse";
  CONNECTOR_PROTOCOL["MCP_STREAMABLE_HTTP"] = "mcp_streamable_http";
  return CONNECTOR_PROTOCOL;
}({});
let AGENT_LLM_INTERFACE_TYPE = exports.AGENT_LLM_INTERFACE_TYPE = /*#__PURE__*/function (AGENT_LLM_INTERFACE_TYPE) {
  AGENT_LLM_INTERFACE_TYPE["OPENAI"] = "openai/v1/chat/completions";
  AGENT_LLM_INTERFACE_TYPE["BEDROCK_CLAUDE"] = "bedrock/converse/claude";
  AGENT_LLM_INTERFACE_TYPE["BEDROCK_DEEPSEEK"] = "bedrock/converse/deepseek_r1";
  return AGENT_LLM_INTERFACE_TYPE;
}({});
let RESPONSE_FILTER_TYPE = exports.RESPONSE_FILTER_TYPE = /*#__PURE__*/function (RESPONSE_FILTER_TYPE) {
  RESPONSE_FILTER_TYPE["OPENAI"] = "$.choices[0].message.content";
  RESPONSE_FILTER_TYPE["BEDROCK_CLAUDE"] = "$.output.message.content[0].text";
  return RESPONSE_FILTER_TYPE;
}({});
const NEW_AGENT_PLACEHOLDER = exports.NEW_AGENT_PLACEHOLDER = 'new_agent';
const NEW_AGENT_ID_PLACEHOLDER = exports.NEW_AGENT_ID_PLACEHOLDER = 'New agent (unsaved)';
const AGENT_ID_PATH = exports.AGENT_ID_PATH = 'search.requestAgentId';
const EMPTY_AGENT = exports.EMPTY_AGENT = {
  type: '',
  name: '',
  description: '',
  tools: [],
  llm: {
    model_id: ''
  },
  parameters: {
    _llm_interface: ''
  }
};
const DEFAULT_AGENT = exports.DEFAULT_AGENT = {
  ...EMPTY_AGENT,
  type: AGENT_TYPE.CONVERSATIONAL,
  name: 'My agent',
  description: '',
  tools: [{
    type: TOOL_TYPE.QUERY_PLANNING
  }],
  memory: {
    type: AGENT_MEMORY_TYPE.CONVERSATION_INDEX
  }
};
const DEFAULT_MCP_SERVER = exports.DEFAULT_MCP_SERVER = {
  mcp_connector_id: '',
  tool_filters: []
};
const EXAMPLE_PUT_AGENTIC_SEARCH_PIPELINE = exports.EXAMPLE_PUT_AGENTIC_SEARCH_PIPELINE = `PUT _search/pipeline/agentic-pipeline
{
  "request_processors": [
    {
      "agentic_query_translator": {
        "agent_id": "${AGENT_ID_PATTERN}"
      }
    }
  ],
  "response_processors": [
    {
      "agentic_context": {
        "agent_steps_summary": true,
        "dsl_query": true
      }
    }
  ]
}`;
const EXAMPLE_AGENTIC_SEARCH_QUERY = exports.EXAMPLE_AGENTIC_SEARCH_QUERY = `GET <your-index>/_search?search_pipeline=agentic-pipeline
{
  "query": {
    "agentic": {
      "query_text": "<your-search-query>",
    }
  }
}`;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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